/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.querydsl.info;

import java.util.ArrayList;
import java.util.List;
import net.apexes.commons.querydsl.info.TableInfo;

public class ForeignKeyInfo {
    private final String name;
    private final String localSchema;
    private final String pkSchema;
    private final String localTable;
    private final String pkTable;
    private final List<String> localColumns = new ArrayList<String>();
    private final List<String> pkColumns = new ArrayList<String>();

    public ForeignKeyInfo(String name, String localTable, String pkTable) {
        this(name, null, localTable, null, pkTable);
    }

    public ForeignKeyInfo(String name, String localSchema, String localTable, String pkSchema, String pkTable) {
        this.name = name;
        this.localSchema = localSchema;
        this.pkSchema = pkSchema;
        this.localTable = localTable;
        this.pkTable = pkTable;
    }

    public void add(String localColumn, String pkColumn) {
        this.localColumns.add(localColumn);
        this.pkColumns.add(pkColumn);
    }

    public String getName() {
        return this.name;
    }

    public String getLocalSchema() {
        return this.localSchema;
    }

    public String getPkSchema() {
        return this.pkSchema;
    }

    public String getLocalTable() {
        return this.localTable;
    }

    public String getPkTable() {
        return this.pkTable;
    }

    public List<String> getLocalColumns() {
        return this.localColumns;
    }

    public List<String> getPkColumns() {
        return this.pkColumns;
    }

    public boolean isSameColumn(ForeignKeyInfo fkInfo) {
        return TableInfo.isEquals(this.localColumns, fkInfo.getLocalColumns()) && TableInfo.isEquals(this.pkColumns, fkInfo.getPkColumns());
    }
}

