/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.querydsl.info;

import java.util.ArrayList;
import java.util.List;
import net.apexes.commons.querydsl.info.IndexColumn;
import net.apexes.commons.querydsl.info.TableInfo;

public class IndexInfo {
    private final String name;
    private final String schema;
    private final String table;
    private final boolean unique;
    private final List<IndexColumn> columns;
    private final List<String> columnNames;
    private boolean primaryKeyIndex;
    private boolean foreignKeyIndex;

    public IndexInfo(String name, String schema, String table, boolean unique) {
        this.name = name;
        this.schema = schema;
        this.table = table;
        this.unique = unique;
        this.columns = new ArrayList<IndexColumn>();
        this.columnNames = new ArrayList<String>();
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public List<IndexColumn> getColumns() {
        return this.columns;
    }

    public void addColumn(IndexColumn column) {
        this.columns.add(column);
        this.columnNames.add(column.getColumnName());
    }

    public boolean isKeyIndex() {
        return this.isPrimaryKeyIndex() || this.isForeignKeyIndex();
    }

    public boolean isPrimaryKeyIndex() {
        return this.primaryKeyIndex;
    }

    public void setPrimaryKeyIndex(boolean primaryKeyIndex) {
        this.primaryKeyIndex = primaryKeyIndex;
    }

    public boolean isForeignKeyIndex() {
        return this.foreignKeyIndex;
    }

    public void setForeignKeyIndex(boolean foreignKeyIndex) {
        this.foreignKeyIndex = foreignKeyIndex;
    }

    public boolean isSame(IndexInfo indexInfo) {
        return this.isUnique() == indexInfo.isUnique() && this.isSameColumn(indexInfo.columnNames);
    }

    public boolean isSameColumn(List<String> columns) {
        return TableInfo.isEquals(this.columnNames, columns);
    }
}

