/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.querydsl.info;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.querydsl.info.ColumnInfo;
import net.apexes.commons.querydsl.info.ForeignKeyInfo;
import net.apexes.commons.querydsl.info.IndexColumn;
import net.apexes.commons.querydsl.info.IndexInfo;
import net.apexes.commons.querydsl.info.PrimaryKeyInfo;

public class TableInfo {
    private static final int FK_COLUMN_NAME = 8;
    private static final int FK_TABLE_NAME = 7;
    private static final int FK_SCHEMA_NAME = 6;
    private static final int FK_NAME = 12;
    private static final int FK_PK_COLUMN_NAME = 4;
    private static final int FK_PK_TABLE_NAME = 3;
    private static final int FK_PK_SCHEMA_NAME = 2;
    private static final int PK_COLUMN_NAME = 4;
    private static final int PK_NAME = 6;
    private final String catalog;
    private final String schema;
    private final String tableName;
    private final boolean lowerCase;
    private final PrimaryKeyInfo primaryKey;
    private final List<ColumnInfo> columns;
    private final List<ForeignKeyInfo> importedKeys;
    private final List<ForeignKeyInfo> exportedKeys;
    private final List<IndexInfo> indexs;

    public TableInfo(DatabaseMetaData md, String catalog, String schema, String tableName) throws SQLException {
        this(md, catalog, schema, tableName, false);
    }

    public TableInfo(DatabaseMetaData md, String catalog, String schema, String tableName, boolean lowerCase) throws SQLException {
        this.catalog = catalog;
        this.schema = schema;
        this.tableName = tableName;
        this.lowerCase = lowerCase;
        this.primaryKey = this.buildPrimaryKey(md);
        this.columns = this.buildColumn(md);
        this.importedKeys = this.buildImportedKeys(md);
        this.exportedKeys = this.buildExportedKeys(md);
        this.indexs = this.buildUniqueKeysAndIndexs(md);
    }

    private PrimaryKeyInfo buildPrimaryKey(DatabaseMetaData md) throws SQLException {
        try (ResultSet rs = md.getPrimaryKeys(this.catalog, this.schema, this.tableName);){
            PrimaryKeyInfo pkInfo = null;
            while (rs.next()) {
                String columnName = TableInfo.normalizeSQLName(rs.getString(4));
                if (pkInfo == null) {
                    String name = rs.getString(6);
                    if (name == null || name.isEmpty()) {
                        name = this.tableName + "_PK";
                    }
                    pkInfo = new PrimaryKeyInfo(name, this.schema, this.tableName);
                }
                pkInfo.add(columnName);
            }
            PrimaryKeyInfo primaryKeyInfo = pkInfo;
            return primaryKeyInfo;
        }
    }

    private List<ColumnInfo> buildColumn(DatabaseMetaData md) throws SQLException {
        try (ResultSet rs = md.getColumns(this.catalog, this.schema, this.tableName.replace("/", "//"), null);){
            ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
            while (rs.next()) {
                String columnName = this.normalize(rs.getString("COLUMN_NAME"));
                String normalizedColumnName = TableInfo.normalizeSQLName(columnName);
                int columnType = rs.getInt("DATA_TYPE");
                String typeName = rs.getString("TYPE_NAME");
                Integer columnSize = (Integer)rs.getObject("COLUMN_SIZE");
                Integer columnDigits = (Integer)rs.getObject("DECIMAL_DIGITS");
                int columnIndex = rs.getInt("ORDINAL_POSITION");
                int nullable = rs.getInt("NULLABLE");
                String defaultValue = rs.getString("COLUMN_DEF");
                String describe = rs.getString("REMARKS");
                list.add(new ColumnInfo(columnName, normalizedColumnName, columnType, typeName, columnSize, columnDigits, columnIndex, nullable, defaultValue, describe));
            }
            ArrayList<ColumnInfo> arrayList = list;
            return arrayList;
        }
    }

    private List<ForeignKeyInfo> buildImportedKeys(DatabaseMetaData md) throws SQLException {
        try (ResultSet rs = md.getImportedKeys(this.catalog, this.schema, this.tableName);){
            TreeMap<String, ForeignKeyInfo> map = new TreeMap<String, ForeignKeyInfo>();
            while (rs.next()) {
                ForeignKeyInfo fkInfo;
                String name = rs.getString(12);
                String pkSchemaName = TableInfo.normalizeSQLName(rs.getString(2));
                String pkTableName = TableInfo.normalizeSQLName(rs.getString(3));
                String pkColumnName = TableInfo.normalizeSQLName(rs.getString(4));
                String localSchemaName = TableInfo.normalizeSQLName(rs.getString(6));
                String localTableName = TableInfo.normalizeSQLName(rs.getString(7));
                String localColumn = TableInfo.normalizeSQLName(rs.getString(8));
                if (name == null || name.isEmpty()) {
                    name = this.tableName + "_" + pkTableName + "_FK";
                }
                if ((fkInfo = (ForeignKeyInfo)map.get(name)) == null) {
                    fkInfo = new ForeignKeyInfo(name, localSchemaName, localTableName, pkSchemaName, pkTableName);
                    map.put(name, fkInfo);
                }
                fkInfo.add(localColumn, pkColumnName);
            }
            ArrayList<ForeignKeyInfo> arrayList = new ArrayList<ForeignKeyInfo>(map.values());
            return arrayList;
        }
    }

    private List<ForeignKeyInfo> buildExportedKeys(DatabaseMetaData md) throws SQLException {
        try (ResultSet rs = md.getExportedKeys(this.catalog, this.schema, this.tableName);){
            TreeMap<String, ForeignKeyInfo> map = new TreeMap<String, ForeignKeyInfo>();
            while (rs.next()) {
                ForeignKeyInfo fkInfo;
                String name = rs.getString(12);
                String pkSchemaName = TableInfo.normalizeSQLName(rs.getString(2));
                String pkTableName = TableInfo.normalizeSQLName(rs.getString(3));
                String pkColumnName = TableInfo.normalizeSQLName(rs.getString(4));
                String foreignSchemaName = TableInfo.normalizeSQLName(rs.getString(6));
                String foreignTableName = TableInfo.normalizeSQLName(rs.getString(7));
                String foreignColumn = TableInfo.normalizeSQLName(rs.getString(8));
                if (name == null || name.isEmpty()) {
                    name = this.tableName + "_" + foreignTableName + "_IFK";
                }
                if ((fkInfo = (ForeignKeyInfo)map.get(name)) == null) {
                    fkInfo = new ForeignKeyInfo(name, foreignSchemaName, foreignTableName, pkSchemaName, pkTableName);
                    map.put(name, fkInfo);
                }
                fkInfo.add(foreignColumn, pkColumnName);
            }
            ArrayList<ForeignKeyInfo> arrayList = new ArrayList<ForeignKeyInfo>(map.values());
            return arrayList;
        }
    }

    private List<IndexInfo> buildUniqueKeysAndIndexs(DatabaseMetaData md) throws SQLException {
        TreeMap<String, IndexInfo> indexInfos = new TreeMap<String, IndexInfo>();
        try (ResultSet rs = md.getIndexInfo(this.catalog, this.schema, this.tableName, false, false);){
            while (rs.next()) {
                String name = rs.getString("INDEX_NAME");
                boolean nonUnique = rs.getBoolean("NON_UNIQUE");
                String ascDesc = rs.getString("ASC_OR_DESC");
                String columnName = TableInfo.normalizeSQLName(rs.getString("COLUMN_NAME"));
                String indexSchemaName = TableInfo.normalizeSQLName(rs.getString("TABLE_SCHEM"));
                String indexTableName = TableInfo.normalizeSQLName(rs.getString("TABLE_NAME"));
                if (name == null || name.isEmpty()) continue;
                IndexInfo idxInfo = (IndexInfo)indexInfos.get(name);
                if (idxInfo == null) {
                    idxInfo = new IndexInfo(name, indexSchemaName, indexTableName, !nonUnique);
                    indexInfos.put(name, idxInfo);
                }
                boolean desc = "D".equalsIgnoreCase(ascDesc);
                idxInfo.addColumn(new IndexColumn(columnName, desc));
            }
        }
        block10: for (IndexInfo ixInfo : indexInfos.values()) {
            if (ixInfo.isSameColumn(this.primaryKey.getColumns())) {
                ixInfo.setPrimaryKeyIndex(true);
                continue;
            }
            for (ForeignKeyInfo fkInfo : this.importedKeys) {
                if (!ixInfo.isSameColumn(fkInfo.getLocalColumns())) continue;
                ixInfo.setForeignKeyIndex(true);
                continue block10;
            }
        }
        return new ArrayList<IndexInfo>(indexInfos.values());
    }

    private String normalize(String str) {
        if (this.lowerCase && str != null) {
            return str.toLowerCase();
        }
        return str;
    }

    public String getTableName() {
        return this.tableName;
    }

    public PrimaryKeyInfo getPrimaryKey() {
        return this.primaryKey;
    }

    public List<ColumnInfo> getColumns() {
        return this.columns;
    }

    public List<ForeignKeyInfo> getImportedKeys() {
        return this.importedKeys;
    }

    public List<ForeignKeyInfo> getExportedKeys() {
        return this.exportedKeys;
    }

    public List<IndexInfo> getIndexs() {
        return this.indexs;
    }

    private static String normalizeSQLName(String name) {
        if (name != null) {
            return name.replaceAll("\r", "").replaceAll("\n", " ");
        }
        return null;
    }

    public static boolean isEquals(List<String> columns1, List<String> columns2) {
        Checks.verifyNotNull(columns1, (String)"columns1");
        Checks.verifyNotNull(columns2, (String)"columns2");
        if (columns1.size() != columns2.size()) {
            return false;
        }
        for (int i = 0; i < columns1.size(); ++i) {
            String name2;
            String name1 = columns1.get(i);
            if (name1.equalsIgnoreCase(name2 = columns2.get(i))) continue;
            return false;
        }
        return true;
    }
}

