/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.querydsl.sql;

import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathMetadataFactory;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.ForeignKey;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.apexes.commons.lang.Enume;
import net.apexes.commons.querydsl.Index;
import net.apexes.commons.querydsl.IndexBuilder;
import net.apexes.commons.querydsl.sql.EnumePath;
import net.apexes.commons.querydsl.sql.QTableBean;

public class TablePathBase<E>
extends RelationalPathBase<E> {
    private static final long serialVersionUID = 1L;
    private final List<Index> indexs = new ArrayList<Index>();
    private final Map<String, String> defaultValues = new HashMap<String, String>();
    private final Map<ForeignKey<?>, String> fkPkTables = new HashMap();
    private transient FactoryExpression<E> projection;

    public TablePathBase(Class<? extends E> type, String variable, String schema, String table) {
        this(type, PathMetadataFactory.forVariable((String)variable), schema, table);
    }

    public TablePathBase(Class<? extends E> type, PathMetadata metadata, String schema, String table) {
        super(type, metadata, schema, table);
    }

    protected <P extends Path<?>> P addMetadata(P path, ColumnMetadata metadata, String defaultValue) {
        this.defaultValues.put(metadata.getName(), defaultValue);
        return (P)super.addMetadata(path, metadata);
    }

    protected <F extends Enume<?>> EnumePath<F> createEnume(String property, Class<F> type) {
        return (EnumePath)this.add((Path)new EnumePath<F>(type, this.forProperty(property)));
    }

    protected IndexBuilder index(String name) {
        return new IndexBuilder((RelationalPath<?>)this, name, this.indexs);
    }

    public List<Index> getIndexs() {
        return Collections.unmodifiableList(this.indexs);
    }

    public String getDefaultValue(String columnName) {
        return this.defaultValues.get(columnName);
    }

    public String getDefaultValue(Path<?> path) {
        String columnName = this.getColumnName(path);
        return this.defaultValues.get(columnName);
    }

    public boolean hasDefaultValue(Path<?> path) {
        String columnName = this.getColumnName(path);
        return this.defaultValues.containsKey(columnName);
    }

    protected <F> ForeignKey<F> createForeignKey(Path<?> local, String pkTable, String pkColumn) {
        ForeignKey foreignKey = super.createForeignKey(local, pkColumn);
        this.fkPkTables.put(foreignKey, pkTable);
        return foreignKey;
    }

    protected <F> ForeignKey<F> createForeignKey(List<? extends Path<?>> local, String pkTable, List<String> pkColumns) {
        ForeignKey foreignKey = super.createForeignKey(local, pkColumns);
        this.fkPkTables.put(foreignKey, pkTable);
        return foreignKey;
    }

    public <F> String getPkTableName(ForeignKey<F> foreignKey) {
        return this.fkPkTables.get(foreignKey);
    }

    public String getColumnName(Path<?> path) {
        return ColumnMetadata.getColumnMetadata(path).getName();
    }

    public FactoryExpression<E> getProjection() {
        if (this.projection == null) {
            this.projection = new QTableBean(this);
        }
        return this.projection;
    }

    public E newEntity() {
        try {
            return (E)this.getType().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object getFieldValue(E entity, String fieldName) {
        try {
            Field field = TablePathBase.findField(entity.getClass(), fieldName);
            return TablePathBase.accessible(field).get(entity);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setFieldValue(E entity, String fieldName, Object value) {
        try {
            Field field = TablePathBase.findField(entity.getClass(), fieldName);
            TablePathBase.accessible(field).set(entity, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Field findField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return TablePathBase.findField(superClass, fieldName);
        }
    }

    private static <T extends AccessibleObject> T accessible(T accessible) {
        if (accessible == null) {
            return null;
        }
        if (!accessible.isAccessible()) {
            accessible.setAccessible(true);
        }
        return accessible;
    }
}

