/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.bean;

public class Pager {
    private int dataTotal;
    private int pageTotal;
    private int offset;
    private int pageSize = 30;
    private int currentPage;

    public Pager() {
    }

    public Pager(Integer offset, Integer pageSize) {
        if (offset != null) {
            this.offset = offset;
        }
        if (pageSize != null) {
            this.pageSize = pageSize;
        }
    }

    public int getDataTotal() {
        return this.dataTotal;
    }

    public void setDataTotal(int dataTotal) {
        this.dataTotal = dataTotal;
    }

    public int getPageTotal() {
        if (this.pageTotal != 0) {
            return this.pageTotal;
        }
        if (this.pageSize == 0) {
            return 0;
        }
        this.pageTotal = this.dataTotal <= this.pageSize ? 1 : (this.dataTotal % this.pageSize == 0 ? this.dataTotal / this.pageSize : this.dataTotal / this.pageSize + 1);
        return this.pageTotal;
    }

    public void setPageTotal(int pageTotal) {
        this.pageTotal = pageTotal;
    }

    public int getOffset() {
        if (this.offset == 0 && this.currentPage != 0) {
            this.offset = (this.currentPage - 1) * this.pageSize;
        }
        if (this.offset < 0) {
            this.offset = 0;
        }
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }
}

