/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.converter;

import java.util.ArrayList;
import java.util.List;
import net.atomarrow.converter.ArrayConverter;
import net.atomarrow.converter.BooleanConverter;
import net.atomarrow.converter.DateConverter;
import net.atomarrow.converter.DoubleConverter;
import net.atomarrow.converter.FloatConverter;
import net.atomarrow.converter.IConverter;
import net.atomarrow.converter.IntegerConverter;
import net.atomarrow.converter.ListConverter;
import net.atomarrow.converter.LongConverter;
import net.atomarrow.converter.StringConverter;
import net.atomarrow.converter.TimeConverter;
import net.atomarrow.converter.TypeMismatchException;
import org.springframework.stereotype.Component;

@Component
public class TypeConverter {
    private List<IConverter> converters = new ArrayList<IConverter>();

    public TypeConverter() {
        this.converters.add(new StringConverter());
        this.converters.add(new IntegerConverter());
        this.converters.add(new DoubleConverter());
        this.converters.add(new DateConverter());
        this.converters.add(new TimeConverter());
        this.converters.add(new FloatConverter());
        this.converters.add(new LongConverter());
        this.converters.add(new BooleanConverter());
        this.converters.add(new ArrayConverter());
        this.converters.add(new ListConverter());
    }

    public <T> T converter(Object[] values, Class<T> clazz) throws TypeMismatchException {
        if (clazz == Object.class) {
            if (values == null || values.length == 0) {
                return null;
            }
            Object value = values[0];
            if (value == null) {
                return null;
            }
            return (T)value;
        }
        for (IConverter converter : this.converters) {
            if (!converter.canHandle(clazz)) continue;
            try {
                return converter.converter(values, clazz);
            }
            catch (Exception e) {
                break;
            }
        }
        throw new TypeMismatchException(clazz.getName() + " can not be convert");
    }
}

