/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.db.batch;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.atomarrow.db.batch.BatchField;
import net.atomarrow.db.orm.Attribute;
import net.atomarrow.util.BeanUtil;
import net.atomarrow.util.HtmlUtil;

public class BatchSetter {
    private List<BatchField> fields = new ArrayList<BatchField>();
    private int index = -1;

    public BatchSetter(Object object, List<Attribute> attributes) {
        this.parse(object, attributes);
    }

    private void parse(Object data, List<Attribute> attributes) {
        for (Attribute at : attributes) {
            if (!at.isDbColumn()) continue;
            Object value = (Serializable)BeanUtil.getSimpleProperty(data, at.getName());
            if (value instanceof String) {
                value = HtmlUtil.processScript((String)value);
            }
            this.fields.add(new BatchField(value, at.getSqlType()));
        }
    }

    public boolean hasNext() {
        if (this.fields.size() == 0) {
            return false;
        }
        ++this.index;
        return this.index < this.fields.size();
    }

    public BatchField next() {
        return this.fields.get(this.index);
    }
}

