/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.db.executor;

import com.mysql.cj.jdbc.exceptions.MySQLTransactionRollbackException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.atomarrow.converter.TypeConverter;
import net.atomarrow.db.parser.batch.BatchField;
import net.atomarrow.db.parser.batch.BatchSetter;
import net.atomarrow.db.parser.batch.BatchSqlHolder;
import net.atomarrow.db.pool.ConnectionMgr;
import net.atomarrow.db.tx.TransactionMgr;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JdbcExecutor {
    @Autowired
    private TypeConverter typeConverter;
    @Autowired
    private ConnectionMgr connectionMgr;
    @Autowired
    private TransactionMgr transactionMgr;

    public boolean batchUpdate(BatchSqlHolder sqlHolder) {
        Connection conn = this.connectionMgr.getConnection();
        if (sqlHolder.isMultiValues()) {
            return this.mulityValuesInsert(sqlHolder, conn);
        }
        return this.normalBatchInsert(sqlHolder, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean normalBatchInsert(BatchSqlHolder sqlHolder, Connection conn) {
        PreparedStatement ps = null;
        try {
            boolean justRight = false;
            ps = conn.prepareStatement(sqlHolder.getSql());
            List<BatchSetter> batchSetters = sqlHolder.getBatchSetters();
            int i = 0;
            for (BatchSetter setter : batchSetters) {
                justRight = false;
                int j = 1;
                while (setter.hasNext()) {
                    BatchField field = setter.next();
                    ps.setObject(j, field.getValue(), field.getType());
                    ++j;
                }
                ps.addBatch();
                if (i % 500 != 0) continue;
                justRight = true;
                ps.executeBatch();
                ps.clearBatch();
            }
            if (!justRight) {
                ps.executeBatch();
                ps.clearBatch();
            }
            boolean bl = true;
            this.close(ps);
            return bl;
        }
        catch (MySQLTransactionRollbackException e) {
            boolean bl = this.normalBatchInsert(sqlHolder, conn);
            this.close(ps);
            return bl;
        }
        catch (SQLException e2) {
            e2.printStackTrace();
            this.rollBack(e2);
            boolean bl = false;
            this.close(ps);
            return bl;
            {
                catch (Throwable throwable) {
                    this.close(ps);
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mulityValuesInsert(BatchSqlHolder sqlHolder, Connection conn) {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            List<String> sqls = sqlHolder.getSqls();
            for (String sql : sqls) {
                stmt.addBatch(sql);
            }
            stmt.executeBatch();
            stmt.clearBatch();
            boolean bl = true;
            return bl;
        }
        catch (MySQLTransactionRollbackException e) {
            boolean bl = this.mulityValuesInsert(sqlHolder, conn);
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.rollBack(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.close(stmt);
        }
    }

    private void rollBack(SQLException e) {
        this.transactionMgr.setNeedRollBack();
        this.transactionMgr.setSqlException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> queryForList(String sql) {
        Connection conn = this.connectionMgr.getConnection();
        Statement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(sql);
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            while (resultSet.next()) {
                list.add(this.getResultMap(resultSet));
            }
            ArrayList<Map<String, Object>> arrayList = list;
            this.close(stmt, resultSet);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.rollBack(e);
                this.close(stmt, resultSet);
            }
            catch (Throwable throwable) {
                this.close(stmt, resultSet);
                throw throwable;
            }
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> queryForMap(String sql) {
        ResultSet resultSet;
        Statement stmt;
        block5: {
            Connection conn = this.connectionMgr.getConnection();
            stmt = null;
            resultSet = null;
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(sql);
            if (!resultSet.next()) break block5;
            Map<String, Object> map = this.getResultMap(resultSet);
            this.close(stmt, resultSet);
            return map;
        }
        try {
            Map map = Collections.EMPTY_MAP;
            this.close(stmt, resultSet);
            return map;
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.close(stmt, resultSet);
            }
            catch (Throwable throwable) {
                this.close(stmt, resultSet);
                throw throwable;
            }
        }
        return Collections.EMPTY_MAP;
    }

    private Map<String, Object> getResultMap(ResultSet resultSet) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ResultSetMetaData rsmd = resultSet.getMetaData();
        int count = rsmd.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            map.put(rsmd.getColumnLabel(i), resultSet.getObject(i));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer queryForInt(String sql) {
        ResultSet resultSet;
        Statement stmt;
        block5: {
            Connection conn = this.connectionMgr.getConnection();
            stmt = null;
            resultSet = null;
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(sql);
            if (!resultSet.next()) break block5;
            Integer n = resultSet.getInt(1);
            this.close(stmt, resultSet);
            return n;
        }
        try {
            Integer n = 0;
            this.close(stmt, resultSet);
            return n;
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.rollBack(e);
                this.close(stmt, resultSet);
            }
            catch (Throwable throwable) {
                this.close(stmt, resultSet);
                throw throwable;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> queryForList(String sql, Class<T> clazz) {
        Connection conn = this.connectionMgr.getConnection();
        Statement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(sql);
            ArrayList<T> list = new ArrayList<T>();
            while (resultSet.next()) {
                list.add(this.typeConverter.converter(new Object[]{resultSet.getObject(1)}, clazz));
            }
            ArrayList<T> arrayList = list;
            this.close(stmt, resultSet);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.rollBack(e);
                this.close(stmt, resultSet);
            }
            catch (Throwable throwable) {
                this.close(stmt, resultSet);
                throw throwable;
            }
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String sql) {
        Connection conn = this.connectionMgr.getConnection();
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            System.out.println(sql);
            int n = stmt.executeUpdate(sql);
            return n;
        }
        catch (MySQLTransactionRollbackException e) {
            int n = this.update(sql);
            return n;
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.rollBack(e);
        }
        finally {
            this.close(stmt);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T queryForObject(String sql, Class<T> clazz) {
        T t;
        ResultSet resultSet;
        Statement stmt;
        block5: {
            Connection conn = this.connectionMgr.getConnection();
            stmt = null;
            resultSet = null;
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(sql);
            if (!resultSet.next()) break block5;
            T t2 = this.typeConverter.converter(new Object[]{resultSet.getObject(1)}, clazz);
            this.close(stmt, resultSet);
            return t2;
        }
        try {
            t = null;
            this.close(stmt, resultSet);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                this.rollBack(e);
                this.close(stmt, resultSet);
                return null;
            }
            catch (Throwable throwable) {
                this.close(stmt, resultSet);
                throw throwable;
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Serializable add(String sql, String primaryKey) {
        Connection conn = this.connectionMgr.getConnection();
        PreparedStatement ps = null;
        ResultSet resultSet = null;
        try {
            ps = conn.prepareStatement(sql, new String[]{primaryKey});
            ps.executeUpdate();
            resultSet = ps.getGeneratedKeys();
            if (resultSet != null && resultSet.next()) {
                Serializable serializable = (Serializable)resultSet.getObject(1);
                this.close(ps, resultSet);
                return serializable;
            }
            this.close(ps, resultSet);
        }
        catch (MySQLTransactionRollbackException e) {
            Serializable serializable = this.add(sql, primaryKey);
            this.close(ps, resultSet);
            return serializable;
        }
        catch (SQLException e2) {
            e2.printStackTrace();
            this.rollBack(e2);
            this.close(ps, resultSet);
            {
                catch (Throwable throwable) {
                    this.close(ps, resultSet);
                    throw throwable;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String sql, Object[] params) {
        Connection conn = this.connectionMgr.getConnection();
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            int i = 0;
            for (Object object : params) {
                ps.setObject(++i, object);
            }
            int n = ps.executeUpdate();
            return n;
        }
        catch (MySQLTransactionRollbackException e) {
            int n = this.update(sql, params);
            return n;
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.rollBack(e);
        }
        finally {
            this.close(ps);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String sql) {
        Connection conn = this.connectionMgr.getConnection();
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            stmt.execute(sql);
        }
        catch (MySQLTransactionRollbackException e) {
            this.execute(sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.rollBack(e);
        }
        finally {
            this.close(stmt);
        }
    }

    private void close(PreparedStatement ps) {
        try {
            if (ps != null && !ps.isClosed()) {
                ps.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void close(Statement stmt, ResultSet resultSet) {
        try {
            if (resultSet != null && !resultSet.isClosed()) {
                resultSet.close();
            }
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void close(Statement stmt) {
        try {
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void close(PreparedStatement ps, ResultSet resultSet) {
        try {
            if (resultSet != null && !resultSet.isClosed()) {
                resultSet.close();
            }
            if (ps != null && !ps.isClosed()) {
                ps.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

