/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.db.listener;

import java.util.ArrayList;
import java.util.List;
import net.atomarrow.db.listener.OrmListener;

public class OrmListenerKeeper {
    private List<OrmListener> listeners = new ArrayList<OrmListener>();

    public List<OrmListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<OrmListener> listeners) {
        this.listeners = listeners;
    }

    public OrmListener getListener(Class clazz) {
        for (OrmListener listener : this.listeners) {
            if (!listener.isListen(clazz)) continue;
            return listener;
        }
        return null;
    }

    public void loadListeners(List<String> paths) {
        try {
            for (String path : paths) {
                Class<?> clazz = Class.forName(path);
                if (!OrmListener.class.isAssignableFrom(clazz)) continue;
                this.listeners.add((OrmListener)clazz.newInstance());
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

