/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.db.orm;

import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.atomarrow.db.annotation.FieldType;
import net.atomarrow.db.annotation.NotCreate;
import net.atomarrow.db.orm.Attribute;
import net.atomarrow.db.orm.DomainBean;
import net.atomarrow.domains.Domain;
import net.atomarrow.domains.DomainUtil;
import net.atomarrow.exceptions.OrmConfigNotLoadException;
import net.atomarrow.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrmContext {
    @Autowired
    private DomainUtil domainUtil;
    private HashMap<String, DomainBean> tableMapContext = new HashMap();
    private List<String> domainNames = new ArrayList<String>();

    private HashMap<String, DomainBean> getContext() {
        return this.tableMapContext;
    }

    public List<String> getAllDomainNames() {
        return this.domainNames;
    }

    public List<String> getMultipleTableDomainNames() {
        ArrayList<String> mulits = new ArrayList<String>();
        for (String domainName : this.domainNames) {
            if (!this.domainUtil.isMultiTable(domainName)) continue;
            mulits.add(domainName);
        }
        return mulits;
    }

    public List<String> getSingleTableDomainNames() {
        ArrayList<String> singles = new ArrayList<String>();
        for (String domainName : this.domainNames) {
            if (!this.domainUtil.isSingleTable(domainName)) continue;
            singles.add(domainName);
        }
        return singles;
    }

    public void addDomainName(String domainName) {
        this.domainNames.add(domainName);
    }

    public Class<?> getDomainClass(String tableName) {
        DomainBean d = this.getDomain(tableName);
        if (d == null) {
            throw new OrmConfigNotLoadException("orm config not load:" + tableName);
        }
        return d.clazz;
    }

    private DomainBean getDomain(String domainName) {
        return this.getContext().get(this.domainUtil.getMappingName(domainName));
    }

    public List<Attribute> getAttributes(String tableName) {
        DomainBean d = this.getDomain(tableName);
        if (d == null) {
            throw new OrmConfigNotLoadException("orm config not load:" + tableName);
        }
        return d.attributes;
    }

    public void addDomain(Class<?> clazz) {
        this.addDomain(clazz.getSimpleName(), clazz);
    }

    public void addBean(Class<?> clazz) {
        this.addDomain(clazz.getSimpleName(), clazz);
    }

    public void addDomain(String domainName, Class<?> clazz) {
        Field[] fields;
        String mappingName = this.domainUtil.getMappingName(domainName);
        if (this.existName(mappingName)) {
            throw new RuntimeException(domainName + "\u2018s mappingName " + mappingName + " conflict error");
        }
        this.addDomainName(clazz.getSimpleName());
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (Field f : fields = clazz.getDeclaredFields()) {
            attributes.add(new Attribute(f.getName(), this.getSqlType(f), !f.isAnnotationPresent(NotCreate.class)));
        }
        this.tableMapContext.put(this.domainUtil.getMappingName(domainName), new DomainBean(clazz, attributes));
    }

    public void removeDomain(String domainName) {
        String mappingName = this.domainUtil.getMappingName(domainName);
        this.tableMapContext.remove(mappingName);
    }

    public void reloadDomain(String domainName, Class<?> clazz) {
        this.removeDomain(domainName);
        this.addDomain(domainName, clazz);
    }

    public boolean existName(String mappingName) {
        return this.tableMapContext.containsKey(mappingName);
    }

    private int getSqlType(Field f) {
        Object type;
        if (f.isAnnotationPresent(FieldType.class)) {
            type = f.getAnnotation(FieldType.class);
            switch (type.type()) {
                case VARCHAR: {
                    return 12;
                }
                case TEXT: {
                    return 12;
                }
                case DATE: {
                    return 91;
                }
                case DATETIME: {
                    return 93;
                }
                case TIME: {
                    return 92;
                }
            }
        }
        if ((type = f.getGenericType()) == String.class) {
            return 12;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return 4;
        }
        if (type == Double.TYPE || type == Double.class) {
            return 8;
        }
        if (type == java.util.Date.class || type == Date.class) {
            return 91;
        }
        if (type == Timestamp.class) {
            return 93;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return -7;
        }
        if (type == Long.TYPE || type == Long.class) {
            return -16;
        }
        return 0;
    }

    public void loadOrm(Map<String, Domain> domains) {
        Set<Map.Entry<String, Domain>> set = domains.entrySet();
        for (Map.Entry<String, Domain> domainEntry : set) {
            this.addDomain(StringUtil.toUpperCaseFirstWord(domainEntry.getKey()), domainEntry.getValue().getClass());
        }
    }

    public void loadOrm(List<String> paths) {
        try {
            for (String path : paths) {
                Class<?> clazz = Class.forName(path);
                if (!Domain.class.isAssignableFrom(clazz)) continue;
                this.addDomain(clazz.getSimpleName(), clazz);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

