/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.db.orm.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.atomarrow.db.orm.listener.OrmListener;
import org.springframework.stereotype.Component;

@Component
public class OrmListenerKeeper {
    private List<OrmListener> listeners = new ArrayList<OrmListener>();

    public List<OrmListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<OrmListener> listeners) {
        this.listeners = listeners;
    }

    public OrmListener getListener(Class clazz) {
        for (OrmListener listener : this.listeners) {
            if (!listener.isListen(clazz)) continue;
            return listener;
        }
        return null;
    }

    public void loadListeners(Map<String, OrmListener> listenerMap) {
        this.listeners.addAll(listenerMap.values());
    }

    public void loadListeners(List<String> paths) {
        try {
            for (String path : paths) {
                Class<?> clazz = Class.forName(path);
                if (!OrmListener.class.isAssignableFrom(clazz)) continue;
                this.listeners.add((OrmListener)clazz.newInstance());
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

