/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.db.parser;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.atomarrow.bean.Pager;
import net.atomarrow.db.parser.Condition;
import net.atomarrow.db.parser.Conditions;
import net.atomarrow.db.parser.Parser;
import net.atomarrow.db.parser.ValueProcessor;
import net.atomarrow.db.parser.batch.BatchSqlHolder;
import net.atomarrow.domains.Domain;
import net.atomarrow.util.StringLink;

public class BaseParser
implements Parser {
    protected String parse(Conditions conditions, StringBuilder sb) {
        return this.parse(conditions, sb, false);
    }

    protected String parse(Conditions conditions, StringBuilder sb, boolean noOrder) {
        if (conditions.haveOrder && conditions.haveGroup) {
            this.processGroupOrder(conditions);
            return this.groupParse(conditions, sb);
        }
        if (conditions.haveOrder) {
            this.processOrder(conditions);
        }
        for (Condition conditon : conditions.cs) {
            Object[] arrays;
            int i;
            if (conditions.link == null) {
                conditions.link = "";
            }
            if (conditon.getLink() != null && !conditon.getLink().equals("")) {
                if (conditon.getLink().equals("(")) {
                    conditions.parenthesesStart = true;
                    continue;
                }
                if (conditon.getLink().equals("((")) {
                    conditions.parenthesesDoubleStart = true;
                    continue;
                }
                if (conditon.getLink().equals(")")) {
                    sb.append(")");
                    continue;
                }
                conditions.link = conditon.getLink();
                continue;
            }
            if (conditon.getCompareState().equals("=") || conditon.getCompareState().equals(">") || conditon.getCompareState().equals("<")) {
                this.processSqlLink(conditions, sb);
                sb.append(conditon.getFieldName());
                sb.append(" ");
                sb.append(conditon.getCompareState());
                sb.append(" ");
                sb.append(conditon.getValue1());
            } else if (conditon.getCompareState().equals("between")) {
                this.processSqlLink(conditions, sb);
                sb.append(conditon.getFieldName());
                sb.append(" ");
                sb.append(conditon.getCompareState());
                sb.append(" ");
                sb.append(conditon.getValue1());
                sb.append(" and ");
                sb.append(conditon.getValue2());
            } else if (conditon.getCompareState().equals("or")) {
                this.processSqlLink(conditions, sb);
                sb.append("(");
                sb.append(conditon.getFieldName());
                sb.append("=");
                sb.append(conditon.getValue1());
                sb.append(" ");
                sb.append(conditon.getCompareState());
                sb.append(" ");
                sb.append(conditon.getFieldName());
                sb.append("=");
                sb.append(conditon.getValue2());
                sb.append(")");
            } else if (conditon.getCompareState().equals("in")) {
                this.processSqlLink(conditions, sb);
                sb.append(conditon.getFieldName());
                sb.append(" in(");
                i = 0;
                if (conditon.getValue1().getClass().isArray()) {
                    for (Object a : arrays = (Object[])conditon.getValue1()) {
                        if (i == arrays.length - 1) {
                            sb.append(this.processValue((Serializable)a));
                        } else {
                            sb.append(this.processValue((Serializable)a));
                            sb.append(",");
                        }
                        ++i;
                    }
                } else {
                    sb.append(this.getColumnHql((Conditions)conditon.getValue2(), (String)((Object)conditon.getValue1())));
                }
                sb.append(")");
            } else if (conditon.getCompareState().equals("not in")) {
                this.processSqlLink(conditions, sb);
                sb.append(conditon.getFieldName());
                sb.append(" not in(");
                i = 0;
                if (conditon.getValue1().getClass().isArray()) {
                    for (Object a : arrays = (Object[])conditon.getValue1()) {
                        if (i == arrays.length - 1) {
                            sb.append(this.processValue((Serializable)a));
                        } else {
                            sb.append(this.processValue((Serializable)a));
                            sb.append(",");
                        }
                        ++i;
                    }
                } else {
                    sb.append(this.getColumnHql((Conditions)conditon.getValue2(), (String)((Object)conditon.getValue1())));
                }
                sb.append(")");
            } else if (conditon.getCompareState().equals("like")) {
                this.processSqlLink(conditions, sb);
                sb.append(conditon.getFieldName());
                sb.append(" like ");
                sb.append(conditon.getValue1());
            } else if (conditon.getCompareState().equals("not like")) {
                this.processSqlLink(conditions, sb);
                sb.append(conditon.getFieldName());
                sb.append(" not like ");
                sb.append(conditon.getValue1());
            } else if (conditon.getCompareState().equals("expresson")) {
                sb.append(conditon.getValue1());
            } else if (conditon.getCompareState().equals("group")) {
                if (conditions.cs.size() == 1) {
                    if (sb.length() > 0) {
                        sb.delete(sb.length() - " where ".length(), sb.length());
                    }
                    return sb.append(" group by ").append(conditon.getFieldName()).toString();
                }
                sb.append(" group by ");
                sb.append(conditon.getFieldName());
            } else {
                if (conditon.getCompareState().equals("asc")) {
                    if (noOrder) continue;
                    if (conditions.cs.size() == 1) {
                        if (sb.length() > 0) {
                            sb.delete(sb.length() - " where ".length(), sb.length());
                        }
                        return sb.append(" order by ").append(conditon.getFieldName()).append(" ").append("asc").toString();
                    }
                    sb.append(" order by ");
                    sb.append(conditon.getFieldName());
                    sb.append(" ");
                    sb.append("asc");
                    return sb.toString();
                }
                if (conditon.getCompareState().equals("desc")) {
                    if (noOrder) continue;
                    if (conditions.cs.size() == 1) {
                        if (sb.length() > 0) {
                            sb.delete(sb.length() - " where ".length(), sb.length());
                        }
                        return sb.append(" order by ").append(conditon.getFieldName()).append(" ").append("desc").toString();
                    }
                    sb.append(" order by ");
                    sb.append(conditon.getFieldName());
                    sb.append(" ");
                    sb.append("desc");
                    return sb.toString();
                }
                this.processSqlLink(conditions, sb);
                sb.append(conditon.getFieldName());
                sb.append(" ");
                sb.append(conditon.getCompareState());
                sb.append(" ");
                sb.append(conditon.getValue1());
            }
            conditions.link = "and";
        }
        String str = sb.toString();
        return str;
    }

    private void processSqlLink(Conditions conditions, StringBuilder sb) {
        sb.append(" ");
        sb.append(conditions.link);
        sb.append(" ");
        if (conditions.parenthesesStart) {
            sb.append("(");
            conditions.parenthesesStart = false;
        } else if (conditions.parenthesesDoubleStart) {
            sb.append("((");
            conditions.parenthesesDoubleStart = false;
        }
    }

    private String groupParse(Conditions conditions, StringBuilder sb) {
        for (Condition conditon : conditions.cs) {
            if (conditions.link == null) {
                conditions.link = "";
            }
            if (conditon.getLink() != null && !conditon.getLink().equals("")) {
                if (conditon.getLink().equals("(")) {
                    conditions.parenthesesStart = true;
                    continue;
                }
                if (conditon.getLink().equals("((")) {
                    conditions.parenthesesDoubleStart = true;
                    continue;
                }
                if (conditon.getLink().equals(")")) {
                    sb.append(")");
                    continue;
                }
                conditions.link = conditon.getLink();
                continue;
            }
            if (conditon.getCompareState().equals("=") || conditon.getCompareState().equals(">") || conditon.getCompareState().equals("<")) {
                this.processSqlLink(conditions, sb);
                sb.append(conditon.getFieldName());
                sb.append(" ");
                sb.append(conditon.getCompareState());
                sb.append(" ");
                sb.append(conditon.getValue1());
            } else if (conditon.getCompareState().equals("between")) {
                this.processSqlLink(conditions, sb);
                sb.append(conditon.getFieldName());
                sb.append(" ");
                sb.append(conditon.getCompareState());
                sb.append(" ");
                sb.append(conditon.getValue1());
                sb.append(" and ");
                sb.append(conditon.getValue2());
            } else if (conditon.getCompareState().equals("or")) {
                this.processSqlLink(conditions, sb);
                sb.append("(");
                sb.append(conditon.getFieldName());
                sb.append("=");
                sb.append(conditon.getValue1());
                sb.append(" ");
                sb.append(conditon.getCompareState());
                sb.append(" ");
                sb.append(conditon.getFieldName());
                sb.append("=");
                sb.append(conditon.getValue2());
                sb.append(")");
            } else if (conditon.getCompareState().equals("like")) {
                this.processSqlLink(conditions, sb);
                sb.append(conditon.getFieldName());
                sb.append(" like ");
                sb.append(conditon.getValue1());
            } else if (conditon.getCompareState().equals("not like")) {
                this.processSqlLink(conditions, sb);
                sb.append(conditon.getFieldName());
                sb.append(" not like ");
                sb.append(conditon.getValue1());
            } else if (conditon.getCompareState().equals("in")) {
                this.processSqlLink(conditions, sb);
                sb.append(conditon.getFieldName());
                sb.append(" in(");
                int i = 0;
                if (conditon.getValue1().getClass().isArray()) {
                    Object[] arrays;
                    for (Object a : arrays = (Object[])conditon.getValue1()) {
                        if (i == arrays.length - 1) {
                            sb.append(this.processValue((Serializable)a));
                        } else {
                            sb.append(this.processValue((Serializable)a));
                            sb.append(",");
                        }
                        ++i;
                    }
                } else {
                    sb.append(this.getColumnHql((Conditions)conditon.getValue2(), (String)((Object)conditon.getValue1())));
                }
                sb.append(")");
            } else if (conditon.getCompareState().equals("group")) {
                if (conditions.cs.size() == 2) {
                    sb = new StringBuilder(sb.substring(0, sb.length() - 6));
                    sb.append(" group by ");
                    sb.append(conditon.getFieldName());
                } else {
                    sb.append(" group by ");
                    sb.append(conditon.getFieldName());
                }
            } else {
                if (conditon.getCompareState().equals("asc")) {
                    if (conditions.cs.size() == 1) {
                        return new StringLink("from ", conditions.getTableName(), conditions.getJoin(), " order by ", conditon.getFieldName(), " ", "asc").toString();
                    }
                    sb.append(" order by ");
                    sb.append(conditon.getFieldName());
                    sb.append(" ");
                    sb.append("asc");
                    return sb.toString();
                }
                if (conditon.getCompareState().equals("desc")) {
                    if (conditions.cs.size() == 1) {
                        return new StringLink("from ", conditions.getTableName(), conditions.getJoin(), " order by ", conditon.getFieldName(), " ", "desc").toString();
                    }
                    sb.append(" order by ");
                    sb.append(conditon.getFieldName());
                    sb.append(" ");
                    sb.append("desc");
                    return sb.toString();
                }
                this.processSqlLink(conditions, sb);
                sb.append(conditon.getFieldName());
                sb.append(" ");
                sb.append(conditon.getCompareState());
                sb.append(" ");
                sb.append(conditon.getValue1());
            }
            conditions.link = "and";
        }
        String str = sb.toString();
        str = str.substring(0, str.length() - 5);
        return str;
    }

    private void processGroupOrder(Conditions conditions) {
        Condition condition = conditions.cs.get(conditions.cs.size() - 1);
        if (condition.getCompareState().equals("desc") || condition.getCompareState().equals("asc")) {
            condition = conditions.cs.get(conditions.cs.size() - 2);
            if (condition.getCompareState().equals("group")) {
                return;
            }
        } else {
            int i;
            Condition o = null;
            Condition g = null;
            for (i = 0; i < conditions.cs.size(); ++i) {
                if (!conditions.cs.get(i).getCompareState().equals("desc") && !conditions.cs.get(i).getCompareState().equals("asc")) continue;
                o = conditions.cs.remove(i);
                break;
            }
            for (i = 0; i < conditions.cs.size(); ++i) {
                if (!conditions.cs.get(i).getCompareState().equals("group")) continue;
                g = conditions.cs.remove(i);
                break;
            }
            conditions.cs.add(g);
            conditions.cs.add(o);
        }
    }

    private void processOrder(Conditions conditions) {
        Condition condition = conditions.cs.get(conditions.cs.size() - 1);
        if (condition.getCompareState().equals("desc") || condition.getCompareState().equals("asc")) {
            return;
        }
        Condition c = null;
        for (int i = 0; i < conditions.cs.size(); ++i) {
            if (!conditions.cs.get(i).getCompareState().equals("desc") && !conditions.cs.get(i).getCompareState().equals("asc")) continue;
            c = conditions.cs.remove(i);
            break;
        }
        conditions.cs.add(c);
    }

    @Override
    public String getSelectHql(Conditions conditions) {
        if (conditions.sql != null) {
            return conditions.sql;
        }
        conditions.link = null;
        if (conditions.cs.size() == 0) {
            return "from " + conditions.getTableName() + conditions.getJoin();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("from ");
        sb.append(conditions.getTableName());
        sb.append(" ");
        sb.append(conditions.getJoin());
        sb.append(" where ");
        return this.parse(conditions, sb);
    }

    @Override
    public String getDelHql(Conditions conditions) {
        if (conditions.sql != null) {
            return conditions.sql;
        }
        conditions.link = null;
        if (conditions.cs.size() == 0) {
            return "delete from " + conditions.getTableName();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("delete from ");
        sb.append(conditions.getTableName());
        sb.append(" ");
        sb.append(conditions.getJoin());
        sb.append(" where ");
        String str = this.parse(conditions, sb);
        return str;
    }

    public String getDistinctCountHql(Conditions conditions, String attribute) {
        String str;
        if (conditions.sql != null) {
            return conditions.sql;
        }
        conditions.link = null;
        if (conditions.cs.size() == 0) {
            return conditions.getSelect().concat("count(distinct " + attribute + ") from ").concat(conditions.getTableName()).concat(conditions.getJoin());
        }
        if (conditions.haveGroup) {
            StringBuilder sb = new StringBuilder();
            sb.append("select count(1) as total from (");
            sb.append(conditions.getSelect());
            sb.append("count(distinct ");
            sb.append(attribute);
            sb.append(" ) from ");
            sb.append(conditions.getTableName());
            sb.append(" ");
            sb.append(conditions.getJoin());
            sb.append(" where ");
            str = this.parse(conditions, sb);
            str = str + ") as temp";
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(conditions.getSelect());
            sb.append("count(distinct ");
            sb.append(attribute);
            sb.append(" ) from ");
            sb.append(conditions.getTableName());
            sb.append(" ");
            sb.append(conditions.getJoin());
            sb.append(" where ");
            str = this.parse(conditions, sb);
        }
        return str;
    }

    @Override
    public String getCountHql(Conditions conditions) {
        String str;
        if (conditions.sql != null) {
            return conditions.sql;
        }
        conditions.link = null;
        if (conditions.cs.size() == 0) {
            return conditions.getSelect().concat("count(*) from ").concat(conditions.getTableName()).concat(conditions.getJoin());
        }
        if (conditions.haveGroup) {
            StringBuilder sb = new StringBuilder();
            sb.append("select count(1) as total from (");
            sb.append(conditions.getSelect());
            sb.append("count(*) from ");
            sb.append(conditions.getTableName());
            sb.append(" ");
            sb.append(conditions.getJoin());
            sb.append(" where ");
            str = this.parse(conditions, sb, true);
            if (str.endsWith(" where ")) {
                str = str + "1=1";
            }
            str = str + ") as temp";
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(conditions.getSelect());
            sb.append("count(*) from ");
            sb.append(conditions.getTableName());
            sb.append(" ");
            sb.append(conditions.getJoin());
            sb.append(" where ");
            str = this.parse(conditions, sb, true);
            if (str.endsWith(" where ")) {
                str = str + "1=1";
            }
        }
        return str;
    }

    @Override
    public String getMaxHql(Conditions conditions, String attribute) {
        if (conditions.sql != null) {
            return conditions.sql;
        }
        conditions.link = null;
        if (conditions.cs.size() == 0) {
            return new StringLink(conditions.getSelect(), "max(", attribute, ") from ", conditions.getTableName(), conditions.getJoin()).toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(conditions.getSelect());
        sb.append("max(");
        sb.append(attribute);
        sb.append(") from ");
        sb.append(conditions.getTableName());
        sb.append(" ");
        sb.append(conditions.getJoin());
        sb.append(" where ");
        String str = this.parse(conditions, sb);
        return str;
    }

    @Override
    public String getMaxDomainHql(Conditions conditions, String attribute) {
        if (conditions.sql != null) {
            return conditions.sql;
        }
        conditions.link = null;
        if (conditions.cs.size() == 0) {
            return new StringLink("from ", conditions.getTableName(), conditions.getJoin(), " order by ", attribute, " ", "desc").toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("from ");
        sb.append(conditions.getTableName());
        sb.append(" ");
        sb.append(conditions.getJoin());
        sb.append(" where ");
        conditions.put((Serializable)((Object)attribute), "desc");
        String str = this.parse(conditions, sb);
        return str;
    }

    @Override
    public String getSumHql(Conditions conditions, String attribute) {
        if (conditions.sql != null) {
            return conditions.sql;
        }
        conditions.link = null;
        if (conditions.cs.size() == 0) {
            return new StringLink(conditions.getSelect(), "sum(", attribute, ") from ", conditions.getTableName(), conditions.getJoin()).toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(conditions.getSelect());
        sb.append("sum(");
        sb.append(attribute);
        sb.append(") from ");
        sb.append(conditions.getTableName());
        sb.append(" ");
        sb.append(conditions.getJoin());
        sb.append(" where ");
        String str = this.parse(conditions, sb);
        return str;
    }

    @Override
    public String getDistinctHql(Conditions conditions, String attribute) {
        if (conditions.sql != null) {
            return conditions.sql;
        }
        conditions.link = null;
        if (conditions.cs.size() == 0) {
            return new StringLink(conditions.getSelect(), "distinct ", attribute, " from ", conditions.getTableName(), conditions.getJoin()).toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(conditions.getSelect());
        sb.append("distinct ");
        sb.append(attribute);
        sb.append(" from ");
        sb.append(conditions.getTableName());
        sb.append(" ");
        sb.append(conditions.getJoin());
        sb.append(" where ");
        String str = this.parse(conditions, sb);
        return str;
    }

    @Override
    public String getColumnHql(Conditions conditions, String attribute) {
        if (conditions.sql != null) {
            return conditions.sql;
        }
        conditions.link = null;
        if (conditions.cs.size() == 0) {
            return new StringLink(conditions.getSelect(), attribute, " from ", conditions.getTableName(), conditions.getJoin()).toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(conditions.getSelect());
        sb.append(attribute);
        sb.append(" from ");
        sb.append(conditions.getTableName());
        sb.append(" ");
        sb.append(conditions.getJoin());
        sb.append(" where ");
        String str = this.parse(conditions, sb);
        return str;
    }

    @Override
    public String getMulColumnHql(Conditions conditions, String[] columns) {
        if (conditions.sql != null) {
            return conditions.sql;
        }
        conditions.link = null;
        if (columns == null || columns.length == 0) {
            return this.getSelectHql(conditions);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            sb.append(columns[i]);
            if (i == columns.length - 1) continue;
            sb.append(",");
        }
        String cols = sb.toString();
        if (conditions.cs.size() == 0) {
            return new StringLink(conditions.getSelect(), "new ", conditions.getTableName(), "(", sb.toString(), ") from ", conditions.getTableName(), conditions.getJoin()).toString();
        }
        sb.setLength(0);
        sb.append(conditions.getSelect());
        sb.append("new ");
        sb.append(conditions.getTableName());
        sb.append("(");
        sb.append(cols);
        sb.append(") from ");
        sb.append(conditions.getTableName());
        sb.append(" ");
        sb.append(conditions.getJoin());
        sb.append(" where ");
        String str = this.parse(conditions, sb);
        return str;
    }

    @Override
    public String getModifyColumnHql(Conditions conditions, Serializable[] keyValues) {
        if (conditions.sql != null) {
            return conditions.sql;
        }
        conditions.link = null;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keyValues.length; ++i) {
            if (i % 2 == 0) {
                sb.append(keyValues[i]);
                sb.append("=");
                continue;
            }
            Serializable ser = this.processValue(keyValues[i]);
            sb.append(ser);
            sb.append(",");
        }
        if (sb.lastIndexOf(",") == sb.length() - 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        String cols = sb.toString();
        if (conditions.cs.size() == 0) {
            return new StringLink("update ", conditions.getTableName(), conditions.getJoin(), " set ", cols, "").toString();
        }
        sb.setLength(0);
        sb.append("update ");
        sb.append(conditions.getTableName());
        sb.append(" ");
        sb.append(conditions.getJoin());
        sb.append(" set ");
        sb.append(cols);
        sb.append(" where ");
        String str = this.parse(conditions, sb);
        return str;
    }

    @Override
    public String getModifyColumnHql(Conditions conditions, Map<String, Serializable> columns) {
        if (conditions.sql != null) {
            return conditions.sql;
        }
        conditions.link = null;
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = columns.keySet().iterator();
        while (iter.hasNext()) {
            String s = iter.next();
            sb.append(s);
            sb.append("=");
            Serializable ser = this.processValue(columns.get(s));
            sb.append(ser);
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        String cols = sb.toString();
        if (conditions.cs.size() == 0) {
            return new StringLink("update ", conditions.getTableName(), conditions.getJoin(), " set ", cols, "").toString();
        }
        sb.setLength(0);
        sb.append("update ");
        sb.append(conditions.getTableName());
        sb.append(" ");
        sb.append(conditions.getJoin());
        sb.append(" set ");
        sb.append(cols);
        sb.append(" where ");
        String str = this.parse(conditions, sb);
        return str;
    }

    protected Serializable processValue(Serializable value) {
        return ValueProcessor.processValue(value);
    }

    @Override
    public String getAddSql(Domain domain) {
        return this.getAddSql(null, domain);
    }

    @Override
    public String getAddSql(String tableName, Domain domain) {
        throw new RuntimeException("\u4e0d\u80fd\u8c03\u7528\u6b64\u65b9\u6cd5\uff0c\u9700\u8981\u8c03\u7528\u76f8\u5e94\u7684\u5b9e\u73b0\u7c7b");
    }

    @Override
    public String getUpdateSql(String tableName, Domain domain) {
        throw new RuntimeException("\u4e0d\u80fd\u8c03\u7528\u6b64\u65b9\u6cd5\uff0c\u9700\u8981\u8c03\u7528\u76f8\u5e94\u7684\u5b9e\u73b0\u7c7b");
    }

    @Override
    public String getSelectPagerSql(Conditions conditions, Pager pager) {
        throw new RuntimeException("\u4e0d\u80fd\u8c03\u7528\u6b64\u65b9\u6cd5\uff0c\u9700\u8981\u8c03\u7528\u76f8\u5e94\u7684\u5b9e\u73b0\u7c7b");
    }

    @Override
    public BatchSqlHolder getBatchAddSql(String tableName, List<? extends Domain> dataList) {
        throw new RuntimeException("\u4e0d\u80fd\u8c03\u7528\u6b64\u65b9\u6cd5\uff0c\u9700\u8981\u8c03\u7528\u76f8\u5e94\u7684\u5b9e\u73b0\u7c7b");
    }

    @Override
    public String getMulColumnPagerSql(Conditions conditions, String[] columns, Pager pager) {
        throw new RuntimeException("\u4e0d\u80fd\u8c03\u7528\u6b64\u65b9\u6cd5\uff0c\u9700\u8981\u8c03\u7528\u76f8\u5e94\u7684\u5b9e\u73b0\u7c7b");
    }

    @Override
    public String getColumnPagerSql(Conditions conditions, String attribute, Pager pager) {
        throw new RuntimeException("\u4e0d\u80fd\u8c03\u7528\u6b64\u65b9\u6cd5\uff0c\u9700\u8981\u8c03\u7528\u76f8\u5e94\u7684\u5b9e\u73b0\u7c7b");
    }

    @Override
    public BatchSqlHolder getBatchUpdateSql(String tableName, List<? extends Domain> dataList) {
        throw new RuntimeException("\u4e0d\u80fd\u8c03\u7528\u6b64\u65b9\u6cd5\uff0c\u9700\u8981\u8c03\u7528\u76f8\u5e94\u7684\u5b9e\u73b0\u7c7b");
    }

    @Override
    public BatchSqlHolder getBatchUpdateSql(String tableName, String[] cols, List<? extends Domain> datas) {
        throw new RuntimeException("\u4e0d\u80fd\u8c03\u7528\u6b64\u65b9\u6cd5\uff0c\u9700\u8981\u8c03\u7528\u76f8\u5e94\u7684\u5b9e\u73b0\u7c7b");
    }

    @Override
    public String getGroupConcatSql(Conditions conditions, String attribute, String separator) {
        throw new RuntimeException("\u4e0d\u80fd\u8c03\u7528\u6b64\u65b9\u6cd5\uff0c\u9700\u8981\u8c03\u7528\u76f8\u5e94\u7684\u5b9e\u73b0\u7c7b");
    }
}

