/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.db.parser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.atomarrow.configs.DbConfig;
import net.atomarrow.db.orm.IDomainControl;
import net.atomarrow.db.parser.Condition;
import net.atomarrow.db.parser.Expression;
import net.atomarrow.db.parser.ValueProcessor;
import net.atomarrow.util.StringUtil;

public class Conditions
implements Serializable {
    List<Condition> cs = new ArrayList<Condition>();
    boolean haveOrder;
    boolean haveGroup;
    String sql;
    Expression expression;
    boolean parenthesesStart;
    boolean parenthesesDoubleStart;
    boolean sqlCache;
    private Class clazz;
    private Class returnClazz;
    private String tableName;
    private String returnClassName;
    private String selectValue;
    private String finalSelectValue;
    private String join;
    String link = null;
    public static final String UE = "!=";
    public static final String GT = ">";
    public static final String EW = "=";
    public static final String ST = "<";
    public static final String OR = "or";
    public static final String EXP = "expresson";
    public static final String BW = "between";
    public static final String DESC = "desc";
    public static final String ASC = "asc";
    public static final String IN = "in";
    public static final String NOTIN = "not in";
    public static final String IS = "is";
    public static final String ISNOT = "is not";
    public static final String LIKE = "like";
    public static final String NOTLIKE = "not like";
    public static final String LIKELEFT = "likeleft";
    public static final String LIKERIGHT = "likeright";
    public static final String GROUP = "group";
    public static final String AND = "and";

    public <T> Conditions(Class<T> clazz) {
        this.clazz = clazz;
        this.returnClazz = clazz;
    }

    public <T> Conditions(Class<? extends T> clazz, Class<T> returnClazz) {
        this.clazz = clazz;
        this.returnClazz = returnClazz;
    }

    public <T> Conditions(String tableName) {
        this.tableName = tableName;
        this.returnClassName = tableName;
    }

    public <T> Conditions(String tableName, String returnClassName) {
        this.tableName = tableName;
        this.returnClassName = returnClassName;
    }

    public void setSelectValue(String selectValue) {
        this.selectValue = selectValue;
    }

    public Conditions parenthesesStart() {
        Condition condition = new Condition();
        condition.setLink("(");
        this.cs.add(condition);
        return this;
    }

    public Conditions parenthesesDoubleStart() {
        Condition condition = new Condition();
        condition.setLink("((");
        this.cs.add(condition);
        return this;
    }

    public Conditions parenthesesEnd() {
        Condition condition = new Condition();
        condition.setLink(")");
        this.cs.add(condition);
        return this;
    }

    public Conditions putEW(Serializable fieldName, Serializable value) {
        return this.put(fieldName, value, EW);
    }

    public Conditions putEWIfOk(Serializable fieldName, Serializable value) {
        return this.isOk(value) ? this.putEW(fieldName, value) : this;
    }

    public Conditions putUE(Serializable fieldName, Serializable value) {
        return this.put(fieldName, value, UE);
    }

    public Conditions putGT(Serializable fieldName, Serializable value) {
        return this.put(fieldName, value, GT);
    }

    public Conditions putGTIfOk(Serializable fieldName, Serializable value) {
        return this.isOk(value) ? this.putGT(fieldName, value) : this;
    }

    public Conditions putST(Serializable fieldName, Serializable value) {
        return this.put(fieldName, value, ST);
    }

    public Conditions putSTIfOk(Serializable fieldName, Serializable value) {
        return this.isOk(value) ? this.putST(fieldName, value) : this;
    }

    public Conditions putGE(Serializable fieldName, Serializable value) {
        return this.put(fieldName, value, ">=");
    }

    public Conditions putGEIfOk(Serializable fieldName, Serializable value) {
        return this.isOk(value) ? this.putGE(fieldName, value) : this;
    }

    public Conditions putSE(Serializable fieldName, Serializable value) {
        return this.put(fieldName, value, "<=");
    }

    public Conditions putSEIfOk(Serializable fieldName, Serializable value) {
        return this.isOk(value) ? this.putSE(fieldName, value) : this;
    }

    public Conditions putOR(Serializable fieldName, Serializable value, Serializable value2) {
        return this.put(fieldName, value, value2, OR);
    }

    public Conditions putBW(Serializable fieldName, Serializable value, Serializable value2) {
        return this.put(fieldName, value, value2, BW);
    }

    public Conditions putASC(Serializable fieldName) {
        return this.put(fieldName, ASC);
    }

    public Conditions putDESC(Serializable fieldName) {
        return this.put(fieldName, DESC);
    }

    public Conditions putIS(Serializable fieldName, Serializable value) {
        return this.put(fieldName, value, IS);
    }

    public Conditions putISNOT(Serializable fieldName, Serializable value) {
        return this.put(fieldName, value, ISNOT);
    }

    public Conditions putIN(Serializable fieldName, Object[] value) {
        return this.put(fieldName, (Serializable)value, IN);
    }

    public Conditions putIN(Serializable fieldName, Serializable fieldName2, Conditions conditions) {
        return this.put(fieldName, fieldName2, conditions, IN);
    }

    public Conditions putNOTIN(Serializable fieldName, Object[] value) {
        return this.put(fieldName, (Serializable)value, NOTIN);
    }

    public Conditions putNOTIN(Serializable fieldName, Serializable fieldName2, Conditions conditions) {
        return this.put(fieldName, fieldName2, conditions, NOTIN);
    }

    public Conditions putLIKE(Serializable fieldName, Serializable value) {
        return this.put(fieldName, value, LIKE);
    }

    public Conditions putLIKEIfOK(Serializable fieldName, Serializable value) {
        return this.isOk(value) ? this.put(fieldName, value, LIKE) : this;
    }

    public Conditions putNOTLIKE(Serializable fieldName, Serializable value) {
        return this.put(fieldName, value, NOTLIKE);
    }

    public Conditions putLIKELEFT(Serializable fieldName, Serializable value) {
        return this.put(fieldName, value, LIKELEFT);
    }

    public Conditions putLIKELEFTIfOk(Serializable fieldName, Serializable value) {
        return this.isOk(value) ? this.put(fieldName, value, LIKELEFT) : this;
    }

    public Conditions putLIKERIGHT(Serializable fieldName, Serializable value) {
        return this.put(fieldName, value, LIKERIGHT);
    }

    public Conditions putLIKERIGHTIfOk(Serializable fieldName, Serializable value) {
        return this.isOk(value) ? this.put(fieldName, value, LIKERIGHT) : this;
    }

    public Conditions putGROUP(Serializable fieldName) {
        return this.put(fieldName, GROUP);
    }

    public Conditions putEXP(Expression expression) {
        return this.put(null, expression, EXP);
    }

    public Conditions putEXP(String sql, Serializable ... params) {
        Expression expression = new Expression(sql, params);
        return this.putEXP(expression);
    }

    public Conditions put(Serializable fieldName, Serializable value, String compareState) {
        if (value == null && !compareState.equals(IS) && !compareState.equals(ISNOT)) {
            throw new RuntimeException(fieldName + " value can not be null");
        }
        if (!compareState.equals(IN) && !compareState.equals(NOTIN)) {
            if (compareState.equals(LIKE)) {
                value = "'%" + StringUtil.replace(value.toString(), "'", "''") + "%'";
            } else if (compareState.equals(LIKELEFT)) {
                value = "'" + StringUtil.replace(value.toString(), "'", "''") + "%'";
                compareState = LIKE;
            } else if (compareState.equals(LIKERIGHT)) {
                value = "'%" + StringUtil.replace(value.toString(), "'", "''") + "'";
                compareState = LIKE;
            } else if (compareState.equals(NOTLIKE)) {
                value = "'%" + StringUtil.replace(value.toString(), "'", "''") + "%'";
                compareState = NOTLIKE;
            } else if (compareState.equals(IS) || compareState.equals(ISNOT)) {
                if (value != null) {
                    value = this.processValue((Serializable)value);
                }
            } else {
                value = this.processValue((Serializable)value);
            }
        }
        this.cs.add(new Condition(fieldName, (Serializable)value, compareState));
        return this;
    }

    public Conditions put(Serializable fieldName, String compareState) {
        if (compareState.equals(DESC) || compareState.equals(ASC)) {
            this.haveOrder = true;
        } else if (compareState.equals(GROUP)) {
            this.haveGroup = true;
        } else {
            new Exception("Conditions\u4e2d" + fieldName + "\u5b57\u6bb5\u641c\u7d22\u6761\u4ef6\u9519\u8bef\uff0c\u6b64\u5904\u53ea\u80fd\u4f7f\u7528ASC\u3001DESC\u3001GROUP").printStackTrace();
        }
        this.cs.add(new Condition(fieldName, null, compareState));
        return this;
    }

    public Conditions put(Serializable fieldName, Serializable value1, Serializable value2, String compareState) {
        if (value1 == null || value2 == null) {
            throw new RuntimeException(fieldName + " value can not be null");
        }
        if (compareState.equals(OR) || compareState.equals(BW)) {
            value1 = this.processValue(value1);
            value2 = this.processValue(value2);
            this.cs.add(new Condition(fieldName, value1, value2, compareState));
        } else if (compareState.equals(IN) || compareState.equals(NOTIN)) {
            this.cs.add(new Condition(fieldName, value1, value2, compareState));
        }
        return this;
    }

    private Serializable processValue(Serializable value) {
        return ValueProcessor.processValue(value);
    }

    public Conditions setClazz(Class clazz) {
        this.clazz = clazz;
        this.returnClazz = clazz;
        return this;
    }

    public Class getConditonClass() {
        return this.clazz;
    }

    public Class getReturnClass() {
        return this.returnClazz;
    }

    public Conditions newConditions(Class clazz) {
        return this.newConditions(clazz, clazz);
    }

    public Conditions newConditions(Class clazz, Class returnClass) {
        this.clear();
        this.clazz = clazz;
        this.returnClazz = returnClass;
        this.tableName = clazz.getSimpleName();
        this.returnClassName = this.returnClazz.getSimpleName();
        return this;
    }

    public Conditions newConditions(String tableName) {
        return this.newConditions(tableName, tableName);
    }

    public Conditions newConditions(String tableName, String returnTableName) {
        this.clear();
        this.tableName = tableName;
        this.returnClassName = returnTableName;
        return this;
    }

    private void clear() {
        this.cs.clear();
        this.haveGroup = false;
        this.haveOrder = false;
        this.link = null;
        this.parenthesesStart = false;
        this.parenthesesDoubleStart = false;
        this.sql = null;
    }

    public Conditions setLink(String link) {
        Condition condition = new Condition();
        condition.setLink(link);
        this.cs.add(condition);
        return this;
    }

    public Conditions or() {
        return this.setLink(OR);
    }

    public Map<Serializable, Condition> getConditions() {
        HashMap<Serializable, Condition> maps = new HashMap<Serializable, Condition>();
        for (Condition con : this.cs) {
            maps.put(con.getFieldName(), con);
        }
        return maps;
    }

    public boolean isOk(Serializable value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return (Integer)value > 0;
        }
        if (clazz.equals(String.class)) {
            return StringUtil.isNotBlank(value.toString());
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return (Double)value > 0.0;
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return (Long)value > 0L;
        }
        if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
            return (Short)value > 0;
        }
        if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
            return (Byte)value > 0;
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return ((Float)value).floatValue() > 0.0f;
        }
        return true;
    }

    public String getReturnClassName() {
        if (StringUtil.isBlank(this.returnClassName)) {
            this.returnClassName = this.returnClazz.getSimpleName();
        }
        return this.returnClassName;
    }

    public void setReturnClassName(String returnClassName) {
        this.returnClassName = returnClassName;
    }

    public void setReturnClass(Class returnClazz) {
        this.returnClazz = returnClazz;
        this.returnClassName = returnClazz.getSimpleName();
    }

    public String getTableName() {
        if (StringUtil.isBlank(this.tableName)) {
            IDomainControl domainControl = DbConfig.getDomainControl();
            this.tableName = domainControl != null ? domainControl.getDomainName(this.clazz) : this.clazz.getSimpleName();
        }
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
        this.returnClassName = tableName;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
        this.sql = this.processValue(expression).toString();
    }

    public void setExpression(String sql, Serializable ... params) {
        Expression expression = new Expression(sql, params);
        this.setExpression(expression);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String getSelectValue() {
        if (this.selectValue == null) {
            return this.getSelect().concat("* ");
        }
        return this.getSelect().concat(this.selectValue).concat(" ");
    }

    public String getSelect() {
        if (this.sqlCache) {
            return "select sql_cache ";
        }
        return "select ";
    }

    public boolean getSqlCache() {
        return this.sqlCache;
    }

    public void setSqlCache(boolean sqlCache) {
        this.sqlCache = sqlCache;
    }

    public String getFinalSelectValue() {
        return this.finalSelectValue;
    }

    public void setFinalSelectValue(String finalSelectValue) {
        this.finalSelectValue = finalSelectValue;
    }

    public String getJoin() {
        return this.join == null ? "" : this.join;
    }

    public void setJoin(String join) {
        this.join = join;
    }
}

