/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.db.parser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.atomarrow.bean.Pager;
import net.atomarrow.configs.DbConfig;
import net.atomarrow.db.orm.Attribute;
import net.atomarrow.db.orm.OrmContext;
import net.atomarrow.db.parser.BaseParser;
import net.atomarrow.db.parser.Conditions;
import net.atomarrow.db.parser.Parser;
import net.atomarrow.db.parser.batch.BatchSetter;
import net.atomarrow.db.parser.batch.BatchSqlHolder;
import net.atomarrow.domains.Domain;
import net.atomarrow.util.BeanUtil;
import net.atomarrow.util.HtmlUtil;
import net.atomarrow.util.StringLink;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JdbcParser
extends BaseParser
implements Parser {
    @Autowired
    private OrmContext ormContext;
    private static Parser INSTANCE;

    public static Parser getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JdbcParser();
        }
        return INSTANCE;
    }

    @Override
    public String getAddSql(String tableName, Domain domain) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.ormContext.getAttributes(tableName));
        if (attributes == null) {
            throw new RuntimeException("orm config not find");
        }
        ArrayList<Serializable> values = new ArrayList<Serializable>();
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute at = (Attribute)attributes.get(i);
            if (!at.isDbColumn()) {
                attributes.remove(i);
                --i;
                continue;
            }
            if (!at.isDbColumn()) continue;
            Serializable value = (Serializable)BeanUtil.getSimpleProperty(domain, at.getName());
            if (value == null && !domain.isNeedUpdate(at.getName())) {
                attributes.remove(i);
                --i;
                continue;
            }
            values.add(value);
        }
        return this.generateAddSql(tableName, attributes, values);
    }

    private String generateAddSql(String tableName, List<Attribute> attributes, List<Serializable> values) {
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ");
        sb.append(tableName);
        sb.append("(");
        for (Attribute at : attributes) {
            if (!at.isDbColumn()) continue;
            sb.append(at.getName());
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(") values(");
        for (int i = 0; i < values.size(); ++i) {
            Object value = this.processValue(values.get(i));
            if (value instanceof String) {
                value = HtmlUtil.processScript((String)value);
            }
            sb.append(value);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String getSelectHql(Conditions conditions) {
        if (conditions.sql != null) {
            return conditions.sql;
        }
        if (conditions.getFinalSelectValue() != null) {
            conditions.link = null;
            if (conditions.cs.size() == 0) {
                return conditions.getFinalSelectValue();
            }
            return conditions.getFinalSelectValue() + this.parse(conditions, new StringBuilder(" where "));
        }
        return conditions.getSelectValue() + super.getSelectHql(conditions);
    }

    @Override
    public String getUpdateSql(String tableName, Domain domain) {
        domain.checkChange();
        StringBuilder sb = new StringBuilder();
        sb.append("update ");
        sb.append(tableName);
        sb.append(" set ");
        List<Attribute> attributes = this.ormContext.getAttributes(tableName);
        for (Attribute at : attributes) {
            if (!at.isDbColumn() || at.getName().equals("id") || !domain.isNeedUpdate(at.getName())) continue;
            Object value = this.processValue((Serializable)BeanUtil.getSimpleProperty(domain, at.getName()));
            if (value instanceof String) {
                value = HtmlUtil.processScript((String)value);
            }
            sb.append(at.getName());
            sb.append("=");
            sb.append(value);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" where id=");
        sb.append(this.processValue((Serializable)BeanUtil.getValue("id", domain)));
        return sb.toString();
    }

    @Override
    public BatchSqlHolder getBatchAddSql(String tableName, List<? extends Domain> datas) {
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ");
        sb.append(tableName);
        sb.append("(");
        List<Attribute> attributes = this.ormContext.getAttributes(tableName);
        for (Attribute at : attributes) {
            if (!at.isDbColumn()) continue;
            sb.append(at.getName());
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(") values");
        if (DbConfig.getDatabaseType() == "oracle") {
            sb.append("(");
            for (Attribute at : attributes) {
                if (!at.isDbColumn()) continue;
                sb.append("?,");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
            String sql = sb.toString();
            ArrayList<BatchSetter> batchSetters = new ArrayList<BatchSetter>();
            for (int i = 0; i < datas.size(); ++i) {
                batchSetters.add(new BatchSetter(datas.get(i), attributes));
            }
            return new BatchSqlHolder(sql, batchSetters, false);
        }
        if (DbConfig.getDatabaseType() == "mysql") {
            String sql_prefix = sb.toString();
            boolean justRight = false;
            ArrayList<String> sqls = new ArrayList<String>();
            for (int i = 0; i < datas.size(); ++i) {
                sb.append("(");
                justRight = false;
                Domain data = datas.get(i);
                for (Attribute at : attributes) {
                    if (!at.isDbColumn()) continue;
                    Object value = this.processValue((Serializable)BeanUtil.getSimpleProperty(data, at.getName()));
                    if (value instanceof String) {
                        value = HtmlUtil.processScript((String)value);
                    }
                    sb.append(value);
                    sb.append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append("),");
                if ((i + 1) % 500 != 0) continue;
                justRight = true;
                sb.deleteCharAt(sb.length() - 1);
                sqls.add(sb.toString());
                sb.setLength(0);
                sb.append(sql_prefix);
            }
            if (!justRight) {
                sb.deleteCharAt(sb.length() - 1);
                sqls.add(sb.toString());
            }
            return new BatchSqlHolder(sqls, true);
        }
        return null;
    }

    @Override
    public String getSelectPagerSql(Conditions conditions, Pager pager) {
        if (conditions.sql != null) {
            return conditions.sql + " limit " + pager.getOffset() + "," + pager.getPageSize();
        }
        return this.getSelectHql(conditions) + " limit " + pager.getOffset() + "," + pager.getPageSize();
    }

    @Override
    public String getMulColumnPagerSql(Conditions conditions, String[] columns, Pager pager) {
        if (conditions.sql != null) {
            return conditions.sql + " limit " + pager.getOffset() + "," + pager.getPageSize();
        }
        return this.getMulColumnHql(conditions, columns) + " limit " + pager.getOffset() + "," + pager.getPageSize();
    }

    @Override
    public String getColumnPagerSql(Conditions conditions, String attribute, Pager pager) {
        if (conditions.sql != null) {
            return conditions.sql + " limit " + pager.getOffset() + "," + pager.getPageSize();
        }
        return this.getColumnHql(conditions, attribute) + " limit " + pager.getOffset() + "," + pager.getPageSize();
    }

    @Override
    public String getMaxDomainHql(Conditions conditions, String attribute) {
        if (conditions.sql != null) {
            return conditions.sql;
        }
        return conditions.getSelect().concat("* ").concat(super.getMaxDomainHql(conditions, attribute));
    }

    @Override
    public String getMulColumnHql(Conditions conditions, String[] columns) {
        if (columns == null || columns.length == 0) {
            throw new RuntimeException("columns\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (conditions.sql != null) {
            return conditions.sql;
        }
        conditions.link = null;
        StringBuilder sb = new StringBuilder();
        sb.append(conditions.getSelect());
        for (String column : columns) {
            sb.append(column);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" from ");
        sb.append(conditions.getTableName());
        if (conditions.cs.size() == 0) {
            return sb.toString();
        }
        sb.append(" ");
        sb.append(conditions.getJoin());
        sb.append(" where ");
        return this.parse(conditions, sb);
    }

    @Override
    public BatchSqlHolder getBatchUpdateSql(String tableName, List<? extends Domain> datas) {
        return this.getBatchUpdateSql(tableName, null, datas);
    }

    private void processDuplicate(Domain domain, StringBuilder sb, List<Attribute> attributes, List<String> sqls, Set<String> set) {
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" on duplicate key update ");
        for (Attribute at : attributes) {
            if (!at.isDbColumn() || at.getName().equals("id") || set != null && !set.contains(at.getName())) continue;
            sb.append(at.getName());
            sb.append("=values(");
            sb.append(at.getName());
            sb.append("),");
        }
        sb.deleteCharAt(sb.length() - 1);
        sqls.add(sb.toString());
    }

    @Override
    public BatchSqlHolder getBatchUpdateSql(String tableName, String[] cols, List<? extends Domain> datas) {
        HashSet<String> set = null;
        if (cols != null) {
            set = new HashSet<String>();
            for (String col : cols) {
                set.add(col);
            }
        }
        Domain domain = datas.get(0);
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ");
        sb.append(tableName);
        sb.append("(");
        List<Attribute> attributes = this.ormContext.getAttributes(tableName);
        for (Attribute at : attributes) {
            if (!at.isDbColumn() || set != null && !set.contains(at.getName()) && !at.getName().equals("id")) continue;
            sb.append(at.getName());
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(") values");
        String sql_prefix = sb.toString();
        boolean justRight = false;
        ArrayList<String> sqls = new ArrayList<String>();
        for (int i = 0; i < datas.size(); ++i) {
            sb.append("(");
            justRight = false;
            Domain data = datas.get(i);
            for (Attribute at : attributes) {
                if (!at.isDbColumn() || set != null && !set.contains(at.getName()) && !at.getName().equals("id")) continue;
                Object value = this.processValue((Serializable)BeanUtil.getSimpleProperty(data, at.getName()));
                if (value instanceof String) {
                    value = HtmlUtil.processScript((String)value);
                }
                sb.append(value);
                sb.append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("),");
            if ((i + 1) % 500 != 0) continue;
            justRight = true;
            this.processDuplicate(domain, sb, attributes, sqls, set);
            sb.setLength(0);
            sb.append(sql_prefix);
        }
        if (!justRight) {
            this.processDuplicate(domain, sb, attributes, sqls, set);
        }
        return new BatchSqlHolder(sqls, true);
    }

    @Override
    public String getGroupConcatSql(Conditions conditions, String attribute, String separator) {
        if (conditions.sql != null) {
            return conditions.sql;
        }
        conditions.link = null;
        if (conditions.cs.size() == 0) {
            return new StringLink(conditions.getSelect(), "group_concat(", attribute, " separator '" + separator + "') from ", conditions.getTableName()).toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(conditions.getSelect());
        sb.append("group_concat(");
        sb.append(attribute);
        sb.append(" separator '");
        sb.append(separator);
        sb.append("') from ");
        sb.append(conditions.getTableName());
        sb.append(" ");
        sb.append(conditions.getJoin());
        sb.append(" where ");
        String str = this.parse(conditions, sb);
        return str;
    }

    public String getDistinctHqlPagerSql(Conditions conditions, String attribute, Pager pager) {
        if (conditions.sql != null) {
            return conditions.sql + " limit " + pager.getOffset() + "," + pager.getPageSize();
        }
        return this.getDistinctHql(conditions, attribute) + " limit " + pager.getOffset() + "," + pager.getPageSize();
    }
}

