/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.db.parser;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.atomarrow.configs.DbConfig;
import net.atomarrow.db.parser.Expression;
import net.atomarrow.util.StringUtil;

public class ValueProcessor {
    public static Serializable processValue(Serializable value) {
        if (value instanceof Expression) {
            value = ValueProcessor.processExpression((Expression)value);
        } else if (value instanceof String) {
            value = "'" + ValueProcessor.safeProcess((Serializable)value) + "'";
        } else if (value instanceof Date || value instanceof java.sql.Date || value instanceof Timestamp) {
            Date d = (Date)value;
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (DbConfig.getDatabaseType().equals("mysql")) {
                value = "'" + sf.format(d) + "'";
            } else if (DbConfig.getDatabaseType().equals("oracle")) {
                value = "to_date('" + sf.format(d) + "','yyyy-MM-dd hh24:mi:ss')";
            }
        }
        return value;
    }

    private static Serializable processExpression(Expression expression) {
        if (expression.getParams() == null) {
            return "(" + expression.getSql() + ")";
        }
        StringBuilder sql = new StringBuilder(expression.getSql());
        sql.insert(0, "(");
        for (Serializable param : expression.getParams()) {
            int index = sql.indexOf("?");
            if (index == -1) {
                throw new RuntimeException(expression.getSql() + "\u53c2\u6570\u6570\u91cf\u9519\u8bef");
            }
            sql.replace(index, index + 1, ValueProcessor.processValue(param).toString());
        }
        if (sql.indexOf("?") != -1) {
            throw new RuntimeException(expression.getSql() + "\u53c2\u6570\u6570\u91cf\u9519\u8bef");
        }
        sql.append(")");
        return sql.toString();
    }

    protected static Serializable safeProcess(Serializable value) {
        return StringUtil.replace(value.toString(), "'", "''").replace("\\", "\\\\");
    }
}

