/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.db.pool;

import java.sql.Connection;
import javax.servlet.http.HttpServletRequest;
import net.atomarrow.db.pool.ConnectionProvider;
import net.atomarrow.db.tx.TransactionMgr;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConnectionMgr {
    public static final String CONNECTION = "REQUEST_CONNECTION";
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private ConnectionProvider connectionProvider;
    @Autowired
    private TransactionMgr transactionMgr;

    public Connection getConnection() {
        boolean needTx = this.transactionMgr.needTransaction();
        Connection connection = (Connection)this.request.getAttribute(CONNECTION);
        if (connection == null) {
            connection = this.connectionProvider.getConection(needTx);
            this.request.setAttribute(CONNECTION, (Object)connection);
        }
        return connection;
    }

    public void closeConnection() {
        Connection connection = (Connection)this.request.getAttribute(CONNECTION);
        if (connection != null) {
            this.connectionProvider.closeConnection(connection);
            this.request.setAttribute(CONNECTION, null);
        }
    }
}

