/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.db.pool;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.atomarrow.configs.DbConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConnectionProvider {
    @Autowired
    private DbConfig dbConfig;

    public Connection getConection(boolean needTx) {
        try {
            DataSource ds = this.dbConfig.getDataSource();
            Connection conn = ds.getConnection();
            if (needTx) {
                conn.setAutoCommit(false);
            } else {
                conn.setReadOnly(true);
            }
            return conn;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void closeConnection(Connection conn) {
        try {
            if (conn != null && !conn.isClosed()) {
                conn.setReadOnly(false);
                if (!conn.getAutoCommit()) {
                    conn.setAutoCommit(true);
                }
                conn.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void commitTx(Connection connection) {
        try {
            if (connection != null) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void rollbackTx(Connection connection) {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void changeAutoCommitState(Connection connection, boolean needTx) {
        if (connection != null) {
            try {
                if (needTx) {
                    connection.setReadOnly(false);
                } else {
                    connection.setReadOnly(true);
                }
                connection.setAutoCommit(!needTx);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

