/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.db.tx;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import net.atomarrow.db.annotation.Transaction;
import net.atomarrow.db.pool.ConnectionMgr;
import net.atomarrow.db.tx.TransactionConfig;
import net.atomarrow.db.tx.TransactionMgr;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TransactionAspect {
    @Autowired
    private TransactionConfig transactionConfig;
    @Autowired
    private TransactionMgr transactionMgr;
    @Autowired
    private ConnectionMgr connectionMgr;
    @Autowired
    private HttpServletRequest request;
    public static final String METHOD_COUNT = "METHOD_COUNT";

    @Pointcut(value="target(net.atomarrow.services.IService)")
    public void tran() {
    }

    @Before(value="tran()")
    public void doBefore(JoinPoint joinPoint) throws Throwable {
        MethodSignature ms = (MethodSignature)joinPoint.getSignature();
        boolean needTx = this.whetherNeedTx(ms.getMethod());
        if (needTx) {
            this.transactionMgr.startTransaction();
        }
        Integer count = this.getMethodCount(this.request);
        count = count + 1;
        this.request.setAttribute(METHOD_COUNT, (Object)count);
    }

    private Integer getMethodCount(HttpServletRequest request) {
        Integer count = (Integer)request.getAttribute(METHOD_COUNT);
        if (count == null) {
            count = 0;
        }
        return count;
    }

    @AfterReturning(returning="ret", pointcut="tran()")
    public void doAfterReturning(Object ret) throws Throwable {
        Integer count = this.getMethodCount(this.request);
        if (count == 1 && this.transactionMgr.needTransaction()) {
            if (this.transactionMgr.needRollBack()) {
                this.transactionMgr.rollbackTx();
            } else {
                this.transactionMgr.commitTx();
            }
        }
        if (count == 1) {
            this.connectionMgr.closeConnection();
        }
        count = count - 1;
        this.request.setAttribute(METHOD_COUNT, (Object)count);
    }

    private boolean whetherNeedTx(Method method) {
        if (method.isAnnotationPresent(Transaction.class)) {
            return true;
        }
        String methodName = method.getName();
        for (String prefix : this.transactionConfig.getNeedTxPrefixs()) {
            if (!methodName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

