/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.domains;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.atomarrow.db.annotation.Comment;
import net.atomarrow.db.annotation.Default;
import net.atomarrow.db.annotation.FieldType;
import net.atomarrow.db.annotation.Index;
import net.atomarrow.db.annotation.NotCreate;
import net.atomarrow.db.annotation.NotNull;
import net.atomarrow.db.annotation.PrimaryKey;
import net.atomarrow.domains.Column;
import net.atomarrow.domains.Domain;
import net.atomarrow.services.IService;

public class DbMaker {
    public static final int MODE_CREATE = 1;
    public static final int MODE_UPDATE = 2;
    public static final int MODE_RECREATE = 3;
    private final int DO_CREATE = 1;
    private final int DO_UPDATE = 2;
    private final int DO_NOTHING = 3;
    private Logger log = null;
    private Serializable tableSchema;

    public DbMaker(String databaseName) {
        this.tableSchema = databaseName;
        this.log = Logger.getLogger("\u6570\u636e\u5e93\u8868\u7ba1\u7406:");
    }

    public void makeTable(String tableName, Class domain, IService baseService) {
        if (Domain.class.isAssignableFrom(domain)) {
            this.makeTable(tableName, domain, baseService, 2);
        }
    }

    public void makeTable(String tableName, Class domain, IService baseService, int Mode) {
        List<Column> columns = this.getNeedCrateColumn(domain);
        int doWhat = this.dropTableIfNeed(tableName, columns, baseService, Mode);
        switch (doWhat) {
            case 1: {
                String sql = this.generateCreateSql(tableName, columns);
                baseService.execute(sql);
                this.processIndex(tableName, columns, baseService);
                this.log.info(sql);
                this.log.info(tableName + " created");
                break;
            }
            case 2: {
                String sql = this.generateUpdateSql(tableName, columns, baseService);
                this.processIndex(tableName, columns, baseService);
                if (sql == null) {
                    this.log.info(tableName + " not need updated");
                    break;
                }
                this.log.info(sql);
                this.log.info(tableName + " updated");
                baseService.execute(sql);
                break;
            }
            case 3: {
                this.log.info(tableName + " not need create");
            }
        }
    }

    private boolean processIndex(String tableName, List<Column> columns, IService baseService) {
        boolean flag = false;
        for (Column column : columns) {
            if (column.index == null) continue;
            flag = true;
            boolean execute = this.updateIndex(tableName, column, baseService);
            if (!execute) continue;
            this.log.info(tableName + " column " + column.columnName + " add  " + column.index);
        }
        return flag;
    }

    private boolean updateIndex(String tableName, Column column, IService baseService) {
        boolean exist;
        String sql = "show index from  " + this.tableSchema + "." + tableName + " where column_name like '" + column.columnName + "'";
        boolean bl = exist = baseService.executeUpdate(sql, null) != 0;
        if (exist) {
            return false;
        }
        sql = "ALTER TABLE " + this.tableSchema + "." + tableName + " ADD " + column.index + "  ( `" + column.columnName + "` ) ";
        baseService.executeUpdate(sql, null);
        return true;
    }

    private String generateUpdateSql(String tableName, List<Column> columns, IService baseService) {
        columns = this.getNeedAddColumns(tableName, columns, baseService);
        for (Column c : columns) {
            this.log.info(tableName + " add new column " + c.columnName);
        }
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE `");
        sql.append(tableName);
        sql.append("` Add ");
        if (columns.size() == 0) {
            return null;
        }
        sql.append("(");
        for (Column column : columns) {
            this.processName(sql, column);
            this.processType(sql, column);
            this.processUtf8mb4(sql, column);
            this.processNotNull(sql, column);
            this.processDefault(sql, column);
            this.processComment(sql, column);
            sql.append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        return sql.toString();
    }

    private List<Column> getNeedAddColumns(String tableName, List<Column> columns, IService baseService) {
        ArrayList<Column> needAddcolumns = new ArrayList<Column>();
        Column column = null;
        for (int i = 0; i < columns.size(); ++i) {
            column = columns.get(i);
            if (this.checkColumnExist(tableName, column.columnName, baseService)) continue;
            needAddcolumns.add(column);
        }
        return needAddcolumns;
    }

    private boolean checkColumnExist(String tableName, String columnName, IService baseService) {
        return baseService.executeUpdate("SHOW COLUMNS FROM " + this.tableSchema + "." + tableName + " where Field='" + columnName + "'", null) != 0;
    }

    private int dropTableIfNeed(String tableName, List<Column> columns, IService baseService, int mode) {
        boolean tableExist = this.checkTableExist(tableName, baseService);
        if (!tableExist) {
            return 1;
        }
        if (tableExist && mode == 1) {
            return 3;
        }
        if (mode == 3) {
            this.dropTable(tableName, baseService);
            return 1;
        }
        if (mode == 2) {
            return 2;
        }
        return 0;
    }

    private void dropTable(String tableName, IService baseService) {
        String dropSql = "drop table " + tableName;
        baseService.execute(dropSql);
        this.log.info(dropSql);
    }

    private boolean checkTableExist(String tableName, IService baseService) {
        return baseService.executeUpdate("SHOW TABLE STATUS LIKE '" + tableName + "'", null) != 0;
    }

    private List<Column> getNeedCrateColumn(Class domain) {
        Field[] fields = domain.getDeclaredFields();
        ArrayList<Column> columns = new ArrayList<Column>(fields.length);
        for (Field f : fields) {
            if (!this.needCreate(f)) continue;
            boolean isPrimaryKey = f.getName().equals("id");
            String type = this.getSqlType(f, isPrimaryKey);
            boolean notNull = this.hasNotNull(f);
            String defaultValue = this.getDefaultValue(f);
            String comment = this.getComment(f);
            String index = this.getIndex(f);
            boolean utf8mb4 = this.getUtf8mb4(f);
            columns.add(new Column(f.getName(), type, notNull, defaultValue, comment, isPrimaryKey, f.getGenericType(), index, utf8mb4));
        }
        return columns;
    }

    private boolean getUtf8mb4(Field f) {
        if (f.isAnnotationPresent(FieldType.class)) {
            FieldType type = f.getAnnotation(FieldType.class);
            switch (type.type()) {
                case VARCHAR: {
                    return type.utf8mb4();
                }
                case TEXT: {
                    return type.utf8mb4();
                }
            }
            return false;
        }
        return false;
    }

    private String getIndex(Field f) {
        if (f.isAnnotationPresent(Index.class)) {
            Index comment = f.getAnnotation(Index.class);
            return comment.value();
        }
        return null;
    }

    private String getDefaultValue(Field f) {
        if (f.isAnnotationPresent(Default.class)) {
            Default defaultValue = f.getAnnotation(Default.class);
            return defaultValue.value();
        }
        return null;
    }

    private String getComment(Field f) {
        if (f.isAnnotationPresent(Comment.class)) {
            Comment comment = f.getAnnotation(Comment.class);
            return comment.value();
        }
        return null;
    }

    private boolean hasNotNull(Field f) {
        return f.isAnnotationPresent(NotNull.class);
    }

    private String generateCreateSql(String tableName, List<Column> columns) {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE `");
        sql.append(tableName);
        sql.append("` (");
        for (Column column : columns) {
            this.processName(sql, column);
            this.processType(sql, column);
            this.processUtf8mb4(sql, column);
            this.processNotNull(sql, column);
            this.processDefault(sql, column);
            this.processComment(sql, column);
            sql.append(",");
        }
        sql.append("PRIMARY KEY  (`id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8");
        return sql.toString();
    }

    private void processUtf8mb4(StringBuilder sql, Column column) {
        if (column.utf8mb4) {
            sql.append(" CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ");
        }
    }

    private void processType(StringBuilder sql, Column column) {
        sql.append(" ");
        sql.append(column.sqlType);
    }

    private void processName(StringBuilder sql, Column column) {
        sql.append("`");
        sql.append(column.columnName);
        sql.append("`");
    }

    private void processComment(StringBuilder sql, Column column) {
        if (column.isPrimaryKey) {
            return;
        }
        if (column.comment != null) {
            sql.append(" COMMENT '");
            sql.append(column.comment);
            sql.append(" '");
        }
    }

    private void processDefault(StringBuilder sql, Column column) {
        if (column.isPrimaryKey) {
            return;
        }
        if (column.defaultValue != null) {
            sql.append(" DEFAULT '");
            sql.append(column.defaultValue);
            sql.append("'");
        } else {
            String defalutValue = this.getDefault(column);
            if (defalutValue == null) {
                return;
            }
            sql.append(" DEFAULT ");
            sql.append(defalutValue);
        }
    }

    private String getDefault(Column column) {
        Type type = column.genericType;
        if (type == String.class) {
            if (column.NotNull) {
                return "''";
            }
            return "NULL";
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return "0";
        }
        if (type == Double.TYPE || type == Double.class) {
            return "0";
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return "0";
        }
        return null;
    }

    private void processNotNull(StringBuilder sql, Column column) {
        if (column.isPrimaryKey) {
            return;
        }
        if (column.NotNull) {
            sql.append(" NOT NULL");
        }
    }

    private boolean needCreate(Field f) {
        return !f.isAnnotationPresent(NotCreate.class);
    }

    private String getSqlType(Field f, boolean isPrimary) {
        Object type;
        if (isPrimary) {
            if (f.isAnnotationPresent(PrimaryKey.class)) {
                PrimaryKey type2 = f.getAnnotation(PrimaryKey.class);
                switch (type2.value()) {
                    case INCREMENT: 
                    case IDENTITY: 
                    case SEQUENCE: 
                    case NATIVE: {
                        return "int(11) NOT NULL auto_increment";
                    }
                    case ASSIGNED: {
                        Class<?> t = f.getType();
                        if (t == Integer.TYPE || t == Integer.class) {
                            return "int(11) NOT NULL";
                        }
                        return "varchar(40) DEFAULT NULL";
                    }
                    case FOREIGN: {
                        throw new RuntimeException("\u6846\u67b6\u672a\u5904\u7406\u5916\u952e");
                    }
                }
            } else {
                return "int(11) NOT NULL auto_increment";
            }
            return "";
        }
        if (f.isAnnotationPresent(FieldType.class)) {
            type = f.getAnnotation(FieldType.class);
            switch (type.type()) {
                case VARCHAR: {
                    return "varchar(" + type.length() + ")";
                }
                case TEXT: {
                    return "TEXT";
                }
                case DATE: {
                    return "DATE";
                }
                case DATETIME: {
                    return "DATETIME";
                }
                case TIME: {
                    return "TIME";
                }
                case DECIMAL: {
                    return "decimal(" + type.length() + "," + type.precision() + ")";
                }
                case INT: {
                    return "int(" + type.length() + ")";
                }
            }
        }
        if ((type = f.getGenericType()) == String.class) {
            return "varchar(40)";
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return "int(11)";
        }
        if (type == Double.TYPE || type == Double.class) {
            return "decimal(12,2)";
        }
        if (type == java.util.Date.class || type == Date.class) {
            return "DATE";
        }
        if (type == Time.class) {
            return "TIME";
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return "bit(1)";
        }
        throw new RuntimeException("\u6846\u67b6\u672a\u5904\u7406\u7684\u7c7b\u578b" + f.getGenericType());
    }
}

