/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.domains;

import java.util.List;
import net.atomarrow.configs.DbConfig;
import net.atomarrow.db.orm.OrmContext;
import net.atomarrow.domains.DbMaker;
import net.atomarrow.domains.Domain;
import net.atomarrow.services.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DomainUtil {
    @Autowired
    @Qualifier(value="service")
    private Service service;
    @Autowired
    private DbConfig config;
    @Autowired
    private OrmContext ormContext;

    public String getSingleTableName(Domain domain) {
        return domain.getClass().getSimpleName();
    }

    public String getMultiTableName(Domain domain, int id) {
        return this.getMultiTableName(domain.getClass().getSimpleName(), id);
    }

    public String getMultiTableName(String domainName, int id) {
        return this.getMappingName(domainName) + "_" + id;
    }

    public boolean isSingleTable(String domainName) {
        return !domainName.contains("_");
    }

    public boolean isMultiTable(String domainName) {
        return domainName.contains("_");
    }

    public String getMappingName(String domainName) {
        int sIndex = domainName.indexOf("_");
        if (sIndex != -1) {
            return domainName.substring(0, sIndex);
        }
        return domainName;
    }

    public void generateAllSingleTable() {
        DomainUtil domainUtil = this;
        DbMaker dm = new DbMaker(domainUtil.config.getDatabaseName());
        List<String> domainNames = this.ormContext.getSingleTableDomainNames();
        for (String domainName : domainNames) {
            dm.makeTable(domainName, this.ormContext.getDomainClass(domainName), this.service);
        }
    }

    public void generateAllMultiTable(int id) {
        DomainUtil domainUtil = this;
        DbMaker dm = new DbMaker(domainUtil.config.getDatabaseName());
        List<String> domainNames = this.ormContext.getMultipleTableDomainNames();
        for (String domainName : domainNames) {
            dm.makeTable(this.getMultiTableName(domainName, id), this.ormContext.getDomainClass(domainName), this.service);
        }
    }
}

