/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.filter;

import net.atomarrow.configs.Config;
import net.atomarrow.configs.DbConfig;
import net.atomarrow.configs.LogConfig;
import net.atomarrow.db.orm.OrmContext;
import net.atomarrow.db.orm.listener.OrmListener;
import net.atomarrow.db.orm.listener.OrmListenerKeeper;
import net.atomarrow.db.tx.TransactionConfig;
import net.atomarrow.domains.Domain;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class ConfigScanner {
    @Autowired
    private DbConfig dbConfig;
    @Autowired
    private TransactionConfig transactionConfig;
    @Autowired
    private LogConfig logConfig;
    @Autowired
    private OrmListenerKeeper ormListenerKeeper;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private OrmContext ormContext;

    public void scan() {
        Config config;
        try {
            config = (Config)this.applicationContext.getBean(Config.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new RuntimeException("can not find user config file which need extends from net.atomarrow.configs.Config Class");
        }
        this.ormListenerKeeper.loadListeners(this.applicationContext.getBeansOfType(OrmListener.class));
        this.dbConfig.loadConfig(config);
        this.transactionConfig.loadConfig(config);
        this.logConfig.loadConfig(config);
        this.ormContext.loadOrm(this.applicationContext.getBeansOfType(Domain.class));
        config.configOrmBean(this.ormContext);
    }
}

