/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.render;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import net.atomarrow.render.Render;
import net.atomarrow.util.CaptchaCodeUtil;
import net.atomarrow.util.SpringContextUtil;

public class CaptchaRender
extends Render {
    public static final String SESSION_CAPTCHACODE = "SESSION_CAPTCHACODE";
    public static final String WIDTH = "WIDTH";
    public static final String HEIGHT = "HEIGHT";
    public static final String COUNT = "COUNT";

    @Override
    public void render() {
        HttpServletResponse response = SpringContextUtil.getResponse();
        response.reset();
        Integer width = (Integer)this.getAttr(WIDTH);
        Integer height = (Integer)this.getAttr(HEIGHT);
        Integer count = (Integer)this.getAttr(COUNT);
        if (width == null) {
            width = 130;
        }
        if (height == null) {
            height = 40;
        }
        if (count == null) {
            count = 4;
        }
        CaptchaCodeUtil captchaCodeUtil = new CaptchaCodeUtil(width, height, count);
        response.setContentType("image/jpeg");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        SpringContextUtil.getSession().setAttribute(SESSION_CAPTCHACODE, (Object)captchaCodeUtil.getCode());
        try {
            captchaCodeUtil.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

