/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.render;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.atomarrow.render.Render;
import net.atomarrow.util.SpringContextUtil;

public class FileRender
extends Render {
    public static final String FILE_NAME = "FILE_NAME";
    public static final String FILE_DATA_INPUTSTREAM = "FILE_DATA_INPUTSTREAM";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render() {
        HttpServletResponse response = SpringContextUtil.getResponse();
        String fileName = (String)this.getAttr(FILE_NAME);
        response.reset();
        response.setContentType("APPLICATION/OCTET-STREAM");
        ServletOutputStream out = null;
        InputStream inStream = null;
        try {
            int len;
            fileName = URLEncoder.encode(new String(fileName.getBytes(), "UTF-8"));
            response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            out = response.getOutputStream();
            inStream = (InputStream)this.getAttr(FILE_DATA_INPUTSTREAM);
            byte[] b = new byte[4096];
            while ((len = inStream.read(b)) > 0) {
                out.write(b, 0, len);
            }
            response.setStatus(200);
            response.flushBuffer();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

