/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.render;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.atomarrow.render.Render;
import net.atomarrow.util.SpringContextUtil;

public class ImgRender
extends Render {
    public static final String IMG_URL = "IMG_URL";
    public static final String IMG_INPUTSTREAM = "IMG_INPUTSTREAM";
    public static final String IMG_WIDTH = "IMG_WIDTH";
    public static final String IMG_HEIGHT = "IMG_HEIGHT";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render() {
        HttpServletResponse response = SpringContextUtil.getResponse();
        response.reset();
        response.setContentType("image/jpg");
        ServletOutputStream out = null;
        InputStream inStream = null;
        Integer width = (Integer)this.getAttr(IMG_WIDTH);
        Integer height = (Integer)this.getAttr(IMG_HEIGHT);
        inStream = (InputStream)this.getAttr(IMG_INPUTSTREAM);
        if (inStream == null) {
            String urlStr = (String)this.getAttr(IMG_URL);
            if (urlStr == null) {
                return;
            }
            if (urlStr.contains("http://")) {
                try {
                    URL url = new URL(urlStr);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("GET");
                    conn.setConnectTimeout(5000);
                    inStream = conn.getInputStream();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (ProtocolException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (width != null) {
            // empty if block
        }
        if (height != null) {
            // empty if block
        }
        try {
            int len;
            out = response.getOutputStream();
            byte[] b = new byte[4096];
            while ((len = inStream.read(b)) > 0) {
                out.write(b, 0, len);
            }
            response.setStatus(200);
            response.flushBuffer();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

