/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.render;

import java.io.InputStream;
import java.util.HashMap;
import net.atomarrow.render.ErrorRender;
import net.atomarrow.render.FileRender;
import net.atomarrow.render.HtmlRender;
import net.atomarrow.render.ImgRender;
import net.atomarrow.render.JsonRender;
import net.atomarrow.render.RedirectRender;
import net.atomarrow.render.TextRender;
import net.atomarrow.render.XmlRender;

public abstract class Render {
    private HashMap<String, Object> datas = new HashMap();

    public abstract void render();

    public Render setAttr(String name, Object object) {
        this.datas.put(name, object);
        return this;
    }

    public <T> T getAttr(String name) {
        return (T)this.datas.get(name);
    }

    public static Render renderJson(String data) {
        return new JsonRender().setAttr("JSON_STRING", data);
    }

    public static Render renderHtml(String htmlText) {
        return new HtmlRender().setAttr("HTML_STRING", htmlText);
    }

    public static Render renderXml(String xmlText) {
        return new XmlRender().setAttr("XML_STRING", xmlText);
    }

    public static Render renderFile(String fileName, InputStream is) {
        return new FileRender().setAttr("FILE_NAME", fileName).setAttr("FILE_DATA_INPUTSTREAM", is);
    }

    public static Render renderImg(InputStream is) {
        return new ImgRender().setAttr("IMG_INPUTSTREAM", is);
    }

    public static Render renderImg(InputStream is, Integer width, Integer height) {
        return new ImgRender().setAttr("IMG_INPUTSTREAM", is).setAttr("IMG_WIDTH", width).setAttr("IMG_HEIGHT", height);
    }

    public static Render renderActionRedirect(String url) {
        return new RedirectRender().setAttr("URL", url);
    }

    public static Render renderText(String text) {
        return new TextRender().setAttr("TEXT_STRING", text);
    }

    public static Render renderError(String text) {
        return new ErrorRender().setAttr("ERROR_STRING", text);
    }
}

