/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.render;

import java.io.InputStream;
import net.atomarrow.render.ErrorRender;
import net.atomarrow.render.FileRender;
import net.atomarrow.render.HtmlRender;
import net.atomarrow.render.ImgRender;
import net.atomarrow.render.JsonRender;
import net.atomarrow.render.RedirectRender;
import net.atomarrow.render.Render;
import net.atomarrow.render.TextRender;
import net.atomarrow.render.XmlRender;
import org.springframework.stereotype.Component;

@Component
public class RenderFactory {
    public Render createJsonRender(String data) {
        return new JsonRender().setAttr("JSON_STRING", data);
    }

    public Render createHtmlRender(String htmlText) {
        return new HtmlRender().setAttr("HTML_STRING", htmlText);
    }

    public Render createXmlRender(String xmlText) {
        return new XmlRender().setAttr("XML_STRING", xmlText);
    }

    public Render createFileRender(String fileName, InputStream is) {
        return new FileRender().setAttr("FILE_NAME", fileName).setAttr("FILE_DATA_INPUTSTREAM", is);
    }

    public Render createImgRender(InputStream is) {
        return new ImgRender().setAttr("IMG_INPUTSTREAM", is);
    }

    public Render createImgRender(InputStream is, Integer width, Integer height) {
        return new ImgRender().setAttr("IMG_INPUTSTREAM", is).setAttr("IMG_WIDTH", width).setAttr("IMG_HEIGHT", height);
    }

    public Render createRedirectRender(String url) {
        return new RedirectRender().setAttr("URL", url);
    }

    public Render createTextRender(String text) {
        return new TextRender().setAttr("TEXT_STRING", text);
    }

    public Render createErrorRender(String text) {
        return new ErrorRender().setAttr("ERROR_STRING", text);
    }
}

