/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.services;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.atomarrow.bean.Pager;
import net.atomarrow.configs.DbConfig;
import net.atomarrow.db.annotation.UseSetMethod;
import net.atomarrow.db.executor.JdbcExecutor;
import net.atomarrow.db.orm.Attribute;
import net.atomarrow.db.orm.IDomainControl;
import net.atomarrow.db.orm.OrmContext;
import net.atomarrow.db.orm.listener.OrmListener;
import net.atomarrow.db.orm.listener.OrmListenerKeeper;
import net.atomarrow.db.parser.Conditions;
import net.atomarrow.db.parser.JdbcParser;
import net.atomarrow.db.parser.batch.BatchSqlHolder;
import net.atomarrow.domains.Domain;
import net.atomarrow.services.IService;
import net.atomarrow.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JdbcService
implements IService {
    @Autowired
    private JdbcParser parser;
    @Autowired
    private JdbcExecutor operator;
    @Autowired
    private OrmListenerKeeper ormListenerHolder;
    @Autowired
    private DbConfig dbConfig;
    @Autowired
    private OrmContext ormContext;

    @Override
    public boolean checkExist(Class clazz, String colName, Serializable value, Serializable exceptId) {
        return this.getCount(new Conditions(this.getTableName(clazz)).putEW((Serializable)((Object)colName), value).putUE((Serializable)((Object)"id"), exceptId)) > 0;
    }

    @Override
    public boolean checkExist(String tableName, String colName, Serializable value, Serializable exceptId) {
        return this.getCount(new Conditions(tableName).putEW((Serializable)((Object)colName), value).putUE((Serializable)((Object)"id"), exceptId)) > 0;
    }

    @Override
    public boolean addByBatch(List<? extends Domain> dataList) {
        if (dataList == null || dataList.size() == 0) {
            return false;
        }
        return this.addByBatch(this.getTableName(dataList.get(0)), dataList);
    }

    @Override
    public <T extends Domain> boolean addByBatch(Class<T> clazz, List<T> dataList) {
        return this.addByBatch(this.getTableName(clazz), dataList);
    }

    @Override
    public boolean addByBatch(String tableName, List<? extends Domain> dataList) {
        if (dataList == null || dataList.size() == 0) {
            return false;
        }
        BatchSqlHolder sqlHolder = this.parser.getBatchAddSql(tableName, dataList);
        return this.operator.batchUpdate(sqlHolder);
    }

    @Override
    public int del(Domain domain) {
        return this.delById(this.getTableName(domain), (Serializable)this.getValue("id", domain));
    }

    private Object getValue(String name, Object object) {
        try {
            Field f = object.getClass().getDeclaredField(name);
            f.setAccessible(true);
            return f.get(object);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public int delByBatch(Conditions conditions) {
        return this.operator.update(this.parser.getDelHql(conditions));
    }

    @Override
    public <T> int delById(Class<T> clazz, Serializable id) {
        return this.delById(this.getTableName(clazz), id);
    }

    @Override
    public <T> int delById(String className, Serializable id) {
        return this.operator.update(this.parser.getDelHql(new Conditions(className).putEW((Serializable)((Object)"id"), id)));
    }

    @Override
    public int executeUpdate(String sql, Object[] params) {
        if (params == null) {
            return this.operator.update(sql);
        }
        return this.operator.update(sql, params);
    }

    @Override
    public <T> T getById(Class<T> clazz, Serializable id) {
        return this.getById(this.getTableName(clazz), clazz, id);
    }

    @Override
    public <T> List<T> getColumnList(Conditions conditions, String attribute) {
        return this.operator.queryForList(this.parser.getColumnHql(conditions, attribute), Object.class);
    }

    @Override
    public <T> List<T> getColumnDistinctList(Conditions conditions, String attribute) {
        return this.getColumnList(conditions, "distinct " + attribute);
    }

    @Override
    public <T> List<T> getColumnListByPage(Conditions conditions, String attribute, Pager pager) {
        return this.operator.queryForList(this.parser.getColumnPagerSql(conditions, attribute, pager), Object.class);
    }

    @Override
    public <T> List<T> getColumnDistinctListByPage(Conditions conditions, String attribute, Pager pager) {
        return this.getColumnListByPage(conditions, "distinct " + attribute, pager);
    }

    @Override
    public int getCount(Conditions conditions) {
        Integer count = this.operator.queryForInt(this.parser.getCountHql(conditions));
        return count == null ? 0 : count;
    }

    @Override
    public int getDistinctCount(Conditions conditions, String attribute) {
        Integer count = this.operator.queryForInt(this.parser.getDistinctCountHql(conditions, attribute));
        return count == null ? 0 : count;
    }

    @Override
    public <T> List<T> getDistinctList(Conditions conditions, String attribute) {
        return this.operator.queryForList(this.parser.getDistinctHql(conditions, attribute), Object.class);
    }

    @Override
    public <T> List<T> getDistinctListPage(Conditions conditions, String attribute, Pager pager) {
        List<Map<String, Object>> results = this.operator.queryForList(this.parser.getDistinctHqlPagerSql(conditions, attribute, pager));
        return this.generateObjectList(this.getReturnClass(conditions), results);
    }

    @Override
    public <T> List<T> getList(Conditions conditions) {
        List<Map<String, Object>> results = this.operator.queryForList(this.parser.getSelectHql(conditions));
        return this.generateObjectList(this.getReturnClass(conditions), results);
    }

    private List generateObjectList(Class returnClass, List<Map<String, Object>> results) {
        if (results.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        List<Attribute> attributes = this.ormContext.getAttributes(returnClass.getSimpleName());
        ArrayList objects = new ArrayList(results.size());
        int size = results.size();
        for (int i = 0; i < size; ++i) {
            objects.add(this.generateObject(returnClass, attributes, results.get(i)));
        }
        return objects;
    }

    private <T> T generateObject(Class<T> returnClass, List<Attribute> attributes, Map<String, Object> result) {
        if (result == null || result.size() == 0) {
            return null;
        }
        Object obj = null;
        boolean isDomain = Domain.class.isAssignableFrom(returnClass);
        Method addUpdateFiledMethod = null;
        Method setUpdateNotNeedCheck = null;
        try {
            if (isDomain) {
                addUpdateFiledMethod = returnClass.getMethod("addUpdateField", String.class);
                setUpdateNotNeedCheck = returnClass.getMethod("setUpdateNotNeedCheck", Boolean.class);
            }
            obj = returnClass.newInstance();
            OrmListener listener = this.ormListenerHolder.getListener(returnClass);
            for (Attribute at : attributes) {
                String fieldName = at.getName();
                if (listener != null) {
                    fieldName = listener.changeFieldName(returnClass, at.getName());
                }
                Object value = result.get(fieldName);
                if (listener != null) {
                    value = listener.changeValue(returnClass, at.getName(), obj, value);
                }
                if (value != null) {
                    Field f = obj.getClass().getDeclaredField(fieldName);
                    f.setAccessible(true);
                    if (this.needSetMethod(f)) {
                        Method method = obj.getClass().getMethod("set" + StringUtil.toUpperCaseFirstWord(fieldName), f.getType());
                        if (method == null) {
                            new Exception("set" + StringUtil.toUpperCaseFirstWord(fieldName) + " method not found");
                        }
                        method.invoke(obj, this.changeTypeIfNecessary(f, value));
                    } else {
                        f.set(obj, this.changeTypeIfNecessary(f, value));
                    }
                }
                if (!isDomain) continue;
                addUpdateFiledMethod.invoke(obj, fieldName);
                setUpdateNotNeedCheck.invoke(obj, true);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return (T)obj;
    }

    private boolean needSetMethod(Field f) {
        return f.isAnnotationPresent(UseSetMethod.class);
    }

    private Object changeTypeIfNecessary(Field f, Object value) {
        if ((f.getType() == Double.TYPE || f.getType() == Double.class) && value.getClass() == BigDecimal.class) {
            BigDecimal bd = (BigDecimal)value;
            return bd.doubleValue();
        }
        if ((f.getType() == Integer.TYPE || f.getType() == Integer.class) && value.getClass() == BigDecimal.class) {
            BigDecimal bd = (BigDecimal)value;
            return bd.intValue();
        }
        if ((f.getType() == Integer.TYPE || f.getType() == Integer.class) && value.getClass() == Long.class) {
            Long l = (Long)value;
            return l.intValue();
        }
        if ((f.getType() == Integer.TYPE || f.getType() == Integer.class) && value.getClass() == Double.class) {
            Double d = (Double)value;
            return d.intValue();
        }
        if ((f.getType() == Long.TYPE || f.getType() == Long.class) && value.getClass() == BigDecimal.class) {
            BigDecimal bd = (BigDecimal)value;
            return bd.longValue();
        }
        if ((f.getType() == Boolean.TYPE || f.getType() == Boolean.class) && value.getClass() == Long.class) {
            return value != null && (Long)value > 0L;
        }
        if ((f.getType() == Boolean.TYPE || f.getType() == Boolean.class) && value.getClass() == Integer.class) {
            return value != null && (Integer)value > 0;
        }
        return value;
    }

    @Override
    public <T> List<T> getListByPage(Conditions conditions, Pager pager) {
        if (pager == null) {
            return this.getList(conditions);
        }
        if (pager.getDataTotal() == 0) {
            pager.setDataTotal(this.getCount(conditions));
        }
        List<Map<String, Object>> results = this.operator.queryForList(this.parser.getSelectPagerSql(conditions, pager));
        return this.generateObjectList(this.getReturnClass(conditions), results);
    }

    private Class getReturnClass(Conditions conditions) {
        Class<?> returnClass = conditions.getReturnClass();
        if (returnClass == null) {
            returnClass = this.ormContext.getDomainClass(conditions.getReturnClassName());
        }
        return returnClass;
    }

    @Override
    public <T> List<T> getListWithColumn(Conditions conditions, String[] columns) {
        List<Map<String, Object>> results = this.operator.queryForList(this.parser.getMulColumnHql(conditions, columns));
        return this.generateObjectList(this.getReturnClass(conditions), results);
    }

    @Override
    public <T> List<T> getListWithColumnByPage(Conditions conditions, String[] columns, Pager pager) {
        if (pager == null) {
            return this.getListWithColumn(conditions, columns);
        }
        if (pager.getDataTotal() == 0) {
            pager.setDataTotal(this.getCount(conditions));
        }
        List<Map<String, Object>> results = this.operator.queryForList(this.parser.getMulColumnPagerSql(conditions, columns, pager));
        return this.generateObjectList(this.getReturnClass(conditions), results);
    }

    @Override
    public Double getMax(Conditions conditions, String attribute) {
        conditions.setSelectValue("max(" + attribute + ")");
        Double max = this.getDouble(conditions);
        return max == null ? 0.0 : max;
    }

    @Override
    public <T> T getMaxDomain(Conditions conditions, String attribute) {
        conditions.putDESC((Serializable)((Object)attribute));
        return this.getOne(conditions);
    }

    private Map<String, Object> queryForMap(String sql) {
        return this.operator.queryForMap(sql);
    }

    @Override
    public <T> T getOne(Conditions conditions) {
        return this.generateObject(this.getReturnClass(conditions), this.ormContext.getAttributes(conditions.getReturnClassName()), this.queryForMap(this.parser.getSelectPagerSql(conditions, new Pager(0, 1))));
    }

    @Override
    public double getSum(Conditions conditions, String attribute) {
        Double sum = this.operator.queryForObject(this.parser.getSumHql(conditions, attribute), Double.class);
        if (sum == null) {
            return 0.0;
        }
        return sum;
    }

    @Override
    public int modify(Domain domain) {
        return this.modify(this.getTableName(domain), domain);
    }

    @Override
    public boolean modifyByBatch(List<? extends Domain> dataList) {
        if (dataList == null || dataList.size() == 0) {
            return false;
        }
        return this.modifyByBatch(this.getTableName(dataList.get(0)), dataList);
    }

    @Override
    public boolean modifyByBatch(String tableName, List<? extends Domain> dataList) {
        if (dataList == null || dataList.size() == 0) {
            return false;
        }
        Domain domain = dataList.get(0);
        if (domain.getUpdateNotNeedCheck() && DbConfig.getDatabaseType() == "mysql") {
            BatchSqlHolder sqlHolder = this.parser.getBatchUpdateSql(tableName, dataList);
            return this.operator.batchUpdate(sqlHolder);
        }
        for (Domain domain2 : dataList) {
            this.modify(tableName, domain2);
        }
        return true;
    }

    @Override
    public int modifyWithColumn(Conditions conditions, Map<String, Serializable> columns) {
        return this.operator.update(this.parser.getModifyColumnHql(conditions, columns));
    }

    @Override
    public int modifyWithColumn(Conditions conditions, Serializable[] keyValues) {
        return this.operator.update(this.parser.getModifyColumnHql(conditions, keyValues));
    }

    @Override
    public boolean saveOrUpdate(List<? extends Domain> datas) {
        if (datas == null || datas.size() == 0) {
            return false;
        }
        return this.saveOrUpdate(this.getTableName(datas.get(0)), datas);
    }

    private boolean checkIdExist(Object object) {
        Object id = this.getValue("id", object);
        return id != null && !id.equals("") && !id.equals(0);
    }

    @Override
    public void saveOrUpdate(Domain domain) {
        if (domain == null) {
            throw new RuntimeException("saveOrUpdate data is Null");
        }
        this.saveOrUpdate(this.getTableName(domain), domain);
    }

    @Override
    public Serializable add(Domain domain) {
        return this.add(this.getTableName(domain), domain);
    }

    @Override
    public Serializable add(String tableName, Domain data) {
        String primaryKey = "id";
        Serializable id = this.operator.add(this.parser.getAddSql(tableName, data), primaryKey);
        try {
            Field f = data.getClass().getDeclaredField(primaryKey);
            f.setAccessible(true);
            if (id != null) {
                if (f.getType() == Integer.TYPE || f.getType() == Integer.class) {
                    f.set(data, Integer.parseInt(id.toString()));
                } else if (f.getType() == Long.TYPE || f.getType() == Long.class) {
                    f.set(data, Long.parseLong(id.toString()));
                } else if (f.getType() == String.class) {
                    f.set(data, id.toString());
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return id;
    }

    @Override
    public int modify(String tableName, Domain domain) {
        return this.operator.update(this.parser.getUpdateSql(tableName, domain));
    }

    @Override
    public <T> T getById(String tableName, Serializable id) {
        return this.getById(tableName, this.ormContext.getDomainClass(tableName), id);
    }

    private <T> T getById(String tableName, Class clazz, Serializable id) {
        if (id == null) {
            return null;
        }
        return this.generateObject(clazz, this.ormContext.getAttributes(tableName), this.queryForMap(this.parser.getSelectHql(new Conditions(tableName).putEW((Serializable)((Object)"id"), id))));
    }

    @Override
    public boolean saveOrUpdate(String tableName, List<? extends Domain> datas) {
        ArrayList<Domain> addList = new ArrayList<Domain>(datas.size() / 2);
        ArrayList<Domain> updateList = new ArrayList<Domain>(datas.size() / 2);
        for (int i = 0; i < datas.size(); ++i) {
            if (this.checkIdExist(datas.get(i))) {
                updateList.add(datas.get(i));
                continue;
            }
            addList.add(datas.get(i));
        }
        boolean success = true;
        if (updateList.size() > 0) {
            boolean bl = success = success && this.modifyByBatch(tableName, updateList);
        }
        if (addList.size() > 0) {
            success = success && this.addByBatch(tableName, addList);
        }
        return success;
    }

    @Override
    public void saveOrUpdate(String tableName, Domain data) {
        if (this.checkIdExist(data)) {
            this.modify(tableName, data);
        } else {
            this.add(tableName, data);
        }
    }

    @Override
    public void execute(String sql) {
        this.operator.execute(sql);
    }

    @Override
    public boolean modifyByBatchWithColumn(List<? extends Domain> dataList, String[] cols) {
        if (dataList == null || dataList.size() == 0) {
            return false;
        }
        return this.modifyByBatchWithColumn(this.getTableName(dataList.get(0)), dataList, cols);
    }

    @Override
    public boolean modifyByBatchWithColumn(String tableName, List<? extends Domain> dataList, String[] cols) {
        if (dataList == null || dataList.size() == 0) {
            return false;
        }
        if (cols == null || cols.length == 0) {
            return false;
        }
        Domain domain = dataList.get(0);
        if (DbConfig.getDatabaseType() == "mysql") {
            BatchSqlHolder sqlHolder = this.parser.getBatchUpdateSql(tableName, cols, dataList);
            return this.operator.batchUpdate(sqlHolder);
        }
        HashSet<String> set = new HashSet<String>();
        for (String col : cols) {
            set.add(col);
        }
        for (Domain domain2 : dataList) {
            domain2.setUpdateField(set);
            this.modify(tableName, domain2);
        }
        return true;
    }

    @Override
    public String getGroupConcat(Conditions conditions, String attribute, String separator) {
        String sql = this.parser.getGroupConcatSql(conditions, attribute, separator);
        return this.operator.queryForObject(sql, String.class);
    }

    @Override
    public Double getDouble(Conditions conditions) {
        return this.operator.queryForObject(this.parser.getSelectHql(conditions), Double.class);
    }

    @Override
    public Integer getInteger(Conditions conditions) {
        return this.operator.queryForObject(this.parser.getSelectHql(conditions), Integer.class);
    }

    @Override
    public Long getLong(Conditions conditions) {
        return this.operator.queryForObject(this.parser.getSelectHql(conditions), Long.class);
    }

    @Override
    public Date getDate(Conditions conditions) {
        return this.operator.queryForObject(this.parser.getSelectHql(conditions), Date.class);
    }

    @Override
    public Double getMin(Conditions conditions, String attribute) {
        conditions.setSelectValue("min(" + attribute + ")");
        return this.getDouble(conditions);
    }

    @Override
    public <T> T getMinDomain(Conditions conditions, String attribute) {
        conditions.putASC((Serializable)((Object)attribute));
        return this.getOne(conditions);
    }

    @Override
    public <T> T getColumn(Conditions conditions, String attribute) {
        List<T> list = this.getColumnList(conditions, attribute);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public boolean checkExist(Class clazz, String colName, Serializable value) {
        return this.checkExist(clazz, colName, value, (Serializable)Integer.valueOf(0));
    }

    @Override
    public boolean checkExist(String tableName, String colName, Serializable value) {
        return this.checkExist(tableName, colName, value, (Serializable)Integer.valueOf(0));
    }

    @Override
    public boolean checkMultiExist(Class clazz, Serializable ... args) {
        return this.checkMultiExist(this.getTableName(clazz), args);
    }

    @Override
    public boolean checkMultiExistWithExceptId(Class clazz, Serializable exceptId, Serializable ... args) {
        return this.checkMultiExistWithExceptId(this.getTableName(clazz), exceptId, args);
    }

    @Override
    public boolean checkMultiExist(String tableName, Serializable ... args) {
        if (args == null || args.length % 2 != 0) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        Conditions conditions = new Conditions(tableName);
        for (int i = 0; i < args.length; ++i) {
            conditions.putEW(args[i], args[i + 1]);
            ++i;
        }
        return this.getCount(conditions) > 0;
    }

    @Override
    public boolean checkMultiExistWithExceptId(String tableName, Serializable exceptId, Serializable ... args) {
        if (args == null || args.length % 2 != 0) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        Conditions conditions = new Conditions(tableName);
        for (int i = 0; i < args.length; ++i) {
            conditions.putEW(args[i], args[i + 1]);
            ++i;
        }
        return this.getCount(conditions.putUE((Serializable)((Object)"id"), exceptId)) > 0;
    }

    private IDomainControl getDomainControl() {
        JdbcService jdbcService = this;
        return jdbcService.dbConfig.getDomainControl();
    }

    private String getTableName(Domain domain) {
        String tableName = this.getDomainControl() != null ? this.getDomainControl().getDomainName(domain.getClass()) : domain.getClass().getSimpleName();
        return tableName;
    }

    private String getTableName(Class clazz) {
        String tableName = this.getDomainControl() != null ? this.getDomainControl().getDomainName(clazz) : clazz.getSimpleName();
        return tableName;
    }

    @Override
    public boolean checkMultiExistByOr(Class clazz, Serializable ... args) {
        return this.checkMultiExistByOr(this.getTableName(clazz), args);
    }

    @Override
    public boolean checkMultiExistWithExceptIdByOr(Class clazz, Serializable exceptId, Serializable ... args) {
        return this.checkMultiExistWithExceptIdByOr(this.getTableName(clazz), exceptId, args);
    }

    @Override
    public boolean checkMultiExistByOr(String tableName, Serializable ... args) {
        if (args == null || args.length % 2 != 0) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        Conditions conditions = new Conditions(tableName);
        conditions.parenthesesStart();
        for (int i = 0; i < args.length; ++i) {
            conditions.putEW(args[i], args[i + 1]);
            conditions.or();
            ++i;
        }
        conditions.parenthesesEnd();
        return this.getCount(conditions) > 0;
    }

    @Override
    public boolean checkMultiExistWithExceptIdByOr(String tableName, Serializable exceptId, Serializable ... args) {
        if (args == null || args.length % 2 != 0) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        Conditions conditions = new Conditions(tableName);
        conditions.parenthesesStart();
        for (int i = 0; i < args.length; ++i) {
            conditions.putEW(args[i], args[i + 1]);
            conditions.or();
            ++i;
        }
        conditions.parenthesesEnd();
        conditions.setLink("and");
        conditions.putUE((Serializable)((Object)"id"), exceptId);
        return this.getCount(conditions) > 0;
    }
}

