/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.services;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.atomarrow.bean.Pager;
import net.atomarrow.bean.ServiceResult;
import net.atomarrow.configs.DbConfig;
import net.atomarrow.configs.LogConfig;
import net.atomarrow.db.orm.IDomainControl;
import net.atomarrow.db.parser.Conditions;
import net.atomarrow.db.tx.TransactionMgr;
import net.atomarrow.domains.Domain;
import net.atomarrow.services.IService;
import net.atomarrow.services.JdbcService;
import net.atomarrow.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;

@org.springframework.stereotype.Service(value="service")
public class Service
implements IService {
    @Autowired
    private JdbcService service;
    private Logger log = Logger.getLogger("Service\u6267\u884c\u64cd\u4f5c:");
    protected ServiceResult SUCCESS = new ServiceResult(true, null, null);
    @Autowired
    private TransactionMgr transactionMgr;

    @Override
    public Serializable add(Domain domain) {
        Serializable id = this.service.add(domain);
        if (LogConfig.printServiceLog()) {
            this.log.info(this.getTableName(domain) + " \u6210\u529f\u6267\u884c\u4e00\u6761add\u8bed\u53e5,\u4e3b\u952e\uff1a" + id);
        }
        return id;
    }

    @Override
    public Serializable add(String tableName, Domain domain) {
        Serializable id = this.service.add(tableName, domain);
        if (LogConfig.printServiceLog()) {
            this.log.info(tableName + " \u6210\u529f\u6267\u884c\u4e00\u6761add\u8bed\u53e5,\u4e3b\u952e\uff1a" + id);
        }
        return id;
    }

    @Override
    public boolean addByBatch(List<? extends Domain> dataList) {
        boolean success = this.service.addByBatch(dataList);
        if (LogConfig.printServiceLog()) {
            if (success) {
                this.log.info(this.getTableName(dataList.get(0)) + " \u6210\u529f\u6267\u884c\u63d2\u5165" + dataList.size() + "\u6761\u6570\u636e");
            } else {
                this.log.info("\u6279\u91cf\u6dfb\u52a0\u672a\u63d2\u5165\u4efb\u4f55\u6570\u636e");
            }
        }
        return success;
    }

    @Override
    public <T extends Domain> boolean addByBatch(Class<T> clazz, List<T> dataList) {
        boolean success = this.service.addByBatch(clazz, dataList);
        if (LogConfig.printServiceLog()) {
            if (success) {
                this.log.info(this.getTableName(clazz) + " \u6210\u529f\u6267\u884c\u63d2\u5165" + dataList.size() + "\u6761\u6570\u636e");
            } else {
                this.log.info(" \u672a\u63d2\u5165\u4efb\u4f55\u6570\u636e");
            }
        }
        return success;
    }

    @Override
    public boolean checkExist(Class clazz, String colName, Serializable value, Serializable exceptId) {
        boolean success = this.service.checkExist(clazz, colName, value, exceptId);
        if (LogConfig.printServiceLog()) {
            if (success) {
                this.log.info(this.getTableName(clazz) + " \u67e5\u8be2\u5230\u5b58\u5728\u76f8\u540c\u6570\u636e");
            } else {
                this.log.info(this.getTableName(clazz) + " \u672a\u67e5\u8be2\u5230\u76f8\u540c\u6570\u636e");
            }
        }
        return success;
    }

    @Override
    public int del(Domain domain) {
        int i = this.service.del(domain);
        if (LogConfig.printServiceLog()) {
            this.log.info(this.getTableName(domain) + "\u6267\u884c" + i + "\u6761\u5220\u9664\u8bed\u53e5");
        }
        return i;
    }

    @Override
    public int delByBatch(Conditions conditions) {
        int count = this.service.delByBatch(conditions);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " \u6279\u91cf\u5220\u9664\u4e86" + count + "\u6761\u6570\u636e");
        }
        return count;
    }

    @Override
    public <T> int delById(Class<T> clazz, Serializable id) {
        int count = this.service.delById(clazz, id);
        if (LogConfig.printServiceLog()) {
            this.log.info(this.getTableName(clazz) + " \u6210\u529f\u5220\u9664\u4e86" + count + "\u6761\u6570\u636e");
        }
        return count;
    }

    @Override
    public <T> int delById(String className, Serializable id) {
        int count = this.service.delById(className, id);
        if (LogConfig.printServiceLog()) {
            this.log.info(className + "\u6210\u529f\u5220\u9664\u4e86" + count + "\u6761\u6570\u636e");
        }
        return count;
    }

    @Override
    public int executeUpdate(String Hql, Object[] params) {
        int count = this.service.executeUpdate(Hql, params);
        if (LogConfig.printServiceLog()) {
            this.log.info(Hql);
            this.log.info("\u6210\u529f\u6267\u884c\u4e86" + count + "\u6761\u6570\u636e");
        }
        return count;
    }

    @Override
    public <T> T getById(Class<T> clazz, Serializable id) {
        T t = this.service.getById(clazz, id);
        if (LogConfig.printServiceLog()) {
            if (t != null) {
                this.log.info(this.getTableName(clazz) + " \u6839\u636eid:" + id + "\u6210\u529f\u83b7\u53d6\u4e00\u4e2a\u5bf9\u8c61");
            } else {
                this.log.info(this.getTableName(clazz) + " \u6839\u636eid:" + id + "\u672a\u67e5\u8be2\u5230\u5bf9\u8c61");
            }
        }
        return t;
    }

    @Override
    public <T> List<T> getColumnList(Conditions conditions, String attribute) {
        List ts = this.service.getColumnList(conditions, attribute);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " getColumnList\u67e5\u8be2\u5230\u6570\u91cf\uff1a" + ts.size());
        }
        return ts;
    }

    @Override
    public <T> List<T> getColumnDistinctList(Conditions conditions, String attribute) {
        List ts = this.service.getColumnDistinctList(conditions, attribute);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " getColumnDistinctList\u67e5\u8be2\u5230\u6570\u91cf\uff1a" + ts.size());
        }
        return ts;
    }

    @Override
    public <T> List<T> getColumnListByPage(Conditions conditions, String attribute, Pager pager) {
        List ts = this.service.getColumnListByPage(conditions, attribute, pager);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " getColumnListByPage\u67e5\u8be2\u5230\u6570\u91cf\uff1a" + ts.size());
        }
        return ts;
    }

    @Override
    public <T> List<T> getColumnDistinctListByPage(Conditions conditions, String attribute, Pager pager) {
        List ts = this.service.getColumnDistinctListByPage(conditions, attribute, pager);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " getColumnDistinctListByPage\u67e5\u8be2\u5230\u6570\u91cf\uff1a" + ts.size());
        }
        return ts;
    }

    @Override
    public int getCount(Conditions conditions) {
        int count = this.service.getCount(conditions);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " getCount\u67e5\u8be2\u5230\u6570\u91cf\uff1a" + count);
        }
        return count;
    }

    @Override
    public <T> List<T> getDistinctList(Conditions conditions, String attribute) {
        List ts = this.service.getDistinctList(conditions, attribute);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " getDistinctList\u67e5\u8be2\u5230\u6570\u91cf\uff1a" + ts.size());
        }
        return ts;
    }

    @Override
    public int getDistinctCount(Conditions conditions, String attribute) {
        int count = this.service.getDistinctCount(conditions, attribute);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " getDistinctCount\u67e5\u8be2\u5230\u6570\u91cf\uff1a" + count);
        }
        return count;
    }

    @Override
    public <T> List<T> getList(Conditions conditions) {
        List ts = this.service.getList(conditions);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " getList\u67e5\u8be2\u5230\u6570\u91cf\uff1a" + ts.size());
        }
        return ts;
    }

    @Override
    public <T> List<T> getListByPage(Conditions conditions, Pager pager) {
        List ts = this.service.getListByPage(conditions, pager);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " getListByPage\u67e5\u8be2\u5230\u6570\u91cf\uff1a" + ts.size());
        }
        return ts;
    }

    @Override
    public <T> List<T> getListWithColumn(Conditions conditions, String[] columns) {
        List ts = this.service.getListWithColumn(conditions, columns);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " getListWithColumn\u67e5\u8be2\u5230\u6570\u91cf\uff1a" + ts.size());
        }
        return ts;
    }

    @Override
    public <T> List<T> getListWithColumnByPage(Conditions conditions, String[] columns, Pager pager) {
        List ts = this.service.getListWithColumnByPage(conditions, columns, pager);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " getListWithColumnByPage\u67e5\u8be2\u5230\u6570\u91cf\uff1a" + ts.size());
        }
        return ts;
    }

    @Override
    public Double getMax(Conditions conditions, String attribute) {
        Double max = this.service.getMax(conditions, attribute);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " max\u67e5\u8be2\u5230\u6570\u503c\uff1a" + max);
        }
        return max;
    }

    @Override
    public <T> T getMaxDomain(Conditions conditions, String attribute) {
        Object t = this.service.getMaxDomain(conditions, attribute);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " getMaxDomain\u67e5\u8be2\u5230\u6570\u503c\uff1a" + t);
        }
        return t;
    }

    @Override
    public <T> T getOne(Conditions conditions) {
        Object t = this.service.getOne(conditions);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " getOne\u67e5\u8be2\u5230\u5185\u5bb9\uff1a" + t);
        }
        return t;
    }

    @Override
    public double getSum(Conditions conditions, String attribute) {
        double sum = this.service.getSum(conditions, attribute);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " getSum\u67e5\u8be2\u5230\u5185\u5bb9\uff1a" + sum);
        }
        return sum;
    }

    @Override
    public int modify(Domain domain) {
        int i = this.service.modify(domain);
        if (LogConfig.printServiceLog()) {
            this.log.info(this.getTableName(domain) + " \u6267\u884c" + i + "\u6761\u4fee\u6539\u8bed\u53e5");
        }
        return i;
    }

    @Override
    public boolean modifyByBatch(List<? extends Domain> dataList) {
        boolean success = this.service.modifyByBatch(dataList);
        if (LogConfig.printServiceLog()) {
            if (success) {
                this.log.info(this.getTableName(dataList.get(0)) + " \u6279\u91cf\u66f4\u65b0\u6761\u76ee\uff1a" + dataList.size());
            } else {
                this.log.info("\u672a\u6279\u91cf\u66f4\u65b0\u4efb\u4f55\u6570\u636e");
            }
        }
        return success;
    }

    @Override
    public boolean modifyByBatch(String tableName, List<? extends Domain> dataList) {
        boolean success = this.service.modifyByBatch(tableName, dataList);
        if (LogConfig.printServiceLog()) {
            if (success) {
                this.log.info(tableName + " \u6279\u91cf\u66f4\u65b0\u6761\u76ee\uff1a" + dataList.size());
            } else {
                this.log.info(tableName + " \u672a\u6279\u91cf\u66f4\u65b0\u4efb\u4f55\u6570\u636e");
            }
        }
        return success;
    }

    @Override
    public int modifyWithColumn(Conditions conditions, Map<String, Serializable> columns) {
        int count = this.service.modifyWithColumn(conditions, columns);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " modifyWithColumn\uff1a\u6267\u884c\u6761\u6570" + count);
        }
        return count;
    }

    @Override
    public int modifyWithColumn(Conditions conditions, Serializable[] keyValues) {
        int count = this.service.modifyWithColumn(conditions, keyValues);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + "modifyWithColumn\uff1a\u6267\u884c\u6761\u6570" + count);
        }
        return count;
    }

    @Override
    public boolean saveOrUpdate(List<? extends Domain> datas) {
        boolean success = this.service.saveOrUpdate(datas);
        if (LogConfig.printServiceLog()) {
            if (success) {
                this.log.info(this.getTableName(datas.get(0)) + "saveOrUpdate\u6267\u884c\u6761\u6570\uff1a" + datas.size());
            } else {
                this.log.info("saveOrUpdate\u672a\u66f4\u65b0\u4efb\u4f55\u6570\u636e");
            }
        }
        return success;
    }

    @Override
    public void saveOrUpdate(Domain data) {
        this.service.saveOrUpdate(data);
        if (LogConfig.printServiceLog()) {
            this.log.info(this.getTableName(data) + "saveOrUpdate\u6267\u884c");
        }
    }

    @Override
    public boolean addByBatch(String tableName, List<? extends Domain> dataList) {
        boolean success = this.service.addByBatch(tableName, dataList);
        if (LogConfig.printServiceLog()) {
            if (success) {
                this.log.info(tableName + " addByBatch\u6dfb\u52a0\u6761\u6570\uff1a" + dataList.size());
            } else {
                this.log.info(tableName + " addByBatch\u672a\u63d2\u5165\u4efb\u4f55\u6570\u636e");
            }
        }
        return success;
    }

    @Override
    public int modify(String tableName, Domain domain) {
        int i = this.service.modify(tableName, domain);
        if (LogConfig.printServiceLog()) {
            this.log.info(tableName + " \u66f4\u65b0\u6267\u884c" + i + "\u6761\u8bed\u53e5");
        }
        return i;
    }

    @Override
    public <T> T getById(String tableName, Serializable id) {
        Object t = this.service.getById(tableName, id);
        if (LogConfig.printServiceLog()) {
            this.log.info(tableName + " \u6839\u636eid\uff1a" + id + "\u53d6\u5f97\u5185\u5bb9" + t);
        }
        return t;
    }

    @Override
    public boolean checkExist(String tableName, String colName, Serializable value, Serializable exceptId) {
        boolean success = this.service.checkExist(tableName, colName, value, exceptId);
        if (LogConfig.printServiceLog()) {
            this.log.info(tableName + " checkExist:" + success);
        }
        return success;
    }

    @Override
    public boolean saveOrUpdate(String tableName, List<? extends Domain> datas) {
        boolean success = this.service.saveOrUpdate(tableName, datas);
        if (LogConfig.printServiceLog()) {
            if (success) {
                this.log.info(tableName + " saveOrUpdate\u8bed\u53e5\u6267\u884c\u6761\u6570" + datas.size());
            } else {
                this.log.info(tableName + " saveOrUpdate\u8bed\u53e5\u672a\u66f4\u65b0\u4efb\u4f55\u6570\u636e");
            }
        }
        return success;
    }

    @Override
    public void saveOrUpdate(String tableName, Domain data) {
        this.service.saveOrUpdate(tableName, data);
        if (LogConfig.printServiceLog()) {
            this.log.info(tableName + " saveOrUpdate\u8bed\u53e5\u6267\u884c");
        }
    }

    @Override
    public void execute(String sql) {
        this.service.execute(sql);
        if (LogConfig.printServiceLog()) {
            this.log.info("execute\u8bed\u53e5\u6267\u884c:" + sql);
        }
    }

    @Override
    public boolean modifyByBatchWithColumn(List<? extends Domain> dataList, String[] cols) {
        boolean success = this.service.modifyByBatchWithColumn(dataList, cols);
        if (LogConfig.printServiceLog()) {
            if (success) {
                this.log.info(this.getTableName(dataList.get(0)) + " \u6279\u91cf\u66f4\u65b0\u6307\u5b9a\u5217\u6761\u76ee\uff1a" + dataList.size());
            } else {
                this.log.info("\u672a\u6279\u91cf\u66f4\u65b0\u4efb\u4f55\u6570\u636e");
            }
        }
        return success;
    }

    @Override
    public boolean modifyByBatchWithColumn(String tableName, List<? extends Domain> dataList, String[] cols) {
        boolean success = this.service.modifyByBatchWithColumn(tableName, dataList, cols);
        if (LogConfig.printServiceLog()) {
            if (success) {
                this.log.info(tableName + " \u6279\u91cf\u66f4\u65b0\u6307\u5b9a\u5217\u6761\u76ee\uff1a" + dataList.size());
            } else {
                this.log.info("\u672a\u6279\u91cf\u66f4\u65b0\u4efb\u4f55\u6570\u636e");
            }
        }
        return success;
    }

    @Override
    public String getGroupConcat(Conditions conditions, String attribute, String separator) {
        String result = this.service.getGroupConcat(conditions, attribute, separator);
        if (LogConfig.printServiceLog()) {
            if (StringUtil.isNotBlank(result)) {
                this.log.info(conditions.getTableName() + " GroupContact\u67e5\u8be2\u5230\u5185\u5bb9\u5408\u5e76\u4fe1\u606f\uff1a" + result);
            } else {
                this.log.info(conditions.getTableName() + "GroupContact \u672a\u67e5\u8be2\u5230\u4efb\u4f55\u4fe1\u606f");
            }
        }
        return result;
    }

    protected ServiceResult success(Object obj) {
        return this.success(obj, null);
    }

    protected ServiceResult successWith(Object obj, String ... param) {
        return this.successWith(obj, (String)null, param);
    }

    protected ServiceResult successWithout(Object obj, String ... param) {
        return this.successWithout(obj, (String)null, param);
    }

    protected ServiceResult success(Object obj, String msg) {
        return new ServiceResult(true, obj, msg);
    }

    protected ServiceResult successWith(Object obj, String msg, String ... param) {
        return new ServiceResult(true, obj, msg, param, null);
    }

    protected ServiceResult successWithout(Object obj, String msg, String ... param) {
        return new ServiceResult(true, obj, msg, null, param);
    }

    protected ServiceResult error(String msg) {
        if (LogConfig.printServiceLog()) {
            this.log.info(msg);
        }
        this.setNeedRollBack();
        return new ServiceResult(false, null, msg);
    }

    protected void setNeedRollBack() {
        if (LogConfig.printServiceLog()) {
            this.log.info("setNeedRollBack");
        }
        this.transactionMgr.setNeedRollBack();
    }

    protected ServiceResult warn(String msg) {
        if (LogConfig.printServiceLog()) {
            this.log.info(msg);
        }
        return new ServiceResult(true, true, null, msg);
    }

    @Override
    public Double getDouble(Conditions conditions) {
        Double number = this.service.getDouble(conditions);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " getDouble\u67e5\u8be2\u5230\u6570\u503c\uff1a" + number);
        }
        return number;
    }

    @Override
    public Integer getInteger(Conditions conditions) {
        Integer number = this.service.getInteger(conditions);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " getInteger\u67e5\u8be2\u5230\u6570\u503c\uff1a" + number);
        }
        return number;
    }

    @Override
    public Long getLong(Conditions conditions) {
        Long number = this.service.getLong(conditions);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " getLong\u67e5\u8be2\u5230\u6570\u503c\uff1a" + number);
        }
        return number;
    }

    @Override
    public Date getDate(Conditions conditions) {
        Date date = this.service.getDate(conditions);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " getDate\u67e5\u8be2\u5230\u6570\u503c\uff1a" + date);
        }
        return date;
    }

    @Override
    public Double getMin(Conditions conditions, String attribute) {
        Double number = this.service.getMin(conditions, attribute);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " getMin\u67e5\u8be2\u5230\u6570\u503c\uff1a" + number);
        }
        return number;
    }

    @Override
    public <T> T getMinDomain(Conditions conditions, String attribute) {
        Object t = this.service.getMinDomain(conditions, attribute);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " getMinDomain\u67e5\u8be2\u5230\u6570\u503c\uff1a" + t);
        }
        return t;
    }

    @Override
    public <T> T getColumn(Conditions conditions, String attribute) {
        Object t = this.service.getColumn(conditions, attribute);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " getColumn\u67e5\u8be2\u5230\u5185\u5bb9\uff1a" + t);
        }
        return t;
    }

    @Override
    public <T> List<T> getDistinctListPage(Conditions conditions, String attribute, Pager pager) {
        List ts = this.service.getDistinctListPage(conditions, attribute, pager);
        if (LogConfig.printServiceLog()) {
            this.log.info(conditions.getTableName() + " getDistinctListPage\u67e5\u8be2\u5230\u6570\u91cf\uff1a" + ts.size());
        }
        return ts;
    }

    @Override
    public boolean checkExist(Class clazz, String colName, Serializable value) {
        return this.checkExist(clazz, colName, value, (Serializable)Integer.valueOf(0));
    }

    @Override
    public boolean checkExist(String tableName, String colName, Serializable value) {
        return this.checkExist(tableName, colName, value, (Serializable)Integer.valueOf(0));
    }

    @Override
    public boolean checkMultiExist(String tableName, Serializable ... args) {
        boolean success = this.service.checkMultiExist(tableName, args);
        if (LogConfig.printServiceLog()) {
            if (success) {
                this.log.info(tableName + " \u67e5\u8be2\u5230\u5b58\u5728\u76f8\u540c\u6570\u636e");
            } else {
                this.log.info(tableName + " \u672a\u67e5\u8be2\u5230\u76f8\u540c\u6570\u636e");
            }
        }
        return success;
    }

    @Override
    public boolean checkMultiExistWithExceptId(String tableName, Serializable exceptId, Serializable ... args) {
        boolean success = this.service.checkMultiExistWithExceptId(tableName, exceptId, args);
        if (LogConfig.printServiceLog()) {
            if (success) {
                this.log.info(tableName + " \u67e5\u8be2\u5230\u5b58\u5728\u76f8\u540c\u6570\u636e");
            } else {
                this.log.info(tableName + " \u672a\u67e5\u8be2\u5230\u76f8\u540c\u6570\u636e");
            }
        }
        return success;
    }

    @Override
    public boolean checkMultiExist(Class clazz, Serializable ... args) {
        boolean success = this.service.checkMultiExist(clazz, args);
        if (LogConfig.printServiceLog()) {
            if (success) {
                this.log.info(this.getTableName(clazz) + " \u67e5\u8be2\u5230\u5b58\u5728\u76f8\u540c\u6570\u636e");
            } else {
                this.log.info(this.getTableName(clazz) + " \u672a\u67e5\u8be2\u5230\u76f8\u540c\u6570\u636e");
            }
        }
        return success;
    }

    @Override
    public boolean checkMultiExistWithExceptId(Class clazz, Serializable exceptId, Serializable ... args) {
        boolean success = this.service.checkMultiExistWithExceptId(clazz, exceptId, args);
        if (LogConfig.printServiceLog()) {
            if (success) {
                this.log.info(this.getTableName(clazz) + " \u67e5\u8be2\u5230\u5b58\u5728\u76f8\u540c\u6570\u636e");
            } else {
                this.log.info(this.getTableName(clazz) + " \u672a\u67e5\u8be2\u5230\u76f8\u540c\u6570\u636e");
            }
        }
        return success;
    }

    private IDomainControl getDomainControl() {
        return DbConfig.getDomainControl();
    }

    private String getTableName(Domain domain) {
        String tableName = this.getDomainControl() != null ? this.getDomainControl().getDomainName(domain.getClass()) : domain.getClass().getSimpleName();
        return tableName;
    }

    private String getTableName(Class clazz) {
        String tableName = this.getDomainControl() != null ? this.getDomainControl().getDomainName(clazz) : clazz.getSimpleName();
        return tableName;
    }

    @Override
    public boolean checkMultiExistByOr(Class clazz, Serializable ... args) {
        boolean success = this.service.checkMultiExistByOr(clazz, args);
        if (LogConfig.printServiceLog()) {
            if (success) {
                this.log.info(this.getTableName(clazz) + " \u67e5\u8be2\u5230\u5b58\u5728\u76f8\u540c\u6570\u636e");
            } else {
                this.log.info(this.getTableName(clazz) + " \u672a\u67e5\u8be2\u5230\u76f8\u540c\u6570\u636e");
            }
        }
        return success;
    }

    @Override
    public boolean checkMultiExistWithExceptIdByOr(Class clazz, Serializable exceptId, Serializable ... args) {
        boolean success = this.service.checkMultiExistWithExceptIdByOr(clazz, exceptId, args);
        if (LogConfig.printServiceLog()) {
            if (success) {
                this.log.info(this.getTableName(clazz) + " \u67e5\u8be2\u5230\u5b58\u5728\u76f8\u540c\u6570\u636e");
            } else {
                this.log.info(this.getTableName(clazz) + " \u672a\u67e5\u8be2\u5230\u76f8\u540c\u6570\u636e");
            }
        }
        return success;
    }

    @Override
    public boolean checkMultiExistByOr(String tableName, Serializable ... args) {
        boolean success = this.service.checkMultiExistByOr(tableName, args);
        if (LogConfig.printServiceLog()) {
            if (success) {
                this.log.info(tableName + " \u67e5\u8be2\u5230\u5b58\u5728\u76f8\u540c\u6570\u636e");
            } else {
                this.log.info(tableName + " \u672a\u67e5\u8be2\u5230\u76f8\u540c\u6570\u636e");
            }
        }
        return success;
    }

    @Override
    public boolean checkMultiExistWithExceptIdByOr(String tableName, Serializable exceptId, Serializable ... args) {
        boolean success = this.service.checkMultiExistWithExceptIdByOr(tableName, exceptId, args);
        if (LogConfig.printServiceLog()) {
            if (success) {
                this.log.info(tableName + " \u67e5\u8be2\u5230\u5b58\u5728\u76f8\u540c\u6570\u636e");
            } else {
                this.log.info(tableName + " \u672a\u67e5\u8be2\u5230\u76f8\u540c\u6570\u636e");
            }
        }
        return success;
    }
}

