/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.atomarrow.util.StringUtil;

public class ArrayUtil {
    public static String join(List<Serializable> array, String split) {
        if (array == null || array.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(split);
        for (Serializable s : array) {
            sb.append(s.toString()).append(split);
        }
        return sb.toString();
    }

    public static String join(Serializable[] array, String split) {
        if (array == null || array.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(split);
        for (Serializable s : array) {
            sb.append(s.toString()).append(split);
        }
        return sb.toString();
    }

    public static String join(String[] array, String split) {
        if (array == null || array.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(split);
        for (String s : array) {
            sb.append(s).append(split);
        }
        return sb.toString();
    }

    public static String[] from(String str, String split) {
        if (StringUtil.isBlank(str)) {
            return new String[0];
        }
        String[] array = str.split(split);
        if (array.length == 0) {
            return array;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String s : array) {
            if (StringUtil.isBlank(s)) continue;
            list.add(s);
        }
        return list.toArray(new String[list.size()]);
    }

    public static boolean contains(String[] arrays, String targetValue) {
        if (arrays == null) {
            return false;
        }
        HashSet<String> set = new HashSet<String>(Arrays.asList(arrays));
        return set.contains(targetValue);
    }

    public static boolean contains(String[] arrays, Integer targetValue) {
        if (targetValue == null) {
            return false;
        }
        return ArrayUtil.contains(arrays, targetValue.toString());
    }

    public static <E> Integer[] getIntegerArray(List<E> list, String columnName) {
        if (list.size() > 0) {
            Integer[] arrays = new Integer[list.size()];
            try {
                Class<?> clazz = list.get(0).getClass();
                Field field = clazz.getDeclaredField(columnName);
                if (field == null) {
                    return null;
                }
                field.setAccessible(true);
                for (int i = 0; i < list.size(); ++i) {
                    arrays[i] = (Integer)field.get(list.get(i));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return arrays;
        }
        return new Integer[0];
    }

    public static <E> String[] getStringArray(List<E> list, String columnName) {
        if (list.size() > 0) {
            String[] arrays = new String[list.size()];
            try {
                Class<?> clazz = list.get(0).getClass();
                Field field = clazz.getDeclaredField(columnName);
                if (field == null) {
                    return null;
                }
                field.setAccessible(true);
                for (int i = 0; i < list.size(); ++i) {
                    arrays[i] = (String)field.get(list.get(i));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return arrays;
        }
        return new String[0];
    }

    public static <T> T[] getDiffArray(T[] firstArray, T[] secondArray) {
        int secondLength;
        HashSet<T> set = new HashSet<T>(30);
        int firstLength = firstArray == null ? 0 : firstArray.length;
        int n = secondLength = secondArray == null ? 0 : secondArray.length;
        if (firstLength == 0 && secondLength == 0) {
            return (Object[])Array.newInstance(firstArray.getClass().getComponentType(), 0);
        }
        if (firstLength == 0) {
            set.addAll(Arrays.asList(secondArray));
        } else if (secondLength == 0) {
            set.addAll(Arrays.asList(firstArray));
        } else {
            set.addAll(Arrays.asList(secondLength > firstLength ? secondArray : firstArray));
            for (T item : secondLength > firstLength ? firstArray : secondArray) {
                if (set.contains(item)) {
                    set.remove(item);
                    continue;
                }
                set.add(item);
            }
        }
        return set.toArray((Object[])Array.newInstance(firstArray.getClass().getComponentType(), 0));
    }

    public static <T> T[] getIntersectionArray(T[] firstArray, T[] secondArray) {
        int secondLength;
        int firstLength = firstArray == null ? 0 : firstArray.length;
        int n = secondLength = secondArray == null ? 0 : secondArray.length;
        if (firstLength == 0 || secondLength == 0) {
            return (Object[])Array.newInstance(firstArray.getClass().getComponentType(), 0);
        }
        HashSet<T> set = new HashSet<T>(30);
        List<T> list = Arrays.asList(firstArray);
        for (T item : secondArray) {
            if (!list.contains(item)) continue;
            set.add(item);
        }
        return set.toArray((Object[])Array.newInstance(firstArray.getClass().getComponentType(), 0));
    }
}

