/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import net.atomarrow.util.StringUtil;

public class BeanUtil {
    public static Object getValue(String fieldName, Object object) {
        Object result = null;
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            BeanUtil.makeAccessible(field);
            result = field.get(object);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void setFieldValue(Object object, String fieldName, Object value) {
        Field field = null;
        try {
            field = object.getClass().getDeclaredField(fieldName);
            BeanUtil.makeAccessible(field);
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    protected static void makeAccessible(Field field) {
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            field.setAccessible(true);
        }
    }

    public static Object getSimpleProperty(Object bean, String propName) {
        try {
            return bean.getClass().getMethod(BeanUtil.getReadMethod(propName), new Class[0]).invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void setValueByMethod(Object obj, Field field, Object value) {
        try {
            obj.getClass().getMethod(BeanUtil.getSetMethod(field.getName()), field.getType()).invoke(obj, value);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static String getReadMethod(String name) {
        return "get" + StringUtil.toUpperCaseFirstWord(name);
    }

    private static String getSetMethod(String name) {
        return "set" + StringUtil.toUpperCaseFirstWord(name);
    }

    public static void clone(Object src, Object dest) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        Class<?> clazz = src.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            field.set(dest, field.get(src));
        }
    }
}

