/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.util;

import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.atomarrow.util.NumberUtil;
import net.atomarrow.util.StringUtil;
import net.atomarrow.util.bean.MonthBean;
import net.atomarrow.util.bean.QuarterBean;
import net.atomarrow.util.bean.WeekBean;
import net.atomarrow.util.bean.YearBean;

public class DateUtil {
    public static final String YMDE = "yyyy-MM-dd EEEE";
    public static final String YMD = "yyyy-MM-dd";
    public static final String HMS = "HH:mm:ss";
    public static final String HM = "HH:mm";
    public static final String YMDHMS = "yyyy-MM-dd HH:mm:ss";
    public static final String YMDHM = "yyyy-MM-dd HH:mm";
    public static final String MDHM = "MM-dd HH:mm";
    public static final String MD = "MM-dd";
    public static final int FLOOR = 1;
    public static final int CEIL = 2;
    public static final int ROUND = 3;

    public static Date getNow() {
        return Calendar.getInstance().getTime();
    }

    public static String format(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("", Locale.CHINA);
        sdf.applyPattern(pattern);
        return sdf.format(date);
    }

    public static Date getNowDate() {
        return new Date();
    }

    public static Date HHmmssTo000000(Date date) {
        Calendar cal = DateUtil.getCalendarByDate(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date HHmmssTo235959(Date date) {
        Calendar cal = DateUtil.getCalendarByDate(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static boolean isMonday(Date date) {
        return DateUtil.getCalendarByDate(date).get(7) == 2;
    }

    public static boolean isFirstDayOfTheMonth(Date date) {
        return DateUtil.isFirstDayOfTheMonth(DateUtil.getCalendarByDate(date));
    }

    public static boolean isFirstDayOfTheMonth(Calendar date) {
        return date.get(5) == 1;
    }

    public static boolean isFirstDayOfTheQuarter(Date date) {
        Calendar cal = DateUtil.getCalendarByDate(date);
        int month = cal.get(2) + 1;
        if (month != 1 && month != 4 && month != 7 && month != 10) {
            return false;
        }
        return DateUtil.isFirstDayOfTheMonth(date);
    }

    public static boolean isFirstDayOfTheYear(Date date) {
        Calendar cal = DateUtil.getCalendarByDate(date);
        int month = cal.get(2) + 1;
        return month == 1 && DateUtil.isFirstDayOfTheMonth(date);
    }

    public static int getQuarterNumber(Calendar cal) {
        int month = cal.get(2) + 1;
        if (month >= 1 && month <= 3) {
            return 1;
        }
        if (month >= 4 && month <= 6) {
            return 2;
        }
        if (month >= 7 && month <= 9) {
            return 3;
        }
        if (month >= 10 && month <= 12) {
            return 4;
        }
        return 0;
    }

    public static Calendar getCalendarByDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTime(date);
        return cal;
    }

    public static Date lastWeekMonday(Date date) {
        Date thisWeekMonday = DateUtil.thisWeekMonday(date);
        Calendar cal = DateUtil.getCalendarByDate(thisWeekMonday);
        cal.add(5, -7);
        return cal.getTime();
    }

    public static Date lastWeekSunday(Date date) {
        Date thisWeekSunday = DateUtil.thisWeekSunday(date);
        Calendar cal = DateUtil.getCalendarByDate(thisWeekSunday);
        cal.add(5, -7);
        return cal.getTime();
    }

    public static Date lastMonthFirstDay(Date date) {
        Calendar cal = DateUtil.getCalendarByDate(date);
        cal.set(2, cal.get(2) - 1);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date lastMonthLastDay(Date date) {
        Calendar cal = DateUtil.getCalendarByDate(date);
        cal.set(2, cal.get(2) - 1);
        cal.set(5, cal.getActualMaximum(5));
        return cal.getTime();
    }

    public static int lastQuarterFirstMonth(Date date) {
        Calendar cal = DateUtil.getCalendarByDate(date);
        cal.set(2, cal.get(2) - 3);
        return cal.get(2);
    }

    public static int lastQuarterLastMonth(Date date) {
        Calendar cal = DateUtil.getCalendarByDate(date);
        cal.set(2, cal.get(2) - 1);
        return cal.get(2);
    }

    public static Calendar getYesterDay() {
        Calendar c = Calendar.getInstance();
        c.add(5, -1);
        return c;
    }

    public static boolean isYesterday(Date finishTime) {
        Calendar yesterday = DateUtil.getYesterDay();
        Calendar finishday = Calendar.getInstance();
        finishday.setTime(finishTime);
        boolean result = yesterday.get(1) == finishday.get(1) && yesterday.get(2) == finishday.get(2) && yesterday.get(5) == finishday.get(5);
        return result;
    }

    public static boolean isNotToday(Calendar c) {
        Calendar today = Calendar.getInstance();
        boolean result = today.get(1) != c.get(1) || today.get(2) != c.get(2) || today.get(5) != c.get(5);
        return result;
    }

    public static Date thisWeekMonday(Date date) {
        if (DateUtil.isMonday(date)) {
            return date;
        }
        Calendar c = DateUtil.getCalendarByDate(date);
        do {
            c.set(5, c.get(5) - 1);
        } while (!DateUtil.isMonday(c.getTime()));
        return c.getTime();
    }

    public static Date thisWeekSunday(Date date) {
        if (DateUtil.isSunday(date)) {
            return date;
        }
        Calendar c = DateUtil.getCalendarByDate(date);
        do {
            c.set(5, c.get(5) + 1);
        } while (!DateUtil.isSunday(c.getTime()));
        return c.getTime();
    }

    public static Calendar getYesterDay(Calendar c) {
        Calendar c2 = DateUtil.getCalendarByDate(c.getTime());
        c2.add(5, -1);
        return c2;
    }

    public static Date thisYearFirstDay(Date date) {
        Calendar c = DateUtil.getCalendarByDate(date);
        c.set(2, 0);
        c.set(5, 1);
        return c.getTime();
    }

    public static Date thisYearLastDay(Date date) {
        Calendar c = DateUtil.getCalendarByDate(date);
        c.set(2, 11);
        c.set(5, 31);
        return c.getTime();
    }

    public static Date thisMonthFirstDay(Date date) {
        Calendar c = DateUtil.getCalendarByDate(date);
        c.set(5, 1);
        return c.getTime();
    }

    public static Date thisQuarterFirstDay(Date date) {
        int firstMonth = DateUtil.thisQuarterFirstMonth(date);
        Calendar c = DateUtil.getCalendarByDate(date);
        c.set(2, firstMonth - 1);
        c.set(5, 1);
        return c.getTime();
    }

    public static int thisQuarterFirstMonth(Date date) {
        Calendar c = DateUtil.getCalendarByDate(date);
        int q = DateUtil.getQuarterNumber(c);
        int month = 1;
        switch (q) {
            case 1: {
                month = 1;
                break;
            }
            case 2: {
                month = 4;
                break;
            }
            case 3: {
                month = 7;
                break;
            }
            case 4: {
                month = 10;
            }
        }
        return month;
    }

    public static int thisQuarterLastMonth(Date date) {
        Calendar c = DateUtil.getCalendarByDate(date);
        int q = DateUtil.getQuarterNumber(c);
        int month = 1;
        switch (q) {
            case 1: {
                month = 3;
                break;
            }
            case 2: {
                month = 6;
                break;
            }
            case 3: {
                month = 9;
                break;
            }
            case 4: {
                month = 12;
            }
        }
        return month;
    }

    public static boolean isSunday(Date calWhichDay) {
        return DateUtil.getCalendarByDate(calWhichDay).get(7) == 1;
    }

    public static boolean isLastDayOfTheMonth(Date calWhichDay) {
        Calendar c = DateUtil.getCalendarByDate(calWhichDay);
        c.add(5, 1);
        return c.get(5) == 1;
    }

    public static boolean isLastDayOfTheQuarter(Date calWhichDay) {
        if (!DateUtil.isLastDayOfTheMonth(calWhichDay)) {
            return false;
        }
        int currentMonth = calWhichDay.getMonth() + 1;
        return currentMonth == 3 || currentMonth == 6 || currentMonth == 9 || currentMonth == 12;
    }

    public static boolean isLastDayOfTheYear(Date calWhichDay) {
        Calendar c = DateUtil.getCalendarByDate(calWhichDay);
        return c.get(2) + 1 == 12 && c.get(5) == 31;
    }

    public static Date get365Before(Date now) {
        Calendar cal = DateUtil.getCalendarByDate(now);
        cal.add(1, -1);
        return cal.getTime();
    }

    public static String getByAgeStart(int age) {
        Calendar now = Calendar.getInstance();
        now.set(2, 0);
        now.set(5, 1);
        now.add(1, -age);
        return DateUtil.format(now.getTime(), YMD);
    }

    public static String getByAgeEnd(int age) {
        Calendar now = Calendar.getInstance();
        now.set(2, 11);
        now.set(5, 31);
        now.add(1, -age);
        return DateUtil.format(now.getTime(), YMD);
    }

    public static Calendar getFromStr(String date, String format) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            cal.setTime(sdf.parse(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        return cal;
    }

    public static Date getDate(String date) {
        if (date == null || date.isEmpty()) {
            return null;
        }
        if (NumberUtil.isLong(date) && date.length() > 10) {
            return new Date(Long.parseLong(date));
        }
        String pattern = null;
        if (date.contains("T")) {
            date = date.replaceAll("T", " ");
        }
        if (date.contains(":")) {
            if (StringUtil.count(date, ':') == 2) {
                pattern = YMDHMS;
            } else if (StringUtil.count(date, ':') == 1) {
                pattern = YMDHM;
            }
        } else {
            pattern = YMD;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getDate(String date, String format) {
        if (format == null) {
            return DateUtil.getDate(date);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getDaysAfter(Date date, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, day);
        return calendar.getTime();
    }

    public static Date getDaysAfter(int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, day);
        return calendar.getTime();
    }

    public static Date getMinutesAfter(int minute) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, minute);
        return calendar.getTime();
    }

    public static Date getHourAfter(int hour) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(11, hour);
        return calendar.getTime();
    }

    public static Date getDaysAgo(int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -day);
        return calendar.getTime();
    }

    public static Date getDaysAgo(Date date, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -day);
        return calendar.getTime();
    }

    public static Date getMinutesAgo(int minute) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -minute);
        return calendar.getTime();
    }

    public static Date getHourAgo(int hour) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(11, -hour);
        return calendar.getTime();
    }

    public static boolean isSameDay(Calendar a, Calendar b) {
        if (a.get(1) != b.get(1)) {
            return false;
        }
        if (a.get(2) != b.get(2)) {
            return false;
        }
        return a.get(5) == b.get(5);
    }

    public static boolean isTheDayBeforeYesterday(Date calWhichDay) {
        Calendar c = Calendar.getInstance();
        c.setTime(calWhichDay);
        Calendar c2 = Calendar.getInstance();
        c2.add(5, -2);
        boolean result = c.get(1) == c2.get(1) && c.get(2) == c2.get(2) && c.get(5) == c2.get(5);
        return result;
    }

    public static boolean isYesterdayOrMoreRecent(Date calWhichDay) {
        return DateUtil.HHmmssTo000000(calWhichDay).compareTo(DateUtil.HHmmssTo000000(DateUtil.getYesterDay().getTime())) >= 0;
    }

    public static int daysBetween(Date aDate, Date bDate) {
        Long time = (bDate.getTime() - aDate.getTime()) / 86400000L;
        return time.intValue();
    }

    public static int daysBetween(Date aDate, Date bDate, int mode) {
        double time = (double)(bDate.getTime() - aDate.getTime()) * 1.0 / 8.64E7;
        if (mode == 1) {
            return (int)Math.floor(time);
        }
        if (mode == 2) {
            return (int)Math.ceil(time);
        }
        if (mode == 3) {
            return (int)Math.round(time);
        }
        return (int)time;
    }

    public static Date thisMonthLastDay(Date date) {
        Calendar c = DateUtil.getCalendarByDate(DateUtil.nextMonthFirstDay(date));
        c.add(5, -1);
        return c.getTime();
    }

    public static Date thisQuarterLastDay(Date date) {
        int lastMonth = DateUtil.thisQuarterLastMonth(date);
        Calendar c = DateUtil.getCalendarByDate(date);
        c.set(2, lastMonth - 1);
        return DateUtil.thisMonthLastDay(c.getTime());
    }

    public static Date nextMonthFirstDay(Date date) {
        Calendar c = DateUtil.getCalendarByDate(date);
        c.add(2, 1);
        c.set(5, 1);
        return c.getTime();
    }

    public static Date tomorrow(Date date) {
        Calendar c = DateUtil.getCalendarByDate(date);
        c.add(5, 1);
        return c.getTime();
    }

    public static Date yesterday(Date date) {
        Calendar c = DateUtil.getCalendarByDate(date);
        c.add(5, -1);
        return c.getTime();
    }

    public static Date nextWeekMonday(Date date) {
        Date thisWeekMonday = DateUtil.thisWeekMonday(date);
        Calendar c = DateUtil.getCalendarByDate(thisWeekMonday);
        c.add(5, 7);
        return c.getTime();
    }

    public static Date[] getOneWeekAllDays(Date date) {
        Date[] dates;
        Date thisWeekMonday = DateUtil.thisWeekMonday(date);
        dates = new Date[]{thisWeekMonday, DateUtil.tomorrow(dates[0]), DateUtil.tomorrow(dates[1]), DateUtil.tomorrow(dates[2]), DateUtil.tomorrow(dates[3]), DateUtil.tomorrow(dates[4]), DateUtil.tomorrow(dates[5])};
        return dates;
    }

    public static Date nextWeekSunday(Date date) {
        Date thisWeekSunday = DateUtil.thisWeekSunday(date);
        Calendar c = DateUtil.getCalendarByDate(thisWeekSunday);
        c.add(5, 7);
        return c.getTime();
    }

    public static Date getYearLastDay(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        return calendar.getTime();
    }

    public static Date getYearFirstDay(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(6, 1);
        return calendar.getTime();
    }

    public static Time getTime(String time) {
        if (time == null) {
            return null;
        }
        if (time.contains(":")) {
            String[] strs = time.split(":");
            if (StringUtil.count(time, ':') == 2) {
                return new Time(Integer.parseInt(strs[0]), Integer.parseInt(strs[1]), Integer.parseInt(strs[2]));
            }
            if (StringUtil.count(time, ':') == 1) {
                return new Time(Integer.parseInt(strs[0]), Integer.parseInt(strs[1]), 0);
            }
        }
        return null;
    }

    public static List<Date> getContainDays(Date startDate, Date endDate) {
        ArrayList<Date> dates = new ArrayList<Date>();
        Calendar start = Calendar.getInstance();
        start.setTime(startDate);
        start.set(10, 1);
        start.set(12, 1);
        start.set(13, 1);
        start.set(14, 1);
        Calendar end = Calendar.getInstance();
        end.setTime(endDate);
        end.set(10, 1);
        end.set(12, 1);
        end.set(13, 1);
        end.set(14, 2);
        while (start.before(end)) {
            dates.add(start.getTime());
            start.add(5, 1);
        }
        return dates;
    }

    public static WeekBean getThisWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setMinimalDaysInFirstWeek(1);
        cal.setTime(date);
        int week = cal.get(3);
        int year = cal.get(1);
        return new WeekBean(year, week, DateUtil.thisWeekMonday(date), DateUtil.thisWeekSunday(date));
    }

    public static List<WeekBean> getContainWeeks(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<WeekBean> beans = new ArrayList<WeekBean>();
        Calendar start = Calendar.getInstance();
        start.setTime(startDate);
        start.set(10, 0);
        start.set(12, 0);
        start.set(13, 0);
        start.set(14, 0);
        Calendar end = Calendar.getInstance();
        end.setTime(endDate);
        end.set(10, 0);
        end.set(12, 0);
        end.set(13, 0);
        end.set(14, 1);
        HashSet<String> set = new HashSet<String>();
        while (start.before(end)) {
            WeekBean wb = DateUtil.getThisWeek(start.getTime());
            wb.setCycleStartDay(startDate);
            wb.setCycleEndDay(endDate);
            if (!set.contains(DateUtil.getKey(wb))) {
                beans.add(wb);
                set.add(DateUtil.getKey(wb));
            }
            start.add(6, 1);
        }
        return beans;
    }

    public static List<MonthBean> getContainMonths(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MonthBean> beans = new ArrayList<MonthBean>();
        Calendar start = Calendar.getInstance();
        start.setTime(startDate);
        start.set(10, 0);
        start.set(12, 0);
        start.set(13, 0);
        start.set(14, 0);
        Calendar end = Calendar.getInstance();
        end.setTime(endDate);
        end.set(10, 0);
        end.set(12, 0);
        end.set(13, 0);
        end.set(14, 1);
        HashSet<String> set = new HashSet<String>();
        while (start.before(end)) {
            MonthBean mb = DateUtil.getThisMonth(start.getTime());
            mb.setCycleStartDay(startDate);
            mb.setCycleEndDay(endDate);
            if (!set.contains(DateUtil.getKey(mb))) {
                beans.add(mb);
                set.add(DateUtil.getKey(mb));
            }
            start.add(5, 1);
        }
        return beans;
    }

    public static List<QuarterBean> getContainQuarters(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<QuarterBean> beans = new ArrayList<QuarterBean>();
        Calendar start = Calendar.getInstance();
        start.setTime(startDate);
        start.set(10, 0);
        start.set(12, 0);
        start.set(13, 0);
        start.set(14, 0);
        Calendar end = Calendar.getInstance();
        end.setTime(endDate);
        end.set(10, 0);
        end.set(12, 0);
        end.set(13, 0);
        end.set(14, 1);
        HashSet<String> set = new HashSet<String>();
        while (start.before(end)) {
            QuarterBean qb = DateUtil.getThisQuarter(start.getTime());
            qb.setCycleStartDay(startDate);
            qb.setCycleEndDay(endDate);
            if (!set.contains(DateUtil.getKey(qb))) {
                beans.add(qb);
                set.add(DateUtil.getKey(qb));
            }
            start.add(5, 1);
        }
        return beans;
    }

    public static List<YearBean> getContainYears(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<YearBean> beans = new ArrayList<YearBean>();
        Calendar start = Calendar.getInstance();
        start.setTime(startDate);
        start.set(10, 0);
        start.set(12, 0);
        start.set(13, 0);
        start.set(14, 0);
        Calendar end = Calendar.getInstance();
        end.setTime(endDate);
        end.set(10, 0);
        end.set(12, 0);
        end.set(13, 0);
        end.set(14, 1);
        HashSet<String> set = new HashSet<String>();
        while (start.before(end)) {
            YearBean yb = DateUtil.getThisYear(start.getTime());
            yb.setCycleStartDay(startDate);
            yb.setCycleEndDay(endDate);
            if (!set.contains(DateUtil.getKey(yb))) {
                beans.add(yb);
                set.add(DateUtil.getKey(yb));
            }
            start.add(5, 1);
        }
        return beans;
    }

    public static YearBean getThisYear(Date date) {
        Calendar cal = DateUtil.getCalendarByDate(date);
        int year = cal.get(1);
        return new YearBean(year, DateUtil.thisYearFirstDay(date), DateUtil.thisYearLastDay(date));
    }

    private static String getKey(YearBean yb) {
        return yb.getYear() + "";
    }

    public static QuarterBean getThisQuarter(Date date) {
        Calendar cal = DateUtil.getCalendarByDate(date);
        int year = cal.get(1);
        int quarter = DateUtil.getQuarterNumber(cal);
        return new QuarterBean(year, quarter, DateUtil.thisQuarterFirstDay(date), DateUtil.thisQuarterLastDay(date));
    }

    private static String getKey(QuarterBean qb) {
        return qb.getYear() + ":" + qb.getQuarter();
    }

    private static String getKey(MonthBean mb) {
        return mb.getYear() + ":" + mb.getMonth();
    }

    public static MonthBean getThisMonth(Date date) {
        Calendar cal = DateUtil.getCalendarByDate(date);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        return new MonthBean(year, month, DateUtil.thisMonthFirstDay(date), DateUtil.thisMonthLastDay(date));
    }

    public static int getWeekday(Date date) {
        Calendar calendar = DateUtil.getCalendarByDate(date);
        int weekday = calendar.get(7);
        return weekday == 1 ? 7 : weekday - 1;
    }

    private static String getKey(WeekBean wb) {
        return wb.getYear() + ":" + wb.getWeek();
    }

    public static StartEndDateBean getStartEndDate(Integer year, Integer month, Integer week) {
        Date startTime = null;
        Date endTime = null;
        if (month == 0) {
            startTime = DateUtil.getYearFirstDay(year);
            endTime = DateUtil.getYearLastDay(year);
        } else if (week == 0) {
            Date date = DateUtil.getDate(year + "-" + month + "-1", "yyyy-M-d");
            startTime = DateUtil.thisMonthFirstDay(date);
            endTime = DateUtil.thisMonthLastDay(date);
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setFirstDayOfWeek(2);
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, 1);
            Date monthFirstDay = DateUtil.thisMonthFirstDay(calendar.getTime());
            Date monthLastDay = DateUtil.thisMonthLastDay(calendar.getTime());
            calendar.set(4, week);
            calendar.set(7, 2);
            startTime = monthFirstDay.after(calendar.getTime()) ? monthFirstDay : calendar.getTime();
            calendar.set(7, 1);
            endTime = monthLastDay.before(calendar.getTime()) ? monthLastDay : calendar.getTime();
        }
        startTime = DateUtil.HHmmssTo000000(startTime);
        endTime = DateUtil.HHmmssTo235959(endTime);
        return new StartEndDateBean(startTime, endTime);
    }

    public static class StartEndDateBean {
        private Date startDate;
        private Date endDate;

        public StartEndDateBean(Date start, Date end) {
            this.startDate = start;
            this.endDate = end;
        }

        public StartEndDateBean(Date start, Date end, Integer cycleType) {
            this.startDate = start;
            this.endDate = end;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public void setStartDate(Date startDate) {
            this.startDate = startDate;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public void setEndDate(Date endDate) {
            this.endDate = endDate;
        }
    }
}

