/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.atomarrow.util.ArrayUtil;
import net.atomarrow.util.StringUtil;

public class FileUtil {
    public static File createFolder(String folder) {
        return FileUtil.autoCreateFolder(folder);
    }

    public static File[] getFiles(String folder) {
        File fd = new File(folder);
        if (!fd.exists()) {
            return null;
        }
        return fd.listFiles();
    }

    public static boolean copyFile(String srcFolder, String destFolder) {
        File src = new File(srcFolder);
        if (!src.exists()) {
            System.out.println("\u590d\u5236\u5931\u8d25\uff1a\u590d\u5236\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728");
            return false;
        }
        File dest = new File(destFolder);
        if (!dest.exists() && src.isDirectory()) {
            dest.mkdir();
        }
        return FileUtil.copyFile(src, dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyFile(File srcFolder, File destFolder) {
        try {
            File[] files;
            if (!srcFolder.isDirectory()) {
                InputStream is = null;
                OutputStream os = null;
                try {
                    is = new FileInputStream(srcFolder);
                    os = new FileOutputStream(destFolder);
                    FileUtil.writeFile(is, os);
                }
                finally {
                    is.close();
                    os.close();
                }
                return true;
            }
            for (File file : files = srcFolder.listFiles()) {
                if (file.isDirectory()) {
                    File dest = new File(destFolder + "/" + file.getName());
                    if (!dest.exists()) {
                        dest.mkdir();
                    }
                    FileUtil.copyFile(file, dest);
                    continue;
                }
                InputStream is = null;
                OutputStream os = null;
                try {
                    is = new FileInputStream(file);
                    os = new FileOutputStream(new File(destFolder + "/" + file.getName()));
                    FileUtil.writeFile(is, os);
                }
                finally {
                    is.close();
                    os.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean delFile(String path) {
        try {
            FileUtil.delFile(new File(path));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void delFileWithThread(final String path) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                FileUtil.delFile(path);
            }
        }).start();
    }

    private static void delFile(File path) {
        if (path.isDirectory()) {
            File[] child = path.listFiles();
            if (child != null && child.length != 0) {
                for (int i = 0; i < child.length; ++i) {
                    FileUtil.delFile(child[i]);
                    child[i].delete();
                }
            }
            path.delete();
        } else {
            path.delete();
        }
    }

    public static void writeFile(InputStream is, OutputStream os) throws IOException {
        byte[] datas = new byte[4096];
        try {
            int l;
            while ((l = is.read(datas)) != -1) {
                os.write(datas, 0, l);
                os.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeFile(InputStream is, String path) throws IOException {
        FileUtil.writeFile(is, new File(path));
    }

    public static void writeFile(InputStream is, File file) throws IOException {
        FileUtil.writeFile(is, new FileOutputStream(file));
    }

    private static File autoCreateFolder(String path) {
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveObject(String path, Object obj, boolean autoCreate) throws IOException {
        File file = new File(path);
        path = file.getAbsolutePath();
        if (autoCreate) {
            FileUtil.autoCreateFolder(path);
        }
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(file);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(obj);
            oos.flush();
            fos.flush();
        }
        finally {
            oos.close();
            fos.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T readObject(String path, Class<T> clazz) throws IOException, ClassNotFoundException {
        File file = new File(path);
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            Object t;
            fis = new FileInputStream(file);
            ois = new ObjectInputStream(fis);
            Object object = t = ois.readObject();
            return (T)object;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (ois != null) {
                ois.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveList(String path, List<?> datas, boolean autoCreate) {
        File file = new File(path);
        path = file.getAbsolutePath();
        if (autoCreate) {
            FileUtil.autoCreateFolder(path);
        }
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(file);
            oos = new ObjectOutputStream(fos);
            for (int i = 0; i < datas.size(); ++i) {
                oos.writeObject(datas.get(i));
            }
            oos.writeObject(null);
            oos.flush();
            fos.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                oos.close();
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> readList(String path, Class<T> clazz) {
        ArrayList ts = new ArrayList();
        File file = new File(path);
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            ArrayList t;
            fis = new FileInputStream(file);
            ois = new ObjectInputStream(fis);
            while ((t = ois.readObject()) != null) {
                ts.add(t);
            }
            t = ts;
            return t;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            List<T> list = null;
            return list;
        }
        catch (IOException e) {
            e.printStackTrace();
            List<T> list = null;
            return list;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            List<T> list = null;
            return list;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void saveFile(String savePlace, String fileName, String context) {
        FileUtil.mkDir(savePlace);
        try {
            if (fileName != null) {
                String path = null;
                path = !savePlace.endsWith("/") || !savePlace.endsWith("\\\\") ? savePlace + File.separatorChar + fileName : savePlace + fileName;
                File file = new File(path);
                if (!file.exists()) {
                    file.createNewFile();
                }
                FileOutputStream out = new FileOutputStream(file, false);
                if (context != null) {
                    out.write(context.getBytes("utf-8"));
                }
                out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void mkDir(String savePlace) {
        File dir;
        if (savePlace != null && !(dir = new File(savePlace)).exists()) {
            dir.mkdirs();
        }
    }

    public static boolean checkSuffix(String fileName, String suffix) {
        return FileUtil.getFileSuffix(fileName).equals(suffix);
    }

    public static boolean checkImageSuffix(String fileName) {
        return FileUtil.checkSuffix(fileName, "jpg", "jpeg", "JPG", "png", "PNG");
    }

    public static boolean checkExcelSuffix(String fileName) {
        return FileUtil.checkSuffix(fileName, "xls", "xlsx");
    }

    public static boolean checkPdfSuffix(String fileName) {
        return FileUtil.checkSuffix(fileName, "pdf");
    }

    public static boolean checkOfficeSuffix(String fileName) {
        return FileUtil.checkSuffix(fileName, "doc", "docx", "ppt", "pptx", "xls", "xlsx");
    }

    public static boolean checkDangerSuffix(String fileName) {
        return FileUtil.checkSuffix(fileName, "exe", "o", "jsp", "js", "asp", "bat");
    }

    public static boolean checkSuffix(String fileName, String ... suffixArray) {
        if (suffixArray == null || suffixArray.length == 0) {
            return false;
        }
        String fileSuffix = FileUtil.getFileSuffix(fileName);
        if (StringUtil.isBlank(fileSuffix)) {
            return false;
        }
        return ArrayUtil.contains(suffixArray, fileSuffix);
    }

    public static String getFileSuffix(String fileName) {
        if (StringUtil.isBlank(fileName)) {
            return "";
        }
        String filesuffix = null;
        StringTokenizer fx = new StringTokenizer(fileName, ".");
        while (fx.hasMoreTokens()) {
            filesuffix = fx.nextToken();
        }
        return filesuffix.toLowerCase();
    }
}

