/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Calendar;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HtmlUtil {
    private static final String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>";
    private static final String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>";
    private static final String regEx_html = "<[^>]+>";
    private static final String regEx_space = "\\s*|\t|\r|\n";

    public static String makeHtml(String templatePath, String pageFolder, Map<String, String> contentMap) {
        String filename = "";
        try {
            String templateContent = "";
            FileInputStream fileinputstream = new FileInputStream(templatePath);
            int lenght = fileinputstream.available();
            byte[] bytes = new byte[lenght];
            fileinputstream.read(bytes);
            fileinputstream.close();
            templateContent = new String(bytes, "UTF-8");
            for (String s : contentMap.keySet()) {
                templateContent = templateContent.replaceAll(s, contentMap.get(s));
            }
            Calendar calendar = Calendar.getInstance();
            filename = (int)(Math.random() * 100.0) + "" + calendar.getTimeInMillis() + ".html";
            pageFolder = pageFolder.endsWith("/") || pageFolder.endsWith("\\") ? pageFolder + filename : pageFolder + "/" + filename;
            FileOutputStream fileoutputstream = new FileOutputStream(pageFolder);
            byte[] tag_bytes = templateContent.getBytes("UTF-8");
            fileoutputstream.write(tag_bytes);
            fileoutputstream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return filename;
    }

    public static boolean makeHtml(String templatePath, String pageFolder, String filename, Map<String, String> contentMap) {
        try {
            String templateContent = "";
            FileInputStream fileinputstream = new FileInputStream(templatePath);
            int lenght = fileinputstream.available();
            byte[] bytes = new byte[lenght];
            fileinputstream.read(bytes);
            fileinputstream.close();
            templateContent = new String(bytes, "UTF-8");
            for (String s : contentMap.keySet()) {
                templateContent = templateContent.replaceAll(s, contentMap.get(s));
            }
            Calendar calendar = Calendar.getInstance();
            pageFolder = pageFolder.endsWith("/") || pageFolder.endsWith("\\") ? pageFolder + filename : pageFolder + "/" + filename;
            FileOutputStream fileoutputstream = new FileOutputStream(pageFolder);
            byte[] tag_bytes = templateContent.getBytes("UTF-8");
            fileoutputstream.write(tag_bytes);
            fileoutputstream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String processScript(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("<script", "&lt;script").replaceAll("</script", "&lt;/script");
    }

    private static String delHTMLTag(String htmlStr) {
        Pattern p_script = Pattern.compile(regEx_script, 2);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll("");
        Pattern p_style = Pattern.compile(regEx_style, 2);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll("");
        Pattern p_html = Pattern.compile(regEx_html, 2);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll("");
        Pattern p_space = Pattern.compile(regEx_space, 2);
        Matcher m_space = p_space.matcher(htmlStr);
        htmlStr = m_space.replaceAll("");
        return htmlStr.trim();
    }

    public static String getTextFromHtml(String htmlStr) {
        if (htmlStr == null) {
            return null;
        }
        htmlStr = HtmlUtil.delHTMLTag(htmlStr);
        htmlStr = htmlStr.replaceAll("&nbsp;", "");
        return htmlStr;
    }

    public static String getTextFromHtml(String htmlStr, int length) {
        String str = HtmlUtil.getTextFromHtml(htmlStr);
        if (str == null) {
            return str;
        }
        if (str.length() <= length) {
            return str;
        }
        return str.substring(0, length);
    }
}

