/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Scanner;
import net.atomarrow.util.MoneyUtil;

public class NumberUtil {
    public static final int RINT = 1;
    public static final int FLOOR = 2;
    public static final int CEIL = 3;

    public static double format(double d, int type, int digit) {
        double dn = 0.0;
        if (digit > 0) {
            dn = Math.pow(10.0, digit);
        } else if (digit < 0) {
            dn = Math.pow(0.1, Math.abs(digit));
            dn = NumberUtil.format(dn, 1, Math.abs(digit));
        } else {
            dn = 1.0;
        }
        switch (type) {
            case 1: {
                return Math.rint(d * dn) / dn;
            }
            case 2: {
                return Math.floor(d * dn) / dn;
            }
            case 3: {
                return Math.ceil(d * dn) / dn;
            }
        }
        return d;
    }

    public static double format(double d) {
        return Math.rint(d * 10.0) / 10.0;
    }

    public static double format2(double d) {
        return Math.rint(d * 100.0) / 100.0;
    }

    public static double format4(double d) {
        return Math.rint(d * 10000.0) / 10000.0;
    }

    public static boolean isInt(String str) {
        Scanner scanner = new Scanner(str);
        return scanner.hasNextInt();
    }

    public static boolean isDouble(String str) {
        Scanner scanner = new Scanner(str);
        return scanner.hasNextDouble();
    }

    public static boolean isFloat(String str) {
        Scanner scanner = new Scanner(str);
        return scanner.hasNextFloat();
    }

    public static boolean isLong(String str) {
        Scanner scanner = new Scanner(str);
        return scanner.hasNextLong();
    }

    public static Integer getInt(String str) {
        if (str == null) {
            return null;
        }
        Scanner scanner = new Scanner(str);
        return scanner.nextInt();
    }

    public static Double getDouble(String str) {
        if (str == null) {
            return null;
        }
        Scanner scanner = new Scanner(str);
        return scanner.nextDouble();
    }

    public static Float getFloat(String str) {
        if (str == null) {
            return null;
        }
        Scanner scanner = new Scanner(str);
        return Float.valueOf(scanner.nextFloat());
    }

    public static Long getLong(String str) {
        if (str == null) {
            return null;
        }
        Scanner scanner = new Scanner(str);
        return scanner.nextLong();
    }

    public static String getFormat(Double num) {
        DecimalFormat df = new DecimalFormat("#.####");
        return df.format(num);
    }

    public static String getFormatWithDelimiter(Double num) {
        NumberFormat numfmt = NumberFormat.getInstance();
        String result = numfmt.format(num);
        return result;
    }

    public static String getUpperCaseString(Double num) {
        String result = MoneyUtil.toChinese(num.toString());
        if (result.endsWith("\u5143")) {
            return result + "\u6574";
        }
        return result;
    }
}

