/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.util;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    public static boolean isNumeric(String str) {
        if (StringUtil.isBlank(str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static String toLowerCaseFirstWord(String s) {
        if (StringUtil.isBlank(s)) {
            return s;
        }
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        if (s.length() == 1) {
            return Character.toLowerCase(s.charAt(0)) + "";
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static String toUpperCaseFirstWord(String s) {
        if (StringUtil.isBlank(s)) {
            return s;
        }
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        if (s.length() == 1) {
            return Character.toUpperCase(s.charAt(0)) + "";
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static boolean isBlank(String s) {
        return s == null || s.trim().equals("");
    }

    public static boolean isNotBlank(String s) {
        return !StringUtil.isBlank(s);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.equals("");
    }

    public static boolean isNotEmpty(String s) {
        return !StringUtil.isEmpty(s);
    }

    public static int count(String s, char c) {
        if (s == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (c != s.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static String toString(String[] arrays) {
        if (arrays == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String array : arrays) {
            sb.append(array);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static String replace(String str, String from, String to) {
        if (str == null) {
            return null;
        }
        return str.replaceAll(from, to);
    }

    public static String listToString(List list, String separator) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null) continue;
            sb.append(list.get(i)).append(separator);
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    public static <T> String arrayToString(T[] args, String separator) {
        if (args == null || args.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            sb.append(args[i]).append(separator);
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    public static String getPreWords(String str, int count, String omittedWords) {
        if (str == null) {
            return null;
        }
        if (str.length() <= count) {
            return str;
        }
        String newStr = str.substring(0, count);
        if (omittedWords != null) {
            return newStr + omittedWords;
        }
        return newStr;
    }
}

