/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.util.bean;

import java.util.Date;
import net.atomarrow.util.DateUtil;
import net.atomarrow.util.bean.Option;

public class WeekBean
implements Option {
    private int year;
    private int week;
    private Date startDay;
    private Date endDay;
    private Date cycleStartDay;
    private Date cycleEndDay;

    public WeekBean(int year, int week, Date mondayOfThisWeek, Date sunDayOfThisWeek) {
        this.year = year;
        this.week = week;
        this.startDay = mondayOfThisWeek;
        this.endDay = sunDayOfThisWeek;
    }

    public Date getCycleStartDay() {
        return this.cycleStartDay;
    }

    public void setCycleStartDay(Date cycleStartDay) {
        this.cycleStartDay = cycleStartDay;
    }

    public Date getCycleEndDay() {
        return this.cycleEndDay;
    }

    public void setCycleEndDay(Date cycleEndDay) {
        this.cycleEndDay = cycleEndDay;
    }

    public int getWeek() {
        return this.week;
    }

    public void setWeek(int week) {
        this.week = week;
    }

    public Date getStartDay() {
        return this.startDay;
    }

    public void setStartDay(Date startDay) {
        this.startDay = startDay;
    }

    public Date getEndDay() {
        return this.endDay;
    }

    public void setEndDay(Date endDay) {
        this.endDay = endDay;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public Date getStartDayClever() {
        if (this.cycleStartDay != null && this.cycleStartDay.after(this.startDay)) {
            return this.cycleStartDay;
        }
        return this.startDay;
    }

    public Date getEndDayClever() {
        if (this.cycleEndDay != null && this.cycleEndDay.before(this.endDay)) {
            return this.cycleEndDay;
        }
        return this.endDay;
    }

    public Boolean getIsCurrentWeek() {
        Date date = new Date();
        return date.after(DateUtil.HHmmssTo000000(this.startDay)) && date.before(DateUtil.HHmmssTo235959(this.endDay));
    }

    @Override
    public Object getOptionValue() {
        return this.week;
    }

    @Override
    public Object getOptionText() {
        return "\u7b2c" + this.week + "\u5468";
    }
}

