/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.util.excel;

import java.util.List;
import java.util.Map;
import net.atomarrow.util.BeanUtil;
import net.atomarrow.util.excel.CellData;
import net.atomarrow.util.excel.ExcelDataChangeListener;
import net.atomarrow.util.excel.ExcelDataInterface;
import net.atomarrow.util.excel.ExcelFormatListener;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.CellRangeAddress;

public abstract class BaseData
implements ExcelDataInterface {
    protected int row;
    protected int column;
    protected CellStyle CellStyle;

    public BaseData(int row, int column, CellStyle CellStyle2) {
        this.row = row;
        this.column = column;
        this.CellStyle = CellStyle2;
    }

    @Override
    public void ReplaceAuto(int row, int column) {
        switch (this.row) {
            case -1: {
                this.row = row + 1;
                break;
            }
            case -2: {
                this.row = row;
            }
            default: {
                if (Math.abs(this.row - -99999) > 1000) break;
                this.row = row + this.row - -99999;
            }
        }
        switch (this.column) {
            case -1: {
                this.column = column + 1;
                break;
            }
            case -2: {
                this.column = column;
                break;
            }
            default: {
                if (Math.abs(this.column - -99999) > 1000) break;
                this.column = column + this.column - -99999;
            }
        }
    }

    @Override
    public CellStyle getCellStyle() {
        return this.CellStyle;
    }

    protected void processRegions(List<CellRangeAddress> regions) {
        if (regions == null) {
            return;
        }
        for (CellRangeAddress region : regions) {
            this.processRegion(region);
        }
    }

    private void processRegion(CellRangeAddress region) {
        if (region == null) {
            return;
        }
        if (this.row == region.getFirstRow() && this.column == region.getFirstColumn()) {
            return;
        }
        if (this.row >= region.getFirstRow() && this.row <= region.getLastRow() && this.column >= region.getFirstColumn() && this.column <= region.getLastColumn()) {
            this.column = region.getLastColumn();
        }
    }

    protected Object changeValueIfNecessary(String fieldName, Object value, ExcelFormatListener format) {
        Object result;
        if (format != null && (result = format.changeValue(fieldName, value, this.row, this.column)) != null) {
            if (result instanceof Throwable) {
                ((Throwable)result).printStackTrace();
            } else {
                value = result;
            }
        }
        return value;
    }

    protected void addDomainToList(List<CellRangeAddress> regions, List<CellData> cellDatas, Map columnMap, Object data, String[] columns, int index, ExcelFormatListener format, ExcelDataChangeListener dataChanger) {
        Object value = null;
        Class<?> clazz = data.getClass();
        for (String fieldName : columns) {
            value = this.changeDataIfNecessary(fieldName, data, dataChanger);
            if (value == null && columnMap != null && (value = columnMap.get(fieldName)) != null) {
                if (value instanceof List) {
                    value = ((List)value).get(index);
                } else if (value instanceof Object[]) {
                    value = ((Object[])value)[index];
                }
            }
            if (value == null) {
                value = BeanUtil.getSimpleProperty(data, fieldName);
            }
            this.processRegions(regions);
            value = this.changeValueIfNecessary(fieldName, value, format);
            cellDatas.add(new CellData(this.row, this.column++, value == null ? "" : value.toString(), this.getCellStyle()));
        }
    }

    private Object changeDataIfNecessary(String fieldName, Object data, ExcelDataChangeListener dataChanger) {
        Object result = null;
        if (dataChanger != null && (result = dataChanger.changeValue(fieldName, data, this.row, this.column)) != null && result instanceof Throwable) {
            ((Throwable)result).printStackTrace();
        }
        return result;
    }
}

