/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.util.excel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.atomarrow.util.excel.ArrayData;
import net.atomarrow.util.excel.CellData;
import net.atomarrow.util.excel.ExcelDataChangeListener;
import net.atomarrow.util.excel.ExcelDataInterface;
import net.atomarrow.util.excel.ExcelFormatListener;
import net.atomarrow.util.excel.ListData;
import net.atomarrow.util.excel.ObjectData;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExcelDatas {
    public static final int AUTO = -1;
    public static final int LAST = -2;
    public static final int BASE_LAST = -99999;
    private List<ExcelDataInterface> exceldatas = new ArrayList<ExcelDataInterface>();
    private ExcelFormatListener format;
    private ExcelDataChangeListener dataChanger;
    private List<CellRangeAddress> regions;
    private String sheetName;
    private HashMap<Integer, Integer> columnWidthMap;
    private HashMap<Integer, Integer> rowHeightMap;

    public HashMap<Integer, Integer> getColumnWidthMap() {
        return this.columnWidthMap;
    }

    public void setColumnWidth(int index, int width) {
        if (this.columnWidthMap == null) {
            this.columnWidthMap = new HashMap();
        }
        this.columnWidthMap.put(index, width);
    }

    public void setRowHeight(int index, int height) {
        if (this.rowHeightMap == null) {
            this.rowHeightMap = new HashMap();
        }
        this.rowHeightMap.put(index, height);
    }

    public String getSheetName() {
        return this.sheetName == null ? "sheet1" : this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public void addFormatListerner(ExcelFormatListener format) {
        this.format = format;
    }

    public void addRegion(CellRangeAddress region) {
        if (this.regions == null) {
            this.regions = new ArrayList<CellRangeAddress>();
        }
        this.regions.add(region);
    }

    public List<CellRangeAddress> getRegions() {
        return this.regions;
    }

    public ExcelDatas addObjectList(int row, int column, List datas, String[] columns) {
        return this.addObjectList(row, column, datas, columns, null);
    }

    public ExcelDatas addObjectList(int row, int column, Map columnMap, List datas, String[] columns) {
        return this.addObjectList(row, column, datas, columnMap, columns, null);
    }

    public ExcelDatas addStringList(int row, int column, List<String> datas) {
        return this.addStringList(row, column, datas, null);
    }

    public ExcelDatas addStringArray(int row, int column, String[] values) {
        return this.addStringArray(row, column, values, null);
    }

    public ExcelDatas addObject(int row, int column, Object data, String[] columns) {
        return this.addObject(row, column, data, columns, null);
    }

    public ExcelDatas addObject(int row, int column, Map columnMap, Object data, String[] columns) {
        return this.addObject(row, column, data, columnMap, columns, null);
    }

    private ExcelDatas addObject(int row, int column, Object data, Map columnMap, String[] columns, CellStyle CellStyle2) {
        this.exceldatas.add(new ObjectData(row, column, columnMap, data, columns, CellStyle2));
        return this;
    }

    public ExcelDatas addString(int row, int column, String s) {
        return this.addString(row, column, s, null);
    }

    public ExcelDatas addObjectList(int row, int column, List datas, String[] columns, CellStyle CellStyle2) {
        this.exceldatas.add(new ListData(row, column, datas, columns, CellStyle2));
        return this;
    }

    public ExcelDatas addObjectList(int row, int column, List datas, Map columnMap, String[] columns, CellStyle CellStyle2) {
        this.exceldatas.add(new ListData(row, column, datas, columns, columnMap, CellStyle2));
        return this;
    }

    public ExcelDatas addStringList(int row, int column, List<String> datas, CellStyle CellStyle2) {
        this.exceldatas.add(new ArrayData(row, column, datas.toArray(), CellStyle2));
        return this;
    }

    public ExcelDatas addStringArray(int row, int column, String[] values, CellStyle CellStyle2) {
        this.exceldatas.add(new ArrayData(row, column, values, CellStyle2));
        return this;
    }

    public ExcelDatas addObject(int row, int column, Object data, String[] columns, CellStyle CellStyle2) {
        this.exceldatas.add(new ObjectData(row, column, data, columns, CellStyle2));
        return this;
    }

    public ExcelDatas addString(int row, int column, String s, CellStyle CellStyle2) {
        this.exceldatas.add(new ArrayData(row, column, new String[]{s}, CellStyle2));
        return this;
    }

    public List<CellData> getCellDatas() {
        return this.getCellDatas(-1, -1);
    }

    public int getEndColumn() {
        if (this.exceldatas == null) {
            return 0;
        }
        return this.exceldatas.get(this.exceldatas.size() - 1).getEndColumn();
    }

    public int getEndRow() {
        if (this.exceldatas == null) {
            return 0;
        }
        return this.exceldatas.get(this.exceldatas.size() - 1).getEndRow();
    }

    public List<CellData> getCellDatas(int endRow, int endColumn) {
        ArrayList<CellData> cellDatas = new ArrayList<CellData>();
        for (ExcelDataInterface inter : this.exceldatas) {
            inter.ReplaceAuto(endRow, endColumn);
            cellDatas.addAll(inter.getCellDatas(this.regions, this.format, this.dataChanger));
            endRow = inter.getEndRow();
            endColumn = inter.getEndColumn();
        }
        return cellDatas;
    }

    public void addDataChanger(ExcelDataChangeListener dataChanger) {
        this.dataChanger = dataChanger;
    }

    public HashMap<Integer, Integer> getRowHeightMap() {
        return this.rowHeightMap;
    }
}

