/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.util.excel;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import net.atomarrow.converter.TypeConverter;
import net.atomarrow.util.BeanUtil;
import net.atomarrow.util.DateUtil;
import net.atomarrow.util.FileUtil;
import net.atomarrow.util.NumberUtil;
import net.atomarrow.util.SpringContextUtil;
import net.atomarrow.util.excel.CellData;
import net.atomarrow.util.excel.ExcelDatas;
import net.atomarrow.util.excel.ExcelFormatListener;
import net.atomarrow.util.excel.NullCellException;
import net.atomarrow.util.excel.SimpleHSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExcelUtil {
    private static void addStyle(HSSFWorkbook workbook, HSSFCell cell, CellStyle CellStyle2) {
        if (CellStyle2 == null) {
            return;
        }
        if (CellStyle2 instanceof SimpleHSSFCellStyle) {
            SimpleHSSFCellStyle style = (SimpleHSSFCellStyle)CellStyle2;
            HSSFCellStyle hstyle = workbook.createCellStyle();
            HSSFFont font = workbook.createFont();
            style.copyPropertiesToFont(font);
            style.copyPropertiesToStyle(hstyle);
            cell.setCellStyle(style.getStyle());
        } else {
            cell.setCellStyle(CellStyle2);
        }
    }

    public static InputStream getWorkbookInputStream(HSSFWorkbook workbook) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(content);
        return is;
    }

    public static InputStream getExcelStream(String filePath) {
        File f = new File(filePath);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return fis;
    }

    public <T> List<T> getListFromExcel(String path, Class<? extends T> clazz, String[] columns, boolean[] notNull, int startRow) throws Throwable {
        return ExcelUtil.getListFromExcel(path, clazz, columns, notNull, startRow, null);
    }

    private static boolean setValueToDomain(Class clazz, Object object, String fieldName, HSSFCell cell, TypeConverter typeConverter, boolean notNull, int currentRow, int currentCol, ExcelFormatListener listener) throws Throwable {
        Object tmp;
        boolean isNull = true;
        boolean noNull = false;
        Object value = null;
        Field field = clazz.getDeclaredField(fieldName.contains(".") ? fieldName.split("\\.")[0] : fieldName);
        DecimalFormat df = new DecimalFormat("#.###");
        if (cell == null) {
            if (notNull) {
                return true;
            }
        } else if (cell.getCellType() == 3) {
            if (notNull) {
                return true;
            }
        } else if (cell.getCellType() == 1) {
            value = cell.getStringCellValue().trim();
            if ((value == null || value.equals("")) && notNull) {
                return true;
            }
        } else if (cell.getCellType() == 4) {
            value = cell.getBooleanCellValue();
        } else if (cell.getCellType() == 0 && HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
            value = DateUtil.format(HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue()), "yyyy-MM-dd HH:mm:ss");
        } else if (cell.getCellType() == 0) {
            value = df.format(cell.getNumericCellValue());
        } else {
            throw new Throwable("Excel\u6587\u4ef6\u4e2d\u5305\u542b\u516c\u5f0f\u4fe1\u606f\u6216\u8005\u5b8f\u75c5\u6bd2\u611f\u67d3\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        if (listener != null && (tmp = listener.changeValue(fieldName, value, currentRow, currentCol)) != null) {
            if (tmp instanceof Throwable) {
                throw (Throwable)tmp;
            }
            value = tmp;
        }
        if (value == null) {
            return false;
        }
        if (value == null) {
            return false;
        }
        Class<?> type = field.getType();
        if (type == Map.class || type == HashMap.class) {
            field.setAccessible(true);
            Map map = (Map)field.get(object);
            map.put(fieldName.split("\\.")[1], value);
        } else {
            value = typeConverter.converter(new Object[]{value}, field.getType());
            BeanUtil.setValueByMethod(object, field, value);
        }
        return false;
    }

    public static InputStream exportExcel(ExcelDatas excelDatas) {
        return ExcelUtil.getWorkbookInputStream(ExcelUtil.fillSheet(new HSSFWorkbook(), excelDatas));
    }

    public static InputStream exportExcel(HSSFWorkbook workbook) {
        return ExcelUtil.getWorkbookInputStream(workbook);
    }

    public static HSSFWorkbook fillSheet(HSSFWorkbook workbook, ExcelDatas excelDatas) {
        List<CellRangeAddress> regions;
        HSSFSheet sheet = workbook.getSheet(excelDatas.getSheetName());
        if (sheet == null) {
            sheet = workbook.createSheet(excelDatas.getSheetName());
        }
        if ((regions = excelDatas.getRegions()) != null && regions.size() > 0) {
            for (CellRangeAddress region : regions) {
                sheet.addMergedRegion(region);
            }
        }
        ExcelUtil.processColumnWidth(sheet, excelDatas);
        ExcelUtil.processRowHeight(sheet, excelDatas);
        ExcelUtil.fillDatas(workbook, sheet, excelDatas);
        return workbook;
    }

    private static void fillDatas(HSSFWorkbook workbook, HSSFSheet sheet, ExcelDatas excelDatas) {
        int rowIndex = -1;
        HSSFRow row = null;
        HSSFCell cell = null;
        int sheetLastRows = sheet.getPhysicalNumberOfRows() - 1;
        HSSFRow tempRow = sheet.getRow(sheetLastRows);
        int sheetLastColumn = tempRow == null ? -1 : tempRow.getPhysicalNumberOfCells() - 1;
        List<CellData> cellDatas = excelDatas.getCellDatas(sheetLastRows, sheetLastColumn);
        for (CellData cellData : cellDatas) {
            if (cellData.getRow() != rowIndex && (row = sheet.getRow(rowIndex = cellData.getRow())) == null) {
                row = sheet.createRow(rowIndex);
            }
            if ((cell = row.getCell(cellData.getColumn())) == null) {
                cell = row.createCell(cellData.getColumn());
            }
            ExcelUtil.addStyle(workbook, cell, cellData.getCellStyle());
            if (cellData.getData().length() < 11 && NumberUtil.isDouble(cellData.getData())) {
                cell.setCellType(CellType.NUMERIC);
                if (NumberUtil.isInt(cellData.getData())) {
                    cell.setCellValue((double)NumberUtil.getInt(cellData.getData()).intValue());
                    continue;
                }
                cell.setCellValue(NumberUtil.getDouble(cellData.getData()).doubleValue());
                continue;
            }
            cell.setCellValue(cellData.getData());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream exportExcelWithHead(InputStream is, ExcelDatas excelDatas) {
        HSSFWorkbook workbook = null;
        try {
            workbook = new HSSFWorkbook(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        HSSFSheet sheet = workbook.getSheetAt(0);
        List<CellRangeAddress> regions = excelDatas.getRegions();
        if (regions != null && regions.size() > 0) {
            for (CellRangeAddress region : regions) {
                sheet.addMergedRegion(region);
            }
        }
        ExcelUtil.processColumnWidth(sheet, excelDatas);
        ExcelUtil.processRowHeight(sheet, excelDatas);
        if (excelDatas != null) {
            ExcelUtil.fillDatas(workbook, sheet, excelDatas);
        }
        return ExcelUtil.getWorkbookInputStream(workbook);
    }

    private static void processColumnWidth(HSSFSheet sheet, ExcelDatas excelDatas) {
        if (excelDatas == null) {
            return;
        }
        if (excelDatas.getColumnWidthMap() == null) {
            return;
        }
        Set<Map.Entry<Integer, Integer>> set = excelDatas.getColumnWidthMap().entrySet();
        for (Map.Entry<Integer, Integer> entry : set) {
            if (entry.getValue() == -1) {
                sheet.autoSizeColumn(entry.getKey().intValue());
                continue;
            }
            sheet.setColumnWidth(entry.getKey().intValue(), entry.getValue().intValue());
        }
    }

    private static void processRowHeight(HSSFSheet sheet, ExcelDatas excelDatas) {
        if (excelDatas == null) {
            return;
        }
        if (excelDatas.getRowHeightMap() == null) {
            return;
        }
        Set<Map.Entry<Integer, Integer>> set = excelDatas.getRowHeightMap().entrySet();
        for (Map.Entry<Integer, Integer> entry : set) {
            if (entry == null) continue;
            HSSFRow row = sheet.getRow(entry.getKey().intValue());
            if (row == null) {
                row = sheet.createRow(entry.getKey().intValue());
            }
            row.setHeight(entry.getValue().shortValue());
        }
    }

    public static InputStream exportExcelWithHead(String headPath, ExcelDatas excelDatas) {
        return ExcelUtil.exportExcelWithHead(ExcelUtil.getExcelStream(headPath), excelDatas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> getListFromExcel(String path, Class<? extends T> clazz, String[] columns, boolean[] notNull, int startRow, ExcelFormatListener listener) throws Throwable {
        ArrayList<T> list = new ArrayList<T>();
        TypeConverter typeConverter = (TypeConverter)SpringContextUtil.getBean(TypeConverter.class);
        HSSFCell currentCell = null;
        int currentRow = 0;
        int currentCol = 0;
        try (FileInputStream fis = null;){
            fis = new FileInputStream(path);
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)fis);
            HSSFWorkbook workBook = new HSSFWorkbook(fs);
            HSSFSheet sheet = workBook.getSheetAt(0);
            int rows = sheet.getLastRowNum();
            ArrayList<NullCellException> exceptions = new ArrayList<NullCellException>();
            if (rows >= startRow) {
                sheet.getMargin((short)2);
                for (int j = startRow; j <= rows; ++j) {
                    currentRow = j;
                    T domain = clazz.newInstance();
                    HSSFRow row = sheet.getRow(j);
                    if (row == null) continue;
                    boolean haveData = false;
                    for (int k = 0; k < columns.length; k = (int)((short)(k + 1))) {
                        boolean isNull;
                        currentCol = k;
                        currentCell = row.getCell(currentCol);
                        if (currentCell != null && currentCell.getCellType() != 3) {
                            haveData = true;
                        }
                        if (!(isNull = ExcelUtil.setValueToDomain(clazz, domain, columns[currentCol], currentCell, typeConverter, notNull[currentCol], currentRow, currentCol, listener))) continue;
                        exceptions.add(new NullCellException("\u5bfc\u5165Excel\u683c\u5f0f\u9519\u8bef\uff1a\u7b2c" + (currentRow + 1) + "\u884c\u7b2c" + (currentCol + 1) + "\u5217\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                    }
                    if (!haveData) {
                        exceptions.clear();
                        haveData = false;
                        continue;
                    }
                    if (exceptions.size() > 0) {
                        throw (NullCellException)exceptions.get(0);
                    }
                    list.add(domain);
                }
            }
        }
        return list;
    }

    private int getMustNotNullCount(boolean[] notNull) {
        int count = 0;
        for (boolean b : notNull) {
            if (!b) continue;
            ++count;
        }
        return count;
    }

    public InputStream exportExcel(List<ExcelDatas> excelDatass) {
        HSSFWorkbook workBook = new HSSFWorkbook();
        for (ExcelDatas datas : excelDatass) {
            ExcelUtil.fillSheet(workBook, datas);
        }
        return ExcelUtil.getWorkbookInputStream(workBook);
    }

    public static void addPicture(String path, HSSFWorkbook workbook, String sheetName, int row1, int col1, int row2, int col2) {
        HSSFSheet sheet = workbook.getSheet(sheetName);
        if (sheet == null) {
            sheet = workbook.createSheet(sheetName);
        }
        if (path.startsWith("http")) {
            try {
                ExcelUtil.addPicture(new URL(path), workbook, sheet, row1, col1, row2, col2);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else {
            String rootpath = Thread.currentThread().getContextClassLoader().getResource("/").getFile();
            path = rootpath.substring(0, path.indexOf("WEB-INF")) + path;
            ExcelUtil.addPicture(new File(path), workbook, sheet, row1, col1, row2, col2);
        }
    }

    public static void addPicture(File file, HSSFWorkbook workbook, String sheetName, int row1, int col1, int row2, int col2) {
        HSSFSheet sheet = workbook.getSheet(sheetName);
        if (sheet == null) {
            sheet = workbook.createSheet(sheetName);
        }
        ExcelUtil.addPicture(file, workbook, sheet, row1, col1, row2, col2);
    }

    private static void addPicture(File file, HSSFWorkbook workbook, HSSFSheet sheet, int row1, int col1, int row2, int col2) {
        BufferedImage bufferImg = null;
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        String fileType = FileUtil.getFileSuffix(file.getName());
        try {
            bufferImg = ImageIO.read(file);
            ImageIO.write((RenderedImage)bufferImg, fileType, byteArrayOut);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HSSFPatriarch patriarch = sheet.getDrawingPatriarch();
        if (patriarch == null) {
            patriarch = sheet.createDrawingPatriarch();
        }
        HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 0, 0, (short)col1, row1, (short)col2, row2);
        int picType = 5;
        if (fileType.equals("jpg") || fileType.equals("jpeg")) {
            picType = 5;
        } else if (fileType.equals("png")) {
            picType = 6;
        }
        patriarch.createPicture(anchor, workbook.addPicture(byteArrayOut.toByteArray(), picType));
    }

    private static void addPicture(URL url, HSSFWorkbook workbook, HSSFSheet sheet, int row1, int col1, int row2, int col2) {
        BufferedImage bufferImg = null;
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        String fileType = url.getPath().substring(url.getPath().lastIndexOf(".") + 1);
        try {
            bufferImg = ImageIO.read(url);
            ImageIO.write((RenderedImage)bufferImg, fileType, byteArrayOut);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HSSFPatriarch patriarch = sheet.getDrawingPatriarch();
        if (patriarch == null) {
            patriarch = sheet.createDrawingPatriarch();
        }
        HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 0, 0, (short)col1, row1, (short)col2, row2);
        int picType = 5;
        if (fileType.equals("jpg") || fileType.equals("jpeg")) {
            picType = 5;
        } else if (fileType.equals("png")) {
            picType = 6;
        }
        patriarch.createPicture(anchor, workbook.addPicture(byteArrayOut.toByteArray(), picType));
    }
}

