/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.util.excel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.atomarrow.util.excel.BaseData;
import net.atomarrow.util.excel.CellData;
import net.atomarrow.util.excel.ExcelDataChangeListener;
import net.atomarrow.util.excel.ExcelFormatListener;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.CellRangeAddress;

public class ListData
extends BaseData {
    private List datas;
    private String[] columns;
    private Map columnMap;

    public ListData(int row, int column, List datas, String[] columns, CellStyle CellStyle2) {
        super(row, column, CellStyle2);
        this.datas = datas;
        this.columns = columns;
    }

    public ListData(int row, int column, List datas2, String[] columns2, Map columnMap, CellStyle cellStyle) {
        this(row, column, datas2, columns2, cellStyle);
        this.columnMap = columnMap;
    }

    public List getList() {
        return this.datas;
    }

    @Override
    public List<CellData> getCellDatas(List<CellRangeAddress> regions) {
        return this.getCellDatas(regions, null, null);
    }

    @Override
    public List<CellData> getCellDatas(List<CellRangeAddress> regions, ExcelFormatListener format, ExcelDataChangeListener dataChanger) {
        this.processRegions(regions);
        int startColumn = this.column;
        ArrayList<CellData> cellDatas = new ArrayList<CellData>();
        int index = 0;
        for (Object data : this.datas) {
            this.column = startColumn;
            this.addDomainToList(regions, cellDatas, this.columnMap, data, this.columns, index++, format, dataChanger);
            ++this.row;
        }
        return cellDatas;
    }

    @Override
    public int getEndColumn() {
        return this.column - 1;
    }

    @Override
    public int getEndRow() {
        return this.row - 1;
    }
}

