/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.util.excel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.atomarrow.util.excel.SimpleHSSFFont;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public final class SimpleHSSFCellStyle
implements CellStyle {
    private HSSFCellStyle style;
    private HSSFFont font;
    private Boolean hidden;
    private Boolean locked;
    private Short alignment;
    private Short verticalAlignment;
    private Short rotation;
    private Short indention;
    private Short borderLeft;
    private Short borderRight;
    private Short borderTop;
    private Short borderBottom;
    private Short leftBorderColor;
    private Short rightBorderColor;
    private Short topBorderColor;
    private Short bottomBorderColor;
    private Short fillPattern;
    private Short fillBackgroundColor;
    private Short fillForegroundColor;
    private String userStyleName;
    private Boolean wrapText;
    private Short dataFormat;
    private SimpleHSSFFont simpleHSSFFont;
    public static final int STYLE_MODEL_NONE = 0;
    public static final int STYLE_MODEL_TITLE = 1;
    public static final int STYLE_MODEL_HEADER = 2;
    public static final int STYLE_MODEL_DATACONTENT = 3;
    private int stytleModel = 0;
    private Boolean quotePrefix;
    private HorizontalAlignment horizontalAlignment;
    private VerticalAlignment vAlignment;
    private BorderStyle borderLeftEnum;
    private BorderStyle borderRightEnum;
    private BorderStyle borderTopEnum;
    private BorderStyle borderBottomEnum;
    private FillPatternType fp;
    private Boolean shrinkToFit;
    private Short readingOrder;

    public void setFont(Font font) {
        this.setFont((SimpleHSSFFont)font);
    }

    public void setFont(SimpleHSSFFont font) {
        this.simpleHSSFFont = font;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setAlignment(short align) {
        this.alignment = align;
    }

    public void setWrapText(boolean wrapped) {
        this.wrapText = wrapped;
    }

    public void setVerticalAlignment(short align) {
        this.verticalAlignment = align;
    }

    public void setRotation(short rotation) {
        this.rotation = rotation;
    }

    public void setIndention(short indent) {
        this.indention = indent;
    }

    public void setBorderLeft(short border) {
        this.borderLeft = border;
    }

    public void setBorderRight(short border) {
        this.borderRight = border;
    }

    public void setBorderTop(short border) {
        this.borderTop = border;
    }

    public void setBorderBottom(short border) {
        this.borderBottom = border;
    }

    public void setBorder(short borderTop, short borderBottom, short borderLeft, short borderRight) {
        this.setBorderTop(borderTop);
        this.setBorderBottom(borderBottom);
        this.setBorderBottom(borderLeft);
        this.setBorderRight(borderRight);
    }

    public void setLeftBorderColor(short color) {
        this.leftBorderColor = color;
    }

    public void setRightBorderColor(short color) {
        this.rightBorderColor = color;
    }

    public void setTopBorderColor(short color) {
        this.topBorderColor = color;
    }

    public void setBottomBorderColor(short color) {
        this.bottomBorderColor = color;
    }

    public void setBorderColor(short topBorderColor, short bottomBorderColor, short leftBorderColor, short rightBorderColor) {
        this.setTopBorderColor(topBorderColor);
        this.setBottomBorderColor(bottomBorderColor);
        this.setLeftBorderColor(leftBorderColor);
        this.setRightBorderColor(rightBorderColor);
    }

    public void setFillPattern(short fp) {
        this.fillPattern = fp;
    }

    public void setFillBackgroundColor(short bg) {
        this.fillBackgroundColor = bg;
    }

    public void setFillForegroundColor(short bg) {
        this.fillForegroundColor = bg;
    }

    public void setUserStyleName(String styleName) {
        this.userStyleName = styleName;
    }

    public HSSFCellStyle getStyle() {
        return this.style;
    }

    public void copyPropertiesToStyle(HSSFCellStyle style) {
        Method[] methods;
        this.style = style;
        for (Method method : methods = style.getClass().getMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith("set")) continue;
            String fieldName = methodName.substring(3, methodName.length());
            Class<?>[] params = method.getParameterTypes();
            if (params[0].isEnum()) {
                fieldName = fieldName + "Enum";
            }
            String getterName = "get" + fieldName;
            try {
                Method getter = this.getClass().getMethod(getterName, null);
                Object value = getter.invoke((Object)this, null);
                if (value == null) continue;
                method.invoke((Object)style, value);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }

    public void copyPropertiesToFont(HSSFFont font) {
        if (this.simpleHSSFFont != null) {
            this.simpleHSSFFont.copyPropertiesToStyle(font);
            this.font = font;
        }
    }

    public boolean getHidden() {
        return this.hidden == null ? this.style.getHidden() : this.hidden.booleanValue();
    }

    public boolean getLocked() {
        return this.locked == null ? this.style.getLocked() : this.locked.booleanValue();
    }

    public short getAlignment() {
        return this.alignment == null ? this.style.getAlignment() : this.alignment.shortValue();
    }

    public short getVerticalAlignment() {
        return this.verticalAlignment == null ? this.style.getVerticalAlignment() : this.verticalAlignment.shortValue();
    }

    public short getRotation() {
        return this.rotation == null ? this.style.getRotation() : this.rotation.shortValue();
    }

    public short getIndention() {
        return this.indention == null ? this.style.getIndention() : this.indention.shortValue();
    }

    public short getBorderLeft() {
        return this.borderLeft == null ? this.style.getBorderLeft() : this.borderLeft.shortValue();
    }

    public short getBorderRight() {
        return this.borderRight == null ? this.style.getBorderRight() : this.borderRight.shortValue();
    }

    public short getBorderTop() {
        return this.borderTop == null ? this.style.getBorderTop() : this.borderTop.shortValue();
    }

    public short getBorderBottom() {
        return this.borderBottom == null ? this.style.getBorderBottom() : this.borderBottom.shortValue();
    }

    public short getLeftBorderColor() {
        return this.leftBorderColor == null ? this.style.getLeftBorderColor() : this.leftBorderColor.shortValue();
    }

    public short getRightBorderColor() {
        return this.rightBorderColor == null ? this.style.getRightBorderColor() : this.rightBorderColor.shortValue();
    }

    public short getTopBorderColor() {
        return this.topBorderColor == null ? this.style.getTopBorderColor() : this.topBorderColor.shortValue();
    }

    public short getBottomBorderColor() {
        return this.bottomBorderColor == null ? this.style.getBottomBorderColor() : this.bottomBorderColor.shortValue();
    }

    public short getFillPattern() {
        return this.fillPattern == null ? this.style.getFillPattern() : this.fillPattern.shortValue();
    }

    public short getFillBackgroundColor() {
        return this.fillBackgroundColor == null ? this.style.getFillBackgroundColor() : this.fillBackgroundColor.shortValue();
    }

    public short getFillForegroundColor() {
        return this.fillForegroundColor == null ? this.style.getFillForegroundColor() : this.fillForegroundColor.shortValue();
    }

    public String getUserStyleName() {
        return this.userStyleName == null ? this.style.getUserStyleName() : this.userStyleName;
    }

    public boolean getWrapText() {
        return this.wrapText == null ? this.style.getWrapText() : this.wrapText.booleanValue();
    }

    public short getDataFormat() {
        return this.dataFormat == null ? this.style.getDataFormat() : this.dataFormat.shortValue();
    }

    public void setDataFormat(short dataFormat) {
        this.dataFormat = dataFormat;
    }

    public void cloneStyleFrom(CellStyle source) {
        this.style.cloneStyleFrom(source);
    }

    public String getDataFormatString() {
        return this.style.getDataFormatString();
    }

    public Color getFillBackgroundColorColor() {
        return this.style.getFillBackgroundColorColor();
    }

    public Color getFillForegroundColorColor() {
        return this.style.getFillBackgroundColorColor();
    }

    public short getFontIndex() {
        return this.style.getFontIndex();
    }

    public HSSFFont getFont() {
        return this.font;
    }

    public short getIndex() {
        return this.style.getIndex();
    }

    public SimpleHSSFFont getSimpleHSSFFont() {
        return this.simpleHSSFFont;
    }

    public void setSimpleHSSFFont(SimpleHSSFFont simpleHSSFFont) {
        this.simpleHSSFFont = simpleHSSFFont;
    }

    public int getStytleModel() {
        return this.stytleModel;
    }

    public void setStytleModel(int stytleModel) {
        this.stytleModel = stytleModel;
    }

    public void setQuotePrefixed(boolean quotePrefix) {
        this.quotePrefix = quotePrefix;
    }

    public boolean getQuotePrefixed() {
        return this.quotePrefix == null ? this.style.getQuotePrefixed() : this.quotePrefix.booleanValue();
    }

    public void setAlignment(HorizontalAlignment align) {
        this.horizontalAlignment = align;
    }

    public HorizontalAlignment getAlignmentEnum() {
        return this.horizontalAlignment == null ? this.style.getAlignmentEnum() : this.horizontalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment align) {
        this.vAlignment = align;
    }

    public VerticalAlignment getVerticalAlignmentEnum() {
        return this.vAlignment == null ? this.style.getVerticalAlignmentEnum() : this.vAlignment;
    }

    public void setBorderLeft(BorderStyle border) {
        this.borderLeftEnum = border;
    }

    public BorderStyle getBorderLeftEnum() {
        return this.borderLeftEnum == null ? this.style.getBorderLeftEnum() : this.borderLeftEnum;
    }

    public void setBorderRight(BorderStyle border) {
        this.borderRightEnum = border;
    }

    public BorderStyle getBorderRightEnum() {
        return this.borderRightEnum == null ? this.style.getBorderRightEnum() : this.borderRightEnum;
    }

    public void setBorderTop(BorderStyle border) {
        this.borderTopEnum = border;
    }

    public BorderStyle getBorderTopEnum() {
        return this.borderTopEnum == null ? this.style.getBorderTopEnum() : this.borderTopEnum;
    }

    public void setBorderBottom(BorderStyle border) {
        this.borderBottomEnum = border;
    }

    public BorderStyle getBorderBottomEnum() {
        return this.borderBottomEnum == null ? this.style.getBorderBottomEnum() : this.borderBottomEnum;
    }

    public void setFillPattern(FillPatternType fp) {
        this.fp = fp;
    }

    public FillPatternType getFillPatternEnum() {
        return this.fp == null ? this.style.getFillPatternEnum() : this.fp;
    }

    public void setShrinkToFit(boolean shrinkToFit) {
        this.shrinkToFit = shrinkToFit;
    }

    public boolean getShrinkToFit() {
        return this.shrinkToFit == null ? this.style.getShrinkToFit() : this.shrinkToFit.booleanValue();
    }

    public void setReadingOrder(short order) {
        this.readingOrder = order;
    }

    public short getReadingOrder() {
        return this.readingOrder == null ? this.style.getReadingOrder() : this.readingOrder.shortValue();
    }
}

