/*
 * Decompiled with CFR 0.152.
 */
package net.atomarrow.util.map;

import java.util.HashMap;
import java.util.Map;

public class NumberMap<K, T extends Number>
extends HashMap<K, Number> {
    private Map<K, Integer> count = new HashMap<K, Integer>();
    private int totalCount;
    private double totalValue;

    public void addNumber(K key, T value) {
        ++this.totalCount;
        Object num = this.get(key);
        this.totalValue += ((Number)num).doubleValue();
        if (num == null) {
            this.put(key, value);
            this.count.put(key, 1);
        } else {
            if (value instanceof Integer) {
                num = ((Number)value).intValue() + ((Number)value).intValue();
            } else if (value instanceof Double) {
                num = ((Number)value).doubleValue() + ((Number)value).doubleValue();
            } else if (value instanceof Float) {
                num = Float.valueOf(((Number)value).floatValue() + ((Number)value).floatValue());
            } else if (value instanceof Long) {
                num = ((Number)value).longValue() + ((Number)value).longValue();
            } else if (value instanceof Short) {
                num = ((Number)value).shortValue() + ((Number)value).shortValue();
            } else if (value instanceof Byte) {
                num = ((Number)value).byteValue() + ((Number)value).byteValue();
            }
            this.put(key, num);
            this.count.put(key, this.count.get(key) + 1);
        }
    }

    @Override
    public T get(Object key) {
        return (T)((Number)super.get(key));
    }

    public double getAvg(Object key) {
        Number value = (Number)super.get(key);
        double num = -1.0;
        int n = this.count.get(key);
        if (value instanceof Integer) {
            num = value.intValue() / n;
        } else if (value instanceof Double) {
            num = value.doubleValue() / (double)n;
        } else if (value instanceof Float) {
            num = value.floatValue() / (float)n;
        } else if (value instanceof Long) {
            num = value.longValue() / (long)n;
        } else if (value instanceof Short) {
            num = value.shortValue() / n;
        } else if (value instanceof Byte) {
            num = value.byteValue() / n;
        }
        return num;
    }

    public double getTotalAvg() {
        return this.totalValue / (double)this.totalCount;
    }

    public double getValueSum() {
        return this.totalValue;
    }

    public double getCountSum() {
        return this.totalCount;
    }

    public T getValueSum(Object key) {
        return (T)this.get(key);
    }

    public int getCountSum(Object key) {
        return this.count.get(key);
    }

    public double getValuePercent(Object key) {
        Number value = (Number)super.get(key);
        if (value instanceof Integer) {
            return (double)value.intValue() / this.totalValue;
        }
        if (value instanceof Double) {
            return value.doubleValue() / this.totalValue;
        }
        if (value instanceof Float) {
            return (double)value.floatValue() / this.totalValue;
        }
        if (value instanceof Long) {
            return (double)value.longValue() / this.totalValue;
        }
        if (value instanceof Short) {
            return (double)value.shortValue() / this.totalValue;
        }
        if (value instanceof Byte) {
            return (double)value.byteValue() / this.totalValue;
        }
        return (Double)this.get(key) / this.totalValue;
    }

    public double getCountPercent(Object key) {
        return (double)this.count.get(key).intValue() * 1.0 / (double)this.totalCount;
    }
}

