/*
 * Decompiled with CFR 0.152.
 */
package net.auoeke.reflect;

import java.lang.invoke.ConstantBootstraps;
import java.lang.reflect.Field;
import net.auoeke.reflect.CacheMap;
import net.auoeke.reflect.Fields;
import net.auoeke.reflect.Pointer;
import net.gudenau.lib.unsafe.Unsafe;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class Accessor {
    public static boolean getBoolean(Field field) {
        return Unsafe.getBoolean(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field));
    }

    public static void putBoolean(Field field, boolean value) {
        Unsafe.putBoolean(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field), (boolean)value);
    }

    public static byte getByte(Field field) {
        return Unsafe.getByte(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field));
    }

    public static void putByte(Field field, byte value) {
        Unsafe.putByte(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field), (byte)value);
    }

    public static char getChar(Field field) {
        return Unsafe.getChar(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field));
    }

    public static void putChar(Field field, char value) {
        Unsafe.putChar(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field), (char)value);
    }

    public static short getShort(Field field) {
        return Unsafe.getShort(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field));
    }

    public static void putShort(Field field, short value) {
        Unsafe.putShort(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field), (short)value);
    }

    public static int getInt(Field field) {
        return Unsafe.getInt(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field));
    }

    public static void putInt(Field field, int value) {
        Unsafe.putInt(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field), (int)value);
    }

    public static long getLong(Field field) {
        return Unsafe.getLong(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field));
    }

    public static void putLong(Field field, long value) {
        Unsafe.putLong(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field), (long)value);
    }

    public static float getFloat(Field field) {
        return Unsafe.getFloat(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field));
    }

    public static void putFloat(Field field, float value) {
        Unsafe.putFloat(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field), (float)value);
    }

    public static double getDouble(Field field) {
        return Unsafe.getDouble(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field));
    }

    public static void putDouble(Field field, double value) {
        Unsafe.putDouble(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field), (double)value);
    }

    public static Object getReference(Field field) {
        return Unsafe.getReference(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field));
    }

    public static void putReference(Field field, Object value) {
        Unsafe.putReference(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field), (Object)value);
    }

    public static long getAddress(Field field) {
        return Unsafe.getAddress(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field));
    }

    public static void putAddress(Field field, long value) {
        Unsafe.putAddress(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field), (long)value);
    }

    public static Object get(Field field) {
        return Accessor.get(field.getDeclaringClass(), field.getType(), Unsafe.staticFieldOffset((Field)field));
    }

    public static void put(Field field, Object value) {
        Accessor.put(field.getDeclaringClass(), field.getType(), Unsafe.staticFieldOffset((Field)field), value);
    }

    public static boolean getBooleanVolatile(Field field) {
        return Unsafe.getBooleanVolatile(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field));
    }

    public static void putBooleanVolatile(Field field, boolean value) {
        Unsafe.putBooleanVolatile(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field), (boolean)value);
    }

    public static byte getByteVolatile(Field field) {
        return Unsafe.getByteVolatile(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field));
    }

    public static void putByteVolatile(Field field, byte value) {
        Unsafe.putByteVolatile(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field), (byte)value);
    }

    public static char getCharVolatile(Field field) {
        return Unsafe.getCharVolatile(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field));
    }

    public static void putCharVolatile(Field field, char value) {
        Unsafe.putCharVolatile(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field), (char)value);
    }

    public static short getShortVolatile(Field field) {
        return Unsafe.getShortVolatile(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field));
    }

    public static void putShortVolatile(Field field, short value) {
        Unsafe.putShortVolatile(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field), (short)value);
    }

    public static int getIntVolatile(Field field) {
        return Unsafe.getIntVolatile(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field));
    }

    public static void putIntVolatile(Field field, int value) {
        Unsafe.putIntVolatile(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field), (int)value);
    }

    public static long getLongVolatile(Field field) {
        return Unsafe.getLongVolatile(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field));
    }

    public static void putLongVolatile(Field field, long value) {
        Unsafe.putLongVolatile(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field), (long)value);
    }

    public static float getFloatVolatile(Field field) {
        return Unsafe.getFloatVolatile(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field));
    }

    public static void putFloatVolatile(Field field, float value) {
        Unsafe.putFloatVolatile(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field), (float)value);
    }

    public static double getDoubleVolatile(Field field) {
        return Unsafe.getDoubleVolatile(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field));
    }

    public static void putDoubleVolatile(Field field, double value) {
        Unsafe.putDoubleVolatile(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field), (double)value);
    }

    public static Object getReferenceVolatile(Field field) {
        return Unsafe.getReferenceVolatile(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field));
    }

    public static void putReferenceVolatile(Field field, Object value) {
        Unsafe.putReferenceVolatile(field.getDeclaringClass(), (long)Unsafe.staticFieldOffset((Field)field), (Object)value);
    }

    public static Object getVolatile(Field field) {
        return Accessor.get(field.getDeclaringClass(), field.getType(), Unsafe.staticFieldOffset((Field)field));
    }

    public static void putVolatile(Field field, Object value) {
        Accessor.put(field.getDeclaringClass(), field.getType(), Unsafe.staticFieldOffset((Field)field), value);
    }

    public static <T> void copyBoolean(T to, T from, String fieldName) {
        long offset = Unsafe.objectFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putBoolean(to, (long)offset, (boolean)Unsafe.getBoolean(from, (long)offset));
    }

    public static <T> void copyBoolean(T to, T from, Field field) {
        long offset = Unsafe.objectFieldOffset((Field)field);
        Unsafe.putBoolean(to, (long)offset, (boolean)Unsafe.getBoolean(from, (long)offset));
    }

    public static <T> void copyBoolean(T to, T from, long offset) {
        Unsafe.putBoolean(to, (long)offset, (boolean)Unsafe.getBoolean(from, (long)offset));
    }

    public static void copyBoolean(Class<?> to, Class<?> from, String fieldName) {
        long offset = Unsafe.staticFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putBoolean(to, (long)offset, (boolean)Unsafe.getBoolean(from, (long)offset));
    }

    public static void copyBoolean(Class<?> to, Class<?> from, Field field) {
        long offset = Unsafe.staticFieldOffset((Field)field);
        Unsafe.putBoolean(to, (long)offset, (boolean)Unsafe.getBoolean(from, (long)offset));
    }

    public static void copyBoolean(Class<?> to, Class<?> from, long offset) {
        Unsafe.putBoolean(to, (long)offset, (boolean)Unsafe.getBoolean(from, (long)offset));
    }

    public static <T> void copyByte(T to, T from, String fieldName) {
        long offset = Unsafe.objectFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putByte(to, (long)offset, (byte)Unsafe.getByte(from, (long)offset));
    }

    public static <T> void copyByte(T to, T from, Field field) {
        long offset = Unsafe.objectFieldOffset((Field)field);
        Unsafe.putByte(to, (long)offset, (byte)Unsafe.getByte(from, (long)offset));
    }

    public static <T> void copyByte(T to, T from, long offset) {
        Unsafe.putByte(to, (long)offset, (byte)Unsafe.getByte(from, (long)offset));
    }

    public static void copyByte(Class<?> to, Class<?> from, String fieldName) {
        long offset = Unsafe.staticFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putByte(to, (long)offset, (byte)Unsafe.getByte(from, (long)offset));
    }

    public static void copyByte(Class<?> to, Class<?> from, Field field) {
        long offset = Unsafe.staticFieldOffset((Field)field);
        Unsafe.putByte(to, (long)offset, (byte)Unsafe.getByte(from, (long)offset));
    }

    public static void copyByte(Class<?> to, Class<?> from, long offset) {
        Unsafe.putByte(to, (long)offset, (byte)Unsafe.getByte(from, (long)offset));
    }

    public static <T> void copyChar(T to, T from, String fieldName) {
        long offset = Unsafe.objectFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putChar(to, (long)offset, (char)Unsafe.getChar(from, (long)offset));
    }

    public static <T> void copyChar(T to, T from, Field field) {
        long offset = Unsafe.objectFieldOffset((Field)field);
        Unsafe.putChar(to, (long)offset, (char)Unsafe.getChar(from, (long)offset));
    }

    public static <T> void copyChar(T to, T from, long offset) {
        Unsafe.putChar(to, (long)offset, (char)Unsafe.getChar(from, (long)offset));
    }

    public static void copyChar(Class<?> to, Class<?> from, String fieldName) {
        long offset = Unsafe.staticFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putChar(to, (long)offset, (char)Unsafe.getChar(from, (long)offset));
    }

    public static void copyChar(Class<?> to, Class<?> from, Field field) {
        long offset = Unsafe.staticFieldOffset((Field)field);
        Unsafe.putChar(to, (long)offset, (char)Unsafe.getChar(from, (long)offset));
    }

    public static void copyChar(Class<?> to, Class<?> from, long offset) {
        Unsafe.putChar(to, (long)offset, (char)Unsafe.getChar(from, (long)offset));
    }

    public static <T> void copyShort(T to, T from, String fieldName) {
        long offset = Unsafe.objectFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putShort(to, (long)offset, (short)Unsafe.getShort(from, (long)offset));
    }

    public static <T> void copyShort(T to, T from, Field field) {
        long offset = Unsafe.objectFieldOffset((Field)field);
        Unsafe.putShort(to, (long)offset, (short)Unsafe.getShort(from, (long)offset));
    }

    public static <T> void copyShort(T to, T from, long offset) {
        Unsafe.putShort(to, (long)offset, (short)Unsafe.getShort(from, (long)offset));
    }

    public static void copyShort(Class<?> to, Class<?> from, String fieldName) {
        long offset = Unsafe.staticFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putShort(to, (long)offset, (short)Unsafe.getShort(from, (long)offset));
    }

    public static void copyShort(Class<?> to, Class<?> from, Field field) {
        long offset = Unsafe.staticFieldOffset((Field)field);
        Unsafe.putShort(to, (long)offset, (short)Unsafe.getShort(from, (long)offset));
    }

    public static void copyShort(Class<?> to, Class<?> from, long offset) {
        Unsafe.putShort(to, (long)offset, (short)Unsafe.getShort(from, (long)offset));
    }

    public static <T> void copyInt(T to, T from, String fieldName) {
        long offset = Unsafe.objectFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putInt(to, (long)offset, (int)Unsafe.getInt(from, (long)offset));
    }

    public static <T> void copyInt(T to, T from, Field field) {
        long offset = Unsafe.objectFieldOffset((Field)field);
        Unsafe.putInt(to, (long)offset, (int)Unsafe.getInt(from, (long)offset));
    }

    public static <T> void copyInt(T to, T from, long offset) {
        Unsafe.putInt(to, (long)offset, (int)Unsafe.getInt(from, (long)offset));
    }

    public static void copyInt(Class<?> to, Class<?> from, String fieldName) {
        long offset = Unsafe.staticFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putInt(to, (long)offset, (int)Unsafe.getInt(from, (long)offset));
    }

    public static void copyInt(Class<?> to, Class<?> from, Field field) {
        long offset = Unsafe.staticFieldOffset((Field)field);
        Unsafe.putInt(to, (long)offset, (int)Unsafe.getInt(from, (long)offset));
    }

    public static void copyInt(Class<?> to, Class<?> from, long offset) {
        Unsafe.putInt(to, (long)offset, (int)Unsafe.getInt(from, (long)offset));
    }

    public static <T> void copyLong(T to, T from, String fieldName) {
        long offset = Unsafe.objectFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putLong(to, (long)offset, (long)Unsafe.getLong(from, (long)offset));
    }

    public static <T> void copyLong(T to, T from, Field field) {
        long offset = Unsafe.objectFieldOffset((Field)field);
        Unsafe.putLong(to, (long)offset, (long)Unsafe.getLong(from, (long)offset));
    }

    public static <T> void copyLong(T to, T from, long offset) {
        Unsafe.putLong(to, (long)offset, (long)Unsafe.getLong(from, (long)offset));
    }

    public static void copyLong(Class<?> to, Class<?> from, String fieldName) {
        long offset = Unsafe.staticFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putLong(to, (long)offset, (long)Unsafe.getLong(from, (long)offset));
    }

    public static void copyLong(Class<?> to, Class<?> from, Field field) {
        long offset = Unsafe.staticFieldOffset((Field)field);
        Unsafe.putLong(to, (long)offset, (long)Unsafe.getLong(from, (long)offset));
    }

    public static void copyLong(Class<?> to, Class<?> from, long offset) {
        Unsafe.putLong(to, (long)offset, (long)Unsafe.getLong(from, (long)offset));
    }

    public static <T> void copyFloat(T to, T from, String fieldName) {
        long offset = Unsafe.objectFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putFloat(to, (long)offset, (float)Unsafe.getFloat(from, (long)offset));
    }

    public static <T> void copyFloat(T to, T from, Field field) {
        long offset = Unsafe.objectFieldOffset((Field)field);
        Unsafe.putFloat(to, (long)offset, (float)Unsafe.getFloat(from, (long)offset));
    }

    public static <T> void copyFloat(T to, T from, long offset) {
        Unsafe.putFloat(to, (long)offset, (float)Unsafe.getFloat(from, (long)offset));
    }

    public static void copyFloat(Class<?> to, Class<?> from, String fieldName) {
        long offset = Unsafe.staticFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putFloat(to, (long)offset, (float)Unsafe.getFloat(from, (long)offset));
    }

    public static void copyFloat(Class<?> to, Class<?> from, Field field) {
        long offset = Unsafe.staticFieldOffset((Field)field);
        Unsafe.putFloat(to, (long)offset, (float)Unsafe.getFloat(from, (long)offset));
    }

    public static void copyFloat(Class<?> to, Class<?> from, long offset) {
        Unsafe.putFloat(to, (long)offset, (float)Unsafe.getFloat(from, (long)offset));
    }

    public static <T> void copyDouble(T to, T from, String fieldName) {
        long offset = Unsafe.objectFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putDouble(to, (long)offset, (double)Unsafe.getDouble(from, (long)offset));
    }

    public static <T> void copyDouble(T to, T from, Field field) {
        long offset = Unsafe.objectFieldOffset((Field)field);
        Unsafe.putDouble(to, (long)offset, (double)Unsafe.getDouble(from, (long)offset));
    }

    public static <T> void copyDouble(T to, T from, long offset) {
        Unsafe.putDouble(to, (long)offset, (double)Unsafe.getDouble(from, (long)offset));
    }

    public static void copyDouble(Class<?> to, Class<?> from, String fieldName) {
        long offset = Unsafe.staticFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putDouble(to, (long)offset, (double)Unsafe.getDouble(from, (long)offset));
    }

    public static void copyDouble(Class<?> to, Class<?> from, Field field) {
        long offset = Unsafe.staticFieldOffset((Field)field);
        Unsafe.putDouble(to, (long)offset, (double)Unsafe.getDouble(from, (long)offset));
    }

    public static void copyDouble(Class<?> to, Class<?> from, long offset) {
        Unsafe.putDouble(to, (long)offset, (double)Unsafe.getDouble(from, (long)offset));
    }

    public static <T> void copyObject(T to, T from, String fieldName) {
        long offset = Unsafe.objectFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putReference(to, (long)offset, (Object)Unsafe.getReference(from, (long)offset));
    }

    public static <T> void copyObject(T to, T from, Field field) {
        long offset = Unsafe.objectFieldOffset((Field)field);
        Unsafe.putReference(to, (long)offset, (Object)Unsafe.getReference(from, (long)offset));
    }

    public static <T> void copyObject(T to, T from, long offset) {
        Unsafe.putReference(to, (long)offset, (Object)Unsafe.getReference(from, (long)offset));
    }

    public static void copyObject(Class<?> to, Class<?> from, String fieldName) {
        long offset = Unsafe.staticFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putReference(to, (long)offset, (Object)Unsafe.getReference(from, (long)offset));
    }

    public static void copyObject(Class<?> to, Class<?> from, Field field) {
        long offset = Unsafe.staticFieldOffset((Field)field);
        Unsafe.putReference(to, (long)offset, (Object)Unsafe.getReference(from, (long)offset));
    }

    public static void copyObject(Class<?> to, Class<?> from, long offset) {
        Unsafe.putReference(to, (long)offset, (Object)Unsafe.getReference(from, (long)offset));
    }

    public static void copyAddress(Object to, Object from, String fieldName) {
        long offset = Unsafe.objectFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putAddress((Object)to, (long)offset, (long)Unsafe.getAddress((Object)from, (long)offset));
    }

    public static void copyAddress(Object to, Object from, Field field) {
        long offset = Unsafe.objectFieldOffset((Field)field);
        Unsafe.putAddress((Object)to, (long)offset, (long)Unsafe.getAddress((Object)from, (long)offset));
    }

    public static void copyAddress(Object to, Object from, long offset) {
        Unsafe.putAddress((Object)to, (long)offset, (long)Unsafe.getAddress((Object)from, (long)offset));
    }

    public static void copyAddress(Class<?> to, Class<?> from, String fieldName) {
        long offset = Unsafe.staticFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putAddress(to, (long)offset, (long)Unsafe.getAddress(from, (long)offset));
    }

    public static void copyAddress(Class<?> to, Class<?> from, Field field) {
        long offset = Unsafe.staticFieldOffset((Field)field);
        Unsafe.putAddress(to, (long)offset, (long)Unsafe.getAddress(from, (long)offset));
    }

    public static void copyAddress(Class<?> to, Class<?> from, long offset) {
        Unsafe.putAddress(to, (long)offset, (long)Unsafe.getAddress(from, (long)offset));
    }

    public static <T> void copy(T to, T from, String fieldName) {
        Field field = Fields.of(to, fieldName);
        long offset = Unsafe.objectFieldOffset((Field)field);
        Accessor.put(to, field.getType(), offset, Accessor.get(from, field.getType(), offset));
    }

    public static <T> void copy(T to, T from, Field field) {
        long offset = Unsafe.objectFieldOffset((Field)field);
        Accessor.put(to, field.getType(), offset, Accessor.get(from, field.getType(), offset));
    }

    public static void copy(Class<?> to, Class<?> from, String fieldName) {
        Field field = Fields.of(to, fieldName);
        long offset = Unsafe.staticFieldOffset((Field)field);
        Accessor.put(to, field.getType(), offset, Accessor.get(from, field.getType(), offset));
    }

    public static void copy(Class<?> to, Class<?> from, Field field) {
        long offset = Unsafe.staticFieldOffset((Field)field);
        Accessor.put(to, field.getType(), offset, Accessor.get(from, field.getType(), offset));
    }

    public static <T> void copyBooleanVolatile(T to, T from, String fieldName) {
        long offset = Unsafe.objectFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putBooleanVolatile(to, (long)offset, (boolean)Unsafe.getBooleanVolatile(from, (long)offset));
    }

    public static <T> void copyBooleanVolatile(T to, T from, Field field) {
        long offset = Unsafe.objectFieldOffset((Field)field);
        Unsafe.putBooleanVolatile(to, (long)offset, (boolean)Unsafe.getBooleanVolatile(from, (long)offset));
    }

    public static <T> void copyBooleanVolatile(T to, T from, long offset) {
        Unsafe.putBooleanVolatile(to, (long)offset, (boolean)Unsafe.getBooleanVolatile(from, (long)offset));
    }

    public static void copyBooleanVolatile(Class<?> to, Class<?> from, String fieldName) {
        long offset = Unsafe.staticFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putBooleanVolatile(to, (long)offset, (boolean)Unsafe.getBooleanVolatile(from, (long)offset));
    }

    public static void copyBooleanVolatile(Class<?> to, Class<?> from, Field field) {
        long offset = Unsafe.staticFieldOffset((Field)field);
        Unsafe.putBooleanVolatile(to, (long)offset, (boolean)Unsafe.getBooleanVolatile(from, (long)offset));
    }

    public static void copyBooleanVolatile(Class<?> to, Class<?> from, long offset) {
        Unsafe.putBooleanVolatile(to, (long)offset, (boolean)Unsafe.getBooleanVolatile(from, (long)offset));
    }

    public static <T> void copyByteVolatile(T to, T from, String fieldName) {
        long offset = Unsafe.objectFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putByteVolatile(to, (long)offset, (byte)Unsafe.getByteVolatile(from, (long)offset));
    }

    public static <T> void copyByteVolatile(T to, T from, Field field) {
        long offset = Unsafe.objectFieldOffset((Field)field);
        Unsafe.putByteVolatile(to, (long)offset, (byte)Unsafe.getByteVolatile(from, (long)offset));
    }

    public static <T> void copyByteVolatile(T to, T from, long offset) {
        Unsafe.putByteVolatile(to, (long)offset, (byte)Unsafe.getByteVolatile(from, (long)offset));
    }

    public static void copyByteVolatile(Class<?> to, Class<?> from, String fieldName) {
        long offset = Unsafe.staticFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putByteVolatile(to, (long)offset, (byte)Unsafe.getByteVolatile(from, (long)offset));
    }

    public static void copyByteVolatile(Class<?> to, Class<?> from, Field field) {
        long offset = Unsafe.staticFieldOffset((Field)field);
        Unsafe.putByteVolatile(to, (long)offset, (byte)Unsafe.getByteVolatile(from, (long)offset));
    }

    public static void copyByteVolatile(Class<?> to, Class<?> from, long offset) {
        Unsafe.putByteVolatile(to, (long)offset, (byte)Unsafe.getByteVolatile(from, (long)offset));
    }

    public static <T> void copyCharVolatile(T to, T from, String fieldName) {
        long offset = Unsafe.objectFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putCharVolatile(to, (long)offset, (char)Unsafe.getCharVolatile(from, (long)offset));
    }

    public static <T> void copyCharVolatile(T to, T from, Field field) {
        long offset = Unsafe.objectFieldOffset((Field)field);
        Unsafe.putCharVolatile(to, (long)offset, (char)Unsafe.getCharVolatile(from, (long)offset));
    }

    public static <T> void copyCharVolatile(T to, T from, long offset) {
        Unsafe.putCharVolatile(to, (long)offset, (char)Unsafe.getCharVolatile(from, (long)offset));
    }

    public static void copyCharVolatile(Class<?> to, Class<?> from, String fieldName) {
        long offset = Unsafe.staticFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putCharVolatile(to, (long)offset, (char)Unsafe.getCharVolatile(from, (long)offset));
    }

    public static void copyCharVolatile(Class<?> to, Class<?> from, Field field) {
        long offset = Unsafe.staticFieldOffset((Field)field);
        Unsafe.putCharVolatile(to, (long)offset, (char)Unsafe.getCharVolatile(from, (long)offset));
    }

    public static void copyCharVolatile(Class<?> to, Class<?> from, long offset) {
        Unsafe.putCharVolatile(to, (long)offset, (char)Unsafe.getCharVolatile(from, (long)offset));
    }

    public static <T> void copyShortVolatile(T to, T from, String fieldName) {
        long offset = Unsafe.objectFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putShortVolatile(to, (long)offset, (short)Unsafe.getShortVolatile(from, (long)offset));
    }

    public static <T> void copyShortVolatile(T to, T from, Field field) {
        long offset = Unsafe.objectFieldOffset((Field)field);
        Unsafe.putShortVolatile(to, (long)offset, (short)Unsafe.getShortVolatile(from, (long)offset));
    }

    public static <T> void copyShortVolatile(T to, T from, long offset) {
        Unsafe.putShortVolatile(to, (long)offset, (short)Unsafe.getShortVolatile(from, (long)offset));
    }

    public static void copyShortVolatile(Class<?> to, Class<?> from, String fieldName) {
        long offset = Unsafe.staticFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putShortVolatile(to, (long)offset, (short)Unsafe.getShortVolatile(from, (long)offset));
    }

    public static void copyShortVolatile(Class<?> to, Class<?> from, Field field) {
        long offset = Unsafe.staticFieldOffset((Field)field);
        Unsafe.putShortVolatile(to, (long)offset, (short)Unsafe.getShortVolatile(from, (long)offset));
    }

    public static void copyShortVolatile(Class<?> to, Class<?> from, long offset) {
        Unsafe.putShortVolatile(to, (long)offset, (short)Unsafe.getShortVolatile(from, (long)offset));
    }

    public static <T> void copyIntVolatile(T to, T from, String fieldName) {
        long offset = Unsafe.objectFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putIntVolatile(to, (long)offset, (int)Unsafe.getIntVolatile(from, (long)offset));
    }

    public static <T> void copyIntVolatile(T to, T from, Field field) {
        long offset = Unsafe.objectFieldOffset((Field)field);
        Unsafe.putIntVolatile(to, (long)offset, (int)Unsafe.getIntVolatile(from, (long)offset));
    }

    public static <T> void copyIntVolatile(T to, T from, long offset) {
        Unsafe.putIntVolatile(to, (long)offset, (int)Unsafe.getIntVolatile(from, (long)offset));
    }

    public static void copyIntVolatile(Class<?> to, Class<?> from, String fieldName) {
        long offset = Unsafe.staticFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putIntVolatile(to, (long)offset, (int)Unsafe.getIntVolatile(from, (long)offset));
    }

    public static void copyIntVolatile(Class<?> to, Class<?> from, Field field) {
        long offset = Unsafe.staticFieldOffset((Field)field);
        Unsafe.putIntVolatile(to, (long)offset, (int)Unsafe.getIntVolatile(from, (long)offset));
    }

    public static void copyIntVolatile(Class<?> to, Class<?> from, long offset) {
        Unsafe.putIntVolatile(to, (long)offset, (int)Unsafe.getIntVolatile(from, (long)offset));
    }

    public static <T> void copyLongVolatile(T to, T from, String fieldName) {
        long offset = Unsafe.objectFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putLongVolatile(to, (long)offset, (long)Unsafe.getLongVolatile(from, (long)offset));
    }

    public static <T> void copyLongVolatile(T to, T from, Field field) {
        long offset = Unsafe.objectFieldOffset((Field)field);
        Unsafe.putLongVolatile(to, (long)offset, (long)Unsafe.getLongVolatile(from, (long)offset));
    }

    public static <T> void copyLongVolatile(T to, T from, long offset) {
        Unsafe.putLongVolatile(to, (long)offset, (long)Unsafe.getLongVolatile(from, (long)offset));
    }

    public static void copyLongVolatile(Class<?> to, Class<?> from, String fieldName) {
        long offset = Unsafe.staticFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putLongVolatile(to, (long)offset, (long)Unsafe.getLongVolatile(from, (long)offset));
    }

    public static void copyLongVolatile(Class<?> to, Class<?> from, Field field) {
        long offset = Unsafe.staticFieldOffset((Field)field);
        Unsafe.putLongVolatile(to, (long)offset, (long)Unsafe.getLongVolatile(from, (long)offset));
    }

    public static void copyLongVolatile(Class<?> to, Class<?> from, long offset) {
        Unsafe.putLongVolatile(to, (long)offset, (long)Unsafe.getLongVolatile(from, (long)offset));
    }

    public static <T> void copyFloatVolatile(T to, T from, String fieldName) {
        long offset = Unsafe.objectFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putFloatVolatile(to, (long)offset, (float)Unsafe.getFloatVolatile(from, (long)offset));
    }

    public static <T> void copyFloatVolatile(T to, T from, Field field) {
        long offset = Unsafe.objectFieldOffset((Field)field);
        Unsafe.putFloatVolatile(to, (long)offset, (float)Unsafe.getFloatVolatile(from, (long)offset));
    }

    public static <T> void copyFloatVolatile(T to, T from, long offset) {
        Unsafe.putFloatVolatile(to, (long)offset, (float)Unsafe.getFloatVolatile(from, (long)offset));
    }

    public static void copyFloatVolatile(Class<?> to, Class<?> from, String fieldName) {
        long offset = Unsafe.staticFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putFloatVolatile(to, (long)offset, (float)Unsafe.getFloatVolatile(from, (long)offset));
    }

    public static void copyFloatVolatile(Class<?> to, Class<?> from, Field field) {
        long offset = Unsafe.staticFieldOffset((Field)field);
        Unsafe.putFloatVolatile(to, (long)offset, (float)Unsafe.getFloatVolatile(from, (long)offset));
    }

    public static void copyFloatVolatile(Class<?> to, Class<?> from, long offset) {
        Unsafe.putFloatVolatile(to, (long)offset, (float)Unsafe.getFloatVolatile(from, (long)offset));
    }

    public static <T> void copyDoubleVolatile(T to, T from, String fieldName) {
        long offset = Unsafe.objectFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putDoubleVolatile(to, (long)offset, (double)Unsafe.getDoubleVolatile(from, (long)offset));
    }

    public static <T> void copyDoubleVolatile(T to, T from, Field field) {
        long offset = Unsafe.objectFieldOffset((Field)field);
        Unsafe.putDoubleVolatile(to, (long)offset, (double)Unsafe.getDoubleVolatile(from, (long)offset));
    }

    public static <T> void copyDoubleVolatile(T to, T from, long offset) {
        Unsafe.putDoubleVolatile(to, (long)offset, (double)Unsafe.getDoubleVolatile(from, (long)offset));
    }

    public static void copyDoubleVolatile(Class<?> to, Class<?> from, String fieldName) {
        long offset = Unsafe.staticFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putDoubleVolatile(to, (long)offset, (double)Unsafe.getDoubleVolatile(from, (long)offset));
    }

    public static void copyDoubleVolatile(Class<?> to, Class<?> from, Field field) {
        long offset = Unsafe.staticFieldOffset((Field)field);
        Unsafe.putDoubleVolatile(to, (long)offset, (double)Unsafe.getDoubleVolatile(from, (long)offset));
    }

    public static void copyDoubleVolatile(Class<?> to, Class<?> from, long offset) {
        Unsafe.putDoubleVolatile(to, (long)offset, (double)Unsafe.getDoubleVolatile(from, (long)offset));
    }

    public static <T> void copyObjectVolatile(T to, T from, String fieldName) {
        long offset = Unsafe.objectFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putReferenceVolatile(to, (long)offset, (Object)Unsafe.getReferenceVolatile(from, (long)offset));
    }

    public static <T> void copyObjectVolatile(T to, T from, Field field) {
        long offset = Unsafe.objectFieldOffset((Field)field);
        Unsafe.putReferenceVolatile(to, (long)offset, (Object)Unsafe.getReferenceVolatile(from, (long)offset));
    }

    public static <T> void copyObjectVolatile(T to, T from, long offset) {
        Unsafe.putReferenceVolatile(to, (long)offset, (Object)Unsafe.getReferenceVolatile(from, (long)offset));
    }

    public static void copyObjectVolatile(Class<?> to, Class<?> from, String fieldName) {
        long offset = Unsafe.staticFieldOffset((Field)Fields.of(to, fieldName));
        Unsafe.putReferenceVolatile(to, (long)offset, (Object)Unsafe.getReferenceVolatile(from, (long)offset));
    }

    public static void copyObjectVolatile(Class<?> to, Class<?> from, Field field) {
        long offset = Unsafe.staticFieldOffset((Field)field);
        Unsafe.putReferenceVolatile(to, (long)offset, (Object)Unsafe.getReferenceVolatile(from, (long)offset));
    }

    public static void copyObjectVolatile(Class<?> to, Class<?> from, long offset) {
        Unsafe.putReferenceVolatile(to, (long)offset, (Object)Unsafe.getReferenceVolatile(from, (long)offset));
    }

    public static <T> void copyVolatile(T to, T from, String fieldName) {
        Field field = Fields.of(to, fieldName);
        long offset = Unsafe.objectFieldOffset((Field)field);
        Accessor.putVolatile(to, field.getType(), offset, Accessor.getVolatile(from, field.getType(), offset));
    }

    public static <T> void copyVolatile(T to, T from, Field field) {
        long offset = Unsafe.objectFieldOffset((Field)field);
        Accessor.putVolatile(to, field.getType(), offset, Accessor.getVolatile(from, field.getType(), offset));
    }

    public static void copyVolatile(Class<?> to, Class<?> from, String fieldName) {
        Field field = Fields.of(to, fieldName);
        long offset = Unsafe.staticFieldOffset((Field)field);
        Accessor.putVolatile(to, field.getType(), offset, Accessor.getVolatile(from, field.getType(), offset));
    }

    public static void copyVolatile(Class<?> to, Class<?> from, Field field) {
        long offset = Unsafe.staticFieldOffset((Field)field);
        Accessor.putVolatile(to, field.getType(), offset, Accessor.getVolatile(from, field.getType(), offset));
    }

    public static boolean getBoolean(Object object, Field fieldName) {
        return Unsafe.getBoolean((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putBoolean(Object object, Field fieldName, boolean value) {
        Unsafe.putBoolean((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (boolean)value);
    }

    public static boolean getBoolean(Object object, String fieldName) {
        return Unsafe.getBoolean((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)));
    }

    public static void putBoolean(Object object, String fieldName, boolean value) {
        Unsafe.putBoolean((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)), (boolean)value);
    }

    public static boolean getBoolean(Class<?> type, String fieldName) {
        return Unsafe.getBoolean(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putBoolean(Class<?> type, String fieldName, boolean value) {
        Unsafe.putBoolean(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)), (boolean)value);
    }

    public static byte getByte(Object object, Field fieldName) {
        return Unsafe.getByte((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putByte(Object object, Field fieldName, byte value) {
        Unsafe.putByte((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (byte)value);
    }

    public static byte getByte(Object object, String fieldName) {
        return Unsafe.getByte((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)));
    }

    public static void putByte(Object object, String fieldName, byte value) {
        Unsafe.putByte((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)), (byte)value);
    }

    public static byte getByte(Class<?> type, String fieldName) {
        return Unsafe.getByte(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putByte(Class<?> type, String fieldName, byte value) {
        Unsafe.putByte(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)), (byte)value);
    }

    public static char getChar(Object object, Field fieldName) {
        return Unsafe.getChar((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putChar(Object object, Field fieldName, char value) {
        Unsafe.putChar((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (char)value);
    }

    public static char getChar(Object object, String fieldName) {
        return Unsafe.getChar((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)));
    }

    public static void putChar(Object object, String fieldName, char value) {
        Unsafe.putChar((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)), (char)value);
    }

    public static char getChar(Class<?> type, String fieldName) {
        return Unsafe.getChar(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putChar(Class<?> type, String fieldName, char value) {
        Unsafe.putChar(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)), (char)value);
    }

    public static short getShort(Object object, Field fieldName) {
        return Unsafe.getShort((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putShort(Object object, Field fieldName, short value) {
        Unsafe.putShort((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (short)value);
    }

    public static short getShort(Object object, String fieldName) {
        return Unsafe.getShort((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)));
    }

    public static void putShort(Object object, String fieldName, short value) {
        Unsafe.putShort((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)), (short)value);
    }

    public static short getShort(Class<?> type, String fieldName) {
        return Unsafe.getShort(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putShort(Class<?> type, String fieldName, short value) {
        Unsafe.putShort(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)), (short)value);
    }

    public static int getInt(Object object, Field fieldName) {
        return Unsafe.getInt((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putInt(Object object, Field fieldName, int value) {
        Unsafe.putInt((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (int)value);
    }

    public static int getInt(Object object, String fieldName) {
        return Unsafe.getInt((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)));
    }

    public static void putInt(Object object, String fieldName, int value) {
        Unsafe.putInt((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)), (int)value);
    }

    public static int getInt(Class<?> type, String fieldName) {
        return Unsafe.getInt(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putInt(Class<?> type, String fieldName, int value) {
        Unsafe.putInt(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)), (int)value);
    }

    public static long getLong(Object object, Field fieldName) {
        return Unsafe.getLong((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putLong(Object object, Field fieldName, long value) {
        Unsafe.putLong((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (long)value);
    }

    public static long getLong(Object object, String fieldName) {
        return Unsafe.getLong((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)));
    }

    public static void putLong(Object object, String fieldName, long value) {
        Unsafe.putLong((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)), (long)value);
    }

    public static long getLong(Class<?> type, String fieldName) {
        return Unsafe.getLong(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putLong(Class<?> type, String fieldName, long value) {
        Unsafe.putLong(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)), (long)value);
    }

    public static float getFloat(Object object, Field fieldName) {
        return Unsafe.getFloat((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putFloat(Object object, Field fieldName, float value) {
        Unsafe.putFloat((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (float)value);
    }

    public static float getFloat(Object object, String fieldName) {
        return Unsafe.getFloat((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)));
    }

    public static void putFloat(Object object, String fieldName, float value) {
        Unsafe.putFloat((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)), (float)value);
    }

    public static float getFloat(Class<?> type, String fieldName) {
        return Unsafe.getFloat(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putFloat(Class<?> type, String fieldName, float value) {
        Unsafe.putFloat(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)), (float)value);
    }

    public static double getDouble(Object object, Field fieldName) {
        return Unsafe.getDouble((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putDouble(Object object, Field fieldName, double value) {
        Unsafe.putDouble((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (double)value);
    }

    public static double getDouble(Object object, String fieldName) {
        return Unsafe.getDouble((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)));
    }

    public static void putDouble(Object object, String fieldName, double value) {
        Unsafe.putDouble((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)), (double)value);
    }

    public static double getDouble(Class<?> type, String fieldName) {
        return Unsafe.getDouble(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putDouble(Class<?> type, String fieldName, double value) {
        Unsafe.putDouble(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)), (double)value);
    }

    public static <T> T getReference(Object object, Field fieldName) {
        return (T)Unsafe.getReference((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putReference(Object object, Field fieldName, Object value) {
        Unsafe.putReference((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (Object)value);
    }

    public static <T> T getReference(Object object, String fieldName) {
        return (T)Unsafe.getReference((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)));
    }

    public static void putReference(Object object, String fieldName, Object value) {
        Unsafe.putReference((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)), (Object)value);
    }

    public static <T> T getReference(Class<?> type, String fieldName) {
        return (T)Unsafe.getReference(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putReference(Class<?> type, String fieldName, Object value) {
        Unsafe.putReference(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)), (Object)value);
    }

    public static long getAddress(Object object, Field fieldName) {
        return Unsafe.getAddress((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putAddress(Object object, Field fieldName, long value) {
        Unsafe.putAddress((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (long)value);
    }

    public static long getAddress(Object object, String fieldName) {
        return Unsafe.getAddress((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)));
    }

    public static void putAddress(Object object, String fieldName, long value) {
        Unsafe.putAddress((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)), (long)value);
    }

    public static long getAddress(Class<?> type, String fieldName) {
        return Unsafe.getAddress(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putAddress(Class<?> type, String fieldName, long value) {
        Unsafe.putAddress(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)), (long)value);
    }

    public static Object get(Object object, Field fieldName) {
        return Accessor.get(object, fieldName.getType(), Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void put(Object object, Field fieldName, Object value) {
        Accessor.put(object, fieldName.getType(), Unsafe.objectFieldOffset((Field)fieldName), value);
    }

    public static Object get(Object object, String fieldName) {
        Field field = Fields.of(object, fieldName);
        return Accessor.get(object, field.getType(), Unsafe.objectFieldOffset((Field)field));
    }

    public static void put(Object object, String fieldName, Object value) {
        Field field = Fields.of(object, fieldName);
        Accessor.put(object, field.getType(), Unsafe.objectFieldOffset((Field)field), value);
    }

    public static Object get(Class<?> type, String fieldName) {
        Field field = Fields.of(type, fieldName);
        return Accessor.get(type, field.getType(), Unsafe.staticFieldOffset((Field)field));
    }

    public static void put(Class<?> type, String fieldName, Object value) {
        Field field = Fields.of(type, fieldName);
        Accessor.put(type, field.getType(), Unsafe.staticFieldOffset((Field)field), value);
    }

    public static boolean getBooleanVolatile(Object object, Field fieldName) {
        return Unsafe.getBooleanVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putBooleanVolatile(Object object, Field fieldName, boolean value) {
        Unsafe.putBooleanVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (boolean)value);
    }

    public static boolean getBooleanVolatile(Object object, String fieldName) {
        return Unsafe.getBooleanVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)));
    }

    public static void putBooleanVolatile(Object object, String fieldName, boolean value) {
        Unsafe.putBooleanVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)), (boolean)value);
    }

    public static boolean getBooleanVolatile(Class<?> type, String fieldName) {
        return Unsafe.getBooleanVolatile(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putBooleanVolatile(Class<?> type, String fieldName, boolean value) {
        Unsafe.putBooleanVolatile(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)), (boolean)value);
    }

    public static byte getByteVolatile(Object object, Field fieldName) {
        return Unsafe.getByteVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putByteVolatile(Object object, Field fieldName, byte value) {
        Unsafe.putByteVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (byte)value);
    }

    public static byte getByteVolatile(Object object, String fieldName) {
        return Unsafe.getByteVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)));
    }

    public static void putByteVolatile(Object object, String fieldName, byte value) {
        Unsafe.putByteVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)), (byte)value);
    }

    public static byte getByteVolatile(Class<?> type, String fieldName) {
        return Unsafe.getByteVolatile(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putByteVolatile(Class<?> type, String fieldName, byte value) {
        Unsafe.putByteVolatile(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)), (byte)value);
    }

    public static char getCharVolatile(Object object, Field fieldName) {
        return Unsafe.getCharVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putCharVolatile(Object object, Field fieldName, char value) {
        Unsafe.putCharVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (char)value);
    }

    public static char getCharVolatile(Object object, String fieldName) {
        return Unsafe.getCharVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)));
    }

    public static void putCharVolatile(Object object, String fieldName, char value) {
        Unsafe.putCharVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)), (char)value);
    }

    public static char getCharVolatile(Class<?> type, String fieldName) {
        return Unsafe.getCharVolatile(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putCharVolatile(Class<?> type, String fieldName, char value) {
        Unsafe.putCharVolatile(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)), (char)value);
    }

    public static short getShortVolatile(Object object, Field fieldName) {
        return Unsafe.getShortVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putShortVolatile(Object object, Field fieldName, short value) {
        Unsafe.putShortVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (short)value);
    }

    public static short getShortVolatile(Object object, String fieldName) {
        return Unsafe.getShortVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)));
    }

    public static void putShortVolatile(Object object, String fieldName, short value) {
        Unsafe.putShortVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)), (short)value);
    }

    public static short getShortVolatile(Class<?> type, String fieldName) {
        return Unsafe.getShortVolatile(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putShortVolatile(Class<?> type, String fieldName, short value) {
        Unsafe.putShortVolatile(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)), (short)value);
    }

    public static int getIntVolatile(Object object, Field fieldName) {
        return Unsafe.getIntVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putIntVolatile(Object object, Field fieldName, int value) {
        Unsafe.putIntVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (int)value);
    }

    public static int getIntVolatile(Object object, String fieldName) {
        return Unsafe.getIntVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)));
    }

    public static void putIntVolatile(Object object, String fieldName, int value) {
        Unsafe.putIntVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)), (int)value);
    }

    public static int getIntVolatile(Class<?> type, String fieldName) {
        return Unsafe.getIntVolatile(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putIntVolatile(Class<?> type, String fieldName, int value) {
        Unsafe.putIntVolatile(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)), (int)value);
    }

    public static long getLongVolatile(Object object, Field fieldName) {
        return Unsafe.getLongVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putLongVolatile(Object object, Field fieldName, long value) {
        Unsafe.putLongVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (long)value);
    }

    public static long getLongVolatile(Object object, String fieldName) {
        return Unsafe.getLongVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)));
    }

    public static void putLongVolatile(Object object, String fieldName, long value) {
        Unsafe.putLongVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)), (long)value);
    }

    public static long getLongVolatile(Class<?> type, String fieldName) {
        return Unsafe.getLongVolatile(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putLongVolatile(Class<?> type, String fieldName, long value) {
        Unsafe.putLongVolatile(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)), (long)value);
    }

    public static float getFloatVolatile(Object object, Field fieldName) {
        return Unsafe.getFloatVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putFloatVolatile(Object object, Field fieldName, float value) {
        Unsafe.putFloatVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (float)value);
    }

    public static float getFloatVolatile(Object object, String fieldName) {
        return Unsafe.getFloatVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)));
    }

    public static void putFloatVolatile(Object object, String fieldName, float value) {
        Unsafe.putFloatVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)), (float)value);
    }

    public static float getFloatVolatile(Class<?> type, String fieldName) {
        return Unsafe.getFloatVolatile(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putFloatVolatile(Class<?> type, String fieldName, float value) {
        Unsafe.putFloatVolatile(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)), (float)value);
    }

    public static double getDoubleVolatile(Object object, Field fieldName) {
        return Unsafe.getDoubleVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putDoubleVolatile(Object object, Field fieldName, double value) {
        Unsafe.putDoubleVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (double)value);
    }

    public static double getDoubleVolatile(Object object, String fieldName) {
        return Unsafe.getDoubleVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)));
    }

    public static void putDoubleVolatile(Object object, String fieldName, double value) {
        Unsafe.putDoubleVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)), (double)value);
    }

    public static double getDoubleVolatile(Class<?> type, String fieldName) {
        return Unsafe.getDoubleVolatile(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putDoubleVolatile(Class<?> type, String fieldName, double value) {
        Unsafe.putDoubleVolatile(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)), (double)value);
    }

    public static <T> T getReferenceVolatile(Object object, Field fieldName) {
        return (T)Unsafe.getReferenceVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putReferenceVolatile(Object object, Field fieldName, Object value) {
        Unsafe.putReferenceVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (Object)value);
    }

    public static <T> T getReferenceVolatile(Object object, String fieldName) {
        return (T)Unsafe.getReferenceVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)));
    }

    public static void putReferenceVolatile(Object object, String fieldName, Object value) {
        Unsafe.putReferenceVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(object, fieldName)), (Object)value);
    }

    public static <T> T getReferenceVolatile(Class<?> type, String fieldName) {
        return (T)Unsafe.getReferenceVolatile(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putReferenceVolatile(Class<?> type, String fieldName, Object value) {
        Unsafe.putReferenceVolatile(type, (long)Unsafe.staticFieldOffset((Field)Fields.of(type, fieldName)), (Object)value);
    }

    public static Object getVolatile(Object object, Field fieldName) {
        return Accessor.get(object, fieldName.getType(), Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putVolatile(Object object, Field fieldName, Object value) {
        Accessor.put(object, fieldName.getType(), Unsafe.objectFieldOffset((Field)fieldName), value);
    }

    public static Object getVolatile(Object object, String fieldName) {
        Field field = Fields.of(object, fieldName);
        return Accessor.get(object, field.getType(), Unsafe.objectFieldOffset((Field)field));
    }

    public static void putVolatile(Object object, String fieldName, Object value) {
        Field field = Fields.of(object, fieldName);
        Accessor.put(object, field.getType(), Unsafe.objectFieldOffset((Field)field), value);
    }

    public static Object getVolatile(Class<?> type, String fieldName) {
        Field field = Fields.of(type, fieldName);
        return Accessor.get(type, field.getType(), Unsafe.staticFieldOffset((Field)field));
    }

    public static void putVolatile(Class<?> type, String fieldName, Object value) {
        Field field = Fields.of(type, fieldName);
        Accessor.put(type, field.getType(), Unsafe.staticFieldOffset((Field)field), value);
    }

    public static boolean getBoolean(Object object, Class<?> type, Field fieldName) {
        return Unsafe.getBoolean((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putBoolean(Object object, Class<?> type, Field fieldName, boolean value) {
        Unsafe.putBoolean((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (boolean)value);
    }

    public static boolean getBoolean(Object object, Class<?> type, String fieldName) {
        return Unsafe.getBoolean((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putBoolean(Object object, Class<?> type, String fieldName, boolean value) {
        Unsafe.putBoolean((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)), (boolean)value);
    }

    public static byte getByte(Object object, Class<?> type, Field fieldName) {
        return Unsafe.getByte((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putByte(Object object, Class<?> type, Field fieldName, byte value) {
        Unsafe.putByte((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (byte)value);
    }

    public static byte getByte(Object object, Class<?> type, String fieldName) {
        return Unsafe.getByte((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putByte(Object object, Class<?> type, String fieldName, byte value) {
        Unsafe.putByte((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)), (byte)value);
    }

    public static char getChar(Object object, Class<?> type, Field fieldName) {
        return Unsafe.getChar((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putChar(Object object, Class<?> type, Field fieldName, char value) {
        Unsafe.putChar((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (char)value);
    }

    public static char getChar(Object object, Class<?> type, String fieldName) {
        return Unsafe.getChar((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putChar(Object object, Class<?> type, String fieldName, char value) {
        Unsafe.putChar((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)), (char)value);
    }

    public static short getShort(Object object, Class<?> type, Field fieldName) {
        return Unsafe.getShort((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putShort(Object object, Class<?> type, Field fieldName, short value) {
        Unsafe.putShort((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (short)value);
    }

    public static short getShort(Object object, Class<?> type, String fieldName) {
        return Unsafe.getShort((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putShort(Object object, Class<?> type, String fieldName, short value) {
        Unsafe.putShort((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)), (short)value);
    }

    public static int getInt(Object object, Class<?> type, Field fieldName) {
        return Unsafe.getInt((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putInt(Object object, Class<?> type, Field fieldName, int value) {
        Unsafe.putInt((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (int)value);
    }

    public static int getInt(Object object, Class<?> type, String fieldName) {
        return Unsafe.getInt((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putInt(Object object, Class<?> type, String fieldName, int value) {
        Unsafe.putInt((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)), (int)value);
    }

    public static long getLong(Object object, Class<?> type, Field fieldName) {
        return Unsafe.getLong((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putLong(Object object, Class<?> type, Field fieldName, long value) {
        Unsafe.putLong((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (long)value);
    }

    public static long getLong(Object object, Class<?> type, String fieldName) {
        return Unsafe.getLong((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putLong(Object object, Class<?> type, String fieldName, long value) {
        Unsafe.putLong((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)), (long)value);
    }

    public static float getFloat(Object object, Class<?> type, Field fieldName) {
        return Unsafe.getFloat((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putFloat(Object object, Class<?> type, Field fieldName, float value) {
        Unsafe.putFloat((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (float)value);
    }

    public static float getFloat(Object object, Class<?> type, String fieldName) {
        return Unsafe.getFloat((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putFloat(Object object, Class<?> type, String fieldName, float value) {
        Unsafe.putFloat((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)), (float)value);
    }

    public static double getDouble(Object object, Class<?> type, Field fieldName) {
        return Unsafe.getDouble((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putDouble(Object object, Class<?> type, Field fieldName, double value) {
        Unsafe.putDouble((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (double)value);
    }

    public static double getDouble(Object object, Class<?> type, String fieldName) {
        return Unsafe.getDouble((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putDouble(Object object, Class<?> type, String fieldName, double value) {
        Unsafe.putDouble((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)), (double)value);
    }

    public static <T> T getReference(Object object, Class<?> type, Field fieldName) {
        return (T)Unsafe.getReference((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putReference(Object object, Class<?> type, Field fieldName, Object value) {
        Unsafe.putReference((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (Object)value);
    }

    public static <T> T getReference(Object object, Class<?> type, String fieldName) {
        return (T)Unsafe.getReference((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putReference(Object object, Class<?> type, String fieldName, Object value) {
        Unsafe.putReference((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)), (Object)value);
    }

    public static long getAddress(Object object, Class<?> type, Field fieldName) {
        return Unsafe.getAddress((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putAddress(Object object, Class<?> type, Field fieldName, long value) {
        Unsafe.putAddress((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (long)value);
    }

    public static long getAddress(Object object, Class<?> type, String fieldName) {
        return Unsafe.getAddress((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putAddress(Object object, Class<?> type, String fieldName, long value) {
        Unsafe.putAddress((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)), (long)value);
    }

    public static Object get(Object object, Class<?> type, Field fieldName) {
        return Accessor.get(object, fieldName.getType(), Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void put(Object object, Class<?> type, Field fieldName, Object value) {
        Accessor.put(object, fieldName.getType(), Unsafe.objectFieldOffset((Field)fieldName), value);
    }

    public static Object get(Object object, Class<?> type, String fieldName) {
        Field field = Fields.of(type, fieldName);
        return Accessor.get(object, field.getType(), Unsafe.objectFieldOffset((Field)field));
    }

    public static void put(Object object, Class<?> type, String fieldName, Object value) {
        Field field = Fields.of(type, fieldName);
        Accessor.put(object, field.getType(), Unsafe.objectFieldOffset((Field)field), value);
    }

    public static boolean getBooleanVolatile(Object object, Class<?> type, Field fieldName) {
        return Unsafe.getBooleanVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putBooleanVolatile(Object object, Class<?> type, Field fieldName, boolean value) {
        Unsafe.putBooleanVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (boolean)value);
    }

    public static boolean getBooleanVolatile(Object object, Class<?> type, String fieldName) {
        return Unsafe.getBooleanVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putBooleanVolatile(Object object, Class<?> type, String fieldName, boolean value) {
        Unsafe.putBooleanVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)), (boolean)value);
    }

    public static byte getByteVolatile(Object object, Class<?> type, Field fieldName) {
        return Unsafe.getByteVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putByteVolatile(Object object, Class<?> type, Field fieldName, byte value) {
        Unsafe.putByteVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (byte)value);
    }

    public static byte getByteVolatile(Object object, Class<?> type, String fieldName) {
        return Unsafe.getByteVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putByteVolatile(Object object, Class<?> type, String fieldName, byte value) {
        Unsafe.putByteVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)), (byte)value);
    }

    public static char getCharVolatile(Object object, Class<?> type, Field fieldName) {
        return Unsafe.getCharVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putCharVolatile(Object object, Class<?> type, Field fieldName, char value) {
        Unsafe.putCharVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (char)value);
    }

    public static char getCharVolatile(Object object, Class<?> type, String fieldName) {
        return Unsafe.getCharVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putCharVolatile(Object object, Class<?> type, String fieldName, char value) {
        Unsafe.putCharVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)), (char)value);
    }

    public static short getShortVolatile(Object object, Class<?> type, Field fieldName) {
        return Unsafe.getShortVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putShortVolatile(Object object, Class<?> type, Field fieldName, short value) {
        Unsafe.putShortVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (short)value);
    }

    public static short getShortVolatile(Object object, Class<?> type, String fieldName) {
        return Unsafe.getShortVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putShortVolatile(Object object, Class<?> type, String fieldName, short value) {
        Unsafe.putShortVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)), (short)value);
    }

    public static int getIntVolatile(Object object, Class<?> type, Field fieldName) {
        return Unsafe.getIntVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putIntVolatile(Object object, Class<?> type, Field fieldName, int value) {
        Unsafe.putIntVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (int)value);
    }

    public static int getIntVolatile(Object object, Class<?> type, String fieldName) {
        return Unsafe.getIntVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putIntVolatile(Object object, Class<?> type, String fieldName, int value) {
        Unsafe.putIntVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)), (int)value);
    }

    public static long getLongVolatile(Object object, Class<?> type, Field fieldName) {
        return Unsafe.getLongVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putLongVolatile(Object object, Class<?> type, Field fieldName, long value) {
        Unsafe.putLongVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (long)value);
    }

    public static long getLongVolatile(Object object, Class<?> type, String fieldName) {
        return Unsafe.getLongVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putLongVolatile(Object object, Class<?> type, String fieldName, long value) {
        Unsafe.putLongVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)), (long)value);
    }

    public static float getFloatVolatile(Object object, Class<?> type, Field fieldName) {
        return Unsafe.getFloatVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putFloatVolatile(Object object, Class<?> type, Field fieldName, float value) {
        Unsafe.putFloatVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (float)value);
    }

    public static float getFloatVolatile(Object object, Class<?> type, String fieldName) {
        return Unsafe.getFloatVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putFloatVolatile(Object object, Class<?> type, String fieldName, float value) {
        Unsafe.putFloatVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)), (float)value);
    }

    public static double getDoubleVolatile(Object object, Class<?> type, Field fieldName) {
        return Unsafe.getDoubleVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putDoubleVolatile(Object object, Class<?> type, Field fieldName, double value) {
        Unsafe.putDoubleVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (double)value);
    }

    public static double getDoubleVolatile(Object object, Class<?> type, String fieldName) {
        return Unsafe.getDoubleVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putDoubleVolatile(Object object, Class<?> type, String fieldName, double value) {
        Unsafe.putDoubleVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)), (double)value);
    }

    public static <T> T getReferenceVolatile(Object object, Class<?> type, Field fieldName) {
        return (T)Unsafe.getReferenceVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putReferenceVolatile(Object object, Class<?> type, Field fieldName, Object value) {
        Unsafe.putReferenceVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)fieldName), (Object)value);
    }

    public static <T> T getReferenceVolatile(Object object, Class<?> type, String fieldName) {
        return (T)Unsafe.getReferenceVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)));
    }

    public static void putReferenceVolatile(Object object, Class<?> type, String fieldName, Object value) {
        Unsafe.putReferenceVolatile((Object)object, (long)Unsafe.objectFieldOffset((Field)Fields.of(type, fieldName)), (Object)value);
    }

    public static Object getVolatile(Object object, Class<?> type, Field fieldName) {
        return Accessor.get(object, fieldName.getType(), Unsafe.objectFieldOffset((Field)fieldName));
    }

    public static void putVolatile(Object object, Class<?> type, Field fieldName, Object value) {
        Accessor.put(object, fieldName.getType(), Unsafe.objectFieldOffset((Field)fieldName), value);
    }

    public static Object getVolatile(Object object, Class<?> type, String fieldName) {
        Field field = Fields.of(type, fieldName);
        return Accessor.get(object, field.getType(), Unsafe.objectFieldOffset((Field)field));
    }

    public static void putVolatile(Object object, Class<?> type, String fieldName, Object value) {
        Field field = Fields.of(type, fieldName);
        Accessor.put(object, field.getType(), Unsafe.objectFieldOffset((Field)field), value);
    }

    public static Object get(Object object, Class<?> type, long offset) {
        if (type == Boolean.TYPE) {
            return Unsafe.getBoolean((Object)object, (long)offset);
        }
        if (type == Byte.TYPE) {
            return Unsafe.getByte((Object)object, (long)offset);
        }
        if (type == Character.TYPE) {
            return Character.valueOf(Unsafe.getChar((Object)object, (long)offset));
        }
        if (type == Short.TYPE) {
            return Unsafe.getShort((Object)object, (long)offset);
        }
        if (type == Integer.TYPE) {
            return Unsafe.getInt((Object)object, (long)offset);
        }
        if (type == Long.TYPE) {
            return Unsafe.getLong((Object)object, (long)offset);
        }
        if (type == Float.TYPE) {
            return Float.valueOf(Unsafe.getFloat((Object)object, (long)offset));
        }
        if (type == Double.TYPE) {
            return Unsafe.getDouble((Object)object, (long)offset);
        }
        return Unsafe.getReference((Object)object, (long)offset);
    }

    public static Object getVolatile(Object object, Class<?> type, long offset) {
        if (type == Boolean.TYPE) {
            return Unsafe.getBooleanVolatile((Object)object, (long)offset);
        }
        if (type == Byte.TYPE) {
            return Unsafe.getByteVolatile((Object)object, (long)offset);
        }
        if (type == Character.TYPE) {
            return Character.valueOf(Unsafe.getCharVolatile((Object)object, (long)offset));
        }
        if (type == Short.TYPE) {
            return Unsafe.getShortVolatile((Object)object, (long)offset);
        }
        if (type == Integer.TYPE) {
            return Unsafe.getIntVolatile((Object)object, (long)offset);
        }
        if (type == Long.TYPE) {
            return Unsafe.getLongVolatile((Object)object, (long)offset);
        }
        if (type == Float.TYPE) {
            return Float.valueOf(Unsafe.getFloatVolatile((Object)object, (long)offset));
        }
        if (type == Double.TYPE) {
            return Unsafe.getDoubleVolatile((Object)object, (long)offset);
        }
        return Unsafe.getReferenceVolatile((Object)object, (long)offset);
    }

    public static void put(Object object, Class<?> type, long offset, Object value) {
        if (type == Boolean.TYPE) {
            Unsafe.putBoolean((Object)object, (long)offset, (boolean)((Boolean)value));
        } else if (type == Byte.TYPE) {
            Unsafe.putByte((Object)object, (long)offset, (byte)((Byte)value));
        } else if (type == Character.TYPE) {
            Unsafe.putChar((Object)object, (long)offset, (char)((Character)value).charValue());
        } else if (type == Short.TYPE) {
            Unsafe.putShort((Object)object, (long)offset, (short)((Short)value));
        } else if (type == Integer.TYPE) {
            Unsafe.putInt((Object)object, (long)offset, (int)((Integer)value));
        } else if (type == Long.TYPE) {
            Unsafe.putLong((Object)object, (long)offset, (long)((Long)value));
        } else if (type == Float.TYPE) {
            Unsafe.putFloat((Object)object, (long)offset, (float)((Float)value).floatValue());
        } else if (type == Double.TYPE) {
            Unsafe.putDouble((Object)object, (long)offset, (double)((Double)value));
        } else {
            Unsafe.putReference((Object)object, (long)offset, (Object)value);
        }
    }

    public static void putVolatile(Object object, Class<?> type, long offset, Object value) {
        if (type == Boolean.TYPE) {
            Unsafe.putBooleanVolatile((Object)object, (long)offset, (boolean)((Boolean)value));
        } else if (type == Byte.TYPE) {
            Unsafe.putByteVolatile((Object)object, (long)offset, (byte)((Byte)value));
        } else if (type == Character.TYPE) {
            Unsafe.putCharVolatile((Object)object, (long)offset, (char)((Character)value).charValue());
        } else if (type == Short.TYPE) {
            Unsafe.putShortVolatile((Object)object, (long)offset, (short)((Short)value));
        } else if (type == Integer.TYPE) {
            Unsafe.putIntVolatile((Object)object, (long)offset, (int)((Integer)value));
        } else if (type == Long.TYPE) {
            Unsafe.putLongVolatile((Object)object, (long)offset, (long)((Long)value));
        } else if (type == Float.TYPE) {
            Unsafe.putFloatVolatile((Object)object, (long)offset, (float)((Float)value).floatValue());
        } else if (type == Double.TYPE) {
            Unsafe.putDoubleVolatile((Object)object, (long)offset, (double)((Double)value));
        } else {
            Unsafe.putReferenceVolatile((Object)object, (long)offset, (Object)value);
        }
    }

    public static <T> T clone(T object) {
        if (object == null) {
            return null;
        }
        Object clone = Unsafe.allocateInstance(object.getClass());
        for (Pointer pointer : ((CacheMap)( /* dynamic constant */ (Object)ConstantBootstraps.invoke("0", new Object[]{identity()}))).computeIfAbsent(object.getClass(), type -> (Pointer[])Fields.allInstance(type).map(Pointer::of).toArray(Pointer[]::new))) {
            pointer.put(clone, pointer.get(object));
        }
        return (T)clone;
    }
}

