/*
 * Decompiled with CFR 0.152.
 */
package net.auoeke.reflect;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class CacheMap<K, V> {
    private SoftReference<Map<K, V>> map = new SoftReference<Object>(null);

    CacheMap() {
    }

    static <K, V> CacheMap<K, V> identity() {
        return new Identity();
    }

    static <K, V> CacheMap<K, V> hash() {
        return new Hash();
    }

    abstract Map<K, V> construct();

    final V get(K key) {
        return this.map().get(key);
    }

    final V put(K key, V value) {
        return this.map().put(key, value);
    }

    final void putAll(Map<? extends K, ? extends V> map) {
        this.map().putAll(map);
    }

    final void putAll(CacheMap<? extends K, ? extends V> map) {
        this.putAll(map.map());
    }

    final <T extends K> V computeIfAbsent(T key, Function<? super T, ? extends V> computer) {
        return this.map().computeIfAbsent((T)key, computer);
    }

    private Map<K, V> map() {
        SoftReference<Map<K, V>> softReference;
        if (this.map.refersTo(null)) {
            this.map = new SoftReference<Map<K, V>>(this.construct());
            softReference = this.map;
        } else {
            softReference = this.map;
        }
        return softReference.get();
    }

    static final class Identity<K, V>
    extends CacheMap<K, V> {
        Identity() {
        }

        @Override
        Map<K, V> construct() {
            return new IdentityHashMap();
        }
    }

    static final class Hash<K, V>
    extends CacheMap<K, V> {
        Hash() {
        }

        @Override
        Map<K, V> construct() {
            return new HashMap();
        }
    }
}

