/*
 * Decompiled with CFR 0.152.
 */
package net.auoeke.reflect;

import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandle;
import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.util.Objects;
import net.auoeke.reflect.Classes;
import net.auoeke.reflect.Invoker;
import net.auoeke.reflect.StackFrames;
import net.gudenau.lib.unsafe.Unsafe;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class ClassDefiner<T> {
    private String name;
    private ClassLoader loader = StackFrames.caller().getClassLoader();
    private boolean secure;
    private Object classFile;
    private int offset;
    private int length;
    private ProtectionDomain domain;
    private CodeSource source;
    private boolean unsafe;
    private boolean initialize;

    public static ClassDefiner<?> make() {
        return new ClassDefiner().loader(StackFrames.caller().getClassLoader());
    }

    public ClassDefiner<T> name(String name) {
        this.name = name.replace('/', '.');
        return this;
    }

    public ClassDefiner<T> loader(ClassLoader loader) {
        this.loader = loader;
        this.secure = false;
        if (loader == null) {
            this.unsafe = true;
        }
        return this;
    }

    public ClassDefiner<T> secureLoader(SecureClassLoader loader, CodeSource source) {
        this.loader = Objects.requireNonNull(loader);
        this.secure = true;
        this.source = source;
        return this;
    }

    public ClassDefiner<T> classFile(byte[] classFile, int offset, int length) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset == " + offset);
        }
        if (offset + length > classFile.length) {
            throw new IllegalArgumentException("offset + length > classFile.length");
        }
        this.classFile = Objects.requireNonNull(classFile);
        this.offset = offset;
        this.length = length;
        return this;
    }

    public ClassDefiner<T> classFile(byte[] classFile) {
        return this.classFile(classFile, 0, classFile.length);
    }

    public ClassDefiner<T> classFile(ByteBuffer classFile) {
        this.classFile = classFile;
        return this;
    }

    public ClassDefiner<T> classFile(ClassLoader resourceLoader, String type) {
        this.classFile(Classes.classFile(resourceLoader, type));
        return this;
    }

    public ClassDefiner<T> classFile(String type) {
        this.classFile(Classes.classFile(StackFrames.caller().getClassLoader(), type));
        return this;
    }

    public ClassDefiner<T> source(CodeSource source) {
        this.secure = false;
        if (source != null) {
            this.domain = new ProtectionDomain(source, null, this.loader, null);
        }
        return this;
    }

    public ClassDefiner<T> protectionDomain(ProtectionDomain domain) {
        this.domain = domain;
        this.secure = false;
        return this;
    }

    public ClassDefiner<T> unsafe() {
        this.unsafe = true;
        return this;
    }

    public ClassDefiner<T> initialize() {
        this.initialize = true;
        return this;
    }

    public ClassDefiner<T> from(Class<?> type) {
        this.protectionDomain(Objects.requireNonNull(type).getProtectionDomain()).classFile(Classes.classFile(type));
        return this;
    }

    public Class<T> define() {
        boolean array = this.classFile instanceof byte[];
        Class<?> type = this.unsafe ? this.unsafeDefine() : (this.secure ? this.secureDefine(array) : this.define(array));
        return this.initialize ? Classes.initialize(type) : type;
    }

    private ClassLoader loader() {
        if (this.loader == null) {
            throw new IllegalStateException("loader is null");
        }
        return this.loader;
    }

    private Class<?> unsafeDefine() {
        int length;
        byte[] array;
        Object bytecode = this.classFile;
        if (bytecode instanceof ByteBuffer) {
            ByteBuffer buffer = (ByteBuffer)bytecode;
            array = new byte[buffer.remaining()];
            buffer.get(array);
            length = array.length;
        } else {
            array = (byte[])bytecode;
            length = this.length;
        }
        return Unsafe.defineClass((String)this.name, (byte[])array, (int)this.offset, (int)length, (ClassLoader)this.loader, (ProtectionDomain)this.domain);
    }

    private Class<?> secureDefine(boolean array) {
        return (Class)(array ? ( /* dynamic constant */ (Object)ConstantBootstraps.invoke("0", new Object[]{lambda$secureDefine$0()})).invoke(this.loader(), this.name, this.classFile, this.offset, this.length, this.source) : ( /* dynamic constant */ (Object)ConstantBootstraps.invoke("1", new Object[]{lambda$secureDefine$1()})).invoke(this.loader(), this.name, this.classFile, this.source));
    }

    private Class<?> define(boolean array) {
        return (Class)(array ? ( /* dynamic constant */ (Object)ConstantBootstraps.invoke("2", new Object[]{lambda$define$2()})).invoke(this.loader(), this.name, this.classFile, this.offset, this.length, this.domain) : ( /* dynamic constant */ (Object)ConstantBootstraps.invoke("3", new Object[]{lambda$define$3()})).invoke(this.loader(), this.name, this.classFile, this.domain));
    }

    private static /* synthetic */ MethodHandle lambda$define$3() {
        return Invoker.findVirtual(ClassLoader.class, "defineClass", Class.class, String.class, ByteBuffer.class, ProtectionDomain.class);
    }

    private static /* synthetic */ MethodHandle lambda$define$2() {
        return Invoker.findVirtual(ClassLoader.class, "defineClass", Class.class, String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
    }

    private static /* synthetic */ MethodHandle lambda$secureDefine$1() {
        return Invoker.findVirtual(SecureClassLoader.class, "defineClass", Class.class, String.class, ByteBuffer.class, CodeSource.class);
    }

    private static /* synthetic */ MethodHandle lambda$secureDefine$0() {
        return Invoker.findVirtual(SecureClassLoader.class, "defineClass", Class.class, String.class, byte[].class, Integer.TYPE, Integer.TYPE, CodeSource.class);
    }
}

