/*
 * Decompiled with CFR 0.152.
 */
package net.auoeke.reflect;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.function.Consumer;

@FunctionalInterface
public interface ClassTransformer
extends ClassFileTransformer {
    public static ClassTransformer of(ClassTransformer transformer) {
        return transformer;
    }

    @Override
    public byte[] transform(Module var1, ClassLoader var2, String var3, Class<?> var4, ProtectionDomain var5, byte[] var6);

    default public ClassTransformer ofType(Class<?> type) {
        return (module, loader, name, t, domain, classFile) -> t == type ? this.transform(module, loader, name, t, domain, classFile) : null;
    }

    default public ClassTransformer ofType(String type) {
        type = type.replace('.', '/');
        return (module, loader, name, t, domain, classFile) -> name.equals(type) ? this.transform(module, loader, name, t, domain, classFile) : null;
    }

    default public ClassTransformer exceptionHandling(Consumer<? super Throwable> handler) {
        return (module, loader, name, type, domain, classFile) -> {
            try {
                return this.transform(module, loader, name, type, domain, classFile);
            }
            catch (Throwable trouble) {
                handler.accept(trouble);
                throw trouble;
            }
        };
    }

    default public ClassTransformer exceptionLogging() {
        return this.exceptionHandling(Throwable::printStackTrace);
    }

    default public ClassTransformer singleUse(final Instrumentation instrumentation) {
        return new ClassTransformer(){

            @Override
            public byte[] transform(Module module, ClassLoader loader, String name, Class<?> type, ProtectionDomain domain, byte[] classFile) {
                byte[] result = ClassTransformer.this.transform(module, loader, name, type, domain, classFile);
                if (result != null) {
                    instrumentation.removeTransformer(this);
                }
                return result;
            }
        };
    }
}

