/*
 * Decompiled with CFR 0.152.
 */
package net.auoeke.reflect;

import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.auoeke.reflect.CacheMap;
import net.auoeke.reflect.Classes;
import net.auoeke.reflect.Constructors;
import net.auoeke.reflect.Fields;
import net.auoeke.reflect.Flags;
import net.auoeke.reflect.Invoker;
import net.auoeke.reflect.Pointer;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class EnumConstructor<E extends Enum<E>> {
    private static final int ENUM_VALUES = 4122;
    private static final CacheMap<Class<?>, EnumConstructor<?>> constructors =  /* dynamic constant */ (Object)ConstantBootstraps.invoke("0", new Object[]{identity()});
    private static final Pointer enumConstants;
    private static final Pointer enumConstantDirectory;
    private static final MethodHandle getEnumVars;
    public final Class<E> type;
    public final MethodHandle constructor;

    protected EnumConstructor(Class<E> type, Class<?> ... parameterTypes) {
        this(EnumConstructor.constructor(type, parameterTypes));
    }

    protected EnumConstructor(Constructor<E> constructor) {
        this.type = constructor.getDeclaringClass();
        this.constructor = Invoker.unreflectConstructor(constructor).asSpreader(Object[].class, constructor.getParameterCount() - 2);
    }

    public static <E extends Enum<E>> Constructor<E> constructor(Class<E> type, Object ... arguments) {
        return Constructors.find(7L, 2, type, arguments);
    }

    public static <E extends Enum<E>> Constructor<E> constructor(long flags, Class<E> type, Object ... arguments) {
        return Constructors.find(flags, 2, type, arguments);
    }

    public static <E extends Enum<E>> Constructor<E> constructor(Class<E> type, Class<?> ... parameterTypes) {
        return Constructors.find(2, type, parameterTypes);
    }

    public static <E extends Enum<E>> EnumConstructor<E> get(long flags, Class<E> type, Object ... arguments) {
        return constructors.computeIfAbsent(type, t -> new EnumConstructor(EnumConstructor.constructor(flags, t, arguments)));
    }

    public static <E extends Enum<E>> EnumConstructor<E> get(Class<E> type, Object ... arguments) {
        return EnumConstructor.get(7L, type, arguments);
    }

    public static <E extends Enum<E>> EnumConstructor<E> get(Class<E> type) {
        return constructors.computeIfAbsent(type, x$0 -> new EnumConstructor(x$0, new Class[0]));
    }

    public static <E extends Enum<E>> EnumConstructor<E> get(Class<E> type, Class<?> ... parameterTypes) {
        return constructors.computeIfAbsent(type, t -> new EnumConstructor(t, parameterTypes));
    }

    public static <E extends Enum<E>> E add(Class<E> type, String name, Object ... arguments) {
        return EnumConstructor.add(7L, type, EnumConstructor.nextOrdinal(type), name, arguments);
    }

    public static <E extends Enum<E>> E add(Class<E> type, int ordinal, String name, Object ... arguments) {
        return EnumConstructor.add(7L, type, ordinal, name, arguments);
    }

    public static <E extends Enum<E>> E add(long flags, Class<E> type, String name, Object ... arguments) {
        return EnumConstructor.add(flags, type, EnumConstructor.nextOrdinal(type), name, arguments);
    }

    public static <E extends Enum<E>> E add(long flags, Class<E> type, int ordinal, String name, Object ... arguments) {
        return EnumConstructor.add(type, EnumConstructor.construct(flags, type, ordinal, name, arguments));
    }

    public static <E extends Enum<E>> E add(Class<E> type, E enumConstant) {
        Pointer enumArray = EnumConstructor.enumArray(type);
        Enum[] values = (Enum[])enumArray.getT();
        Enum[] newValues = Arrays.copyOf(values, values.length + 1);
        newValues[values.length] = enumConstant;
        enumArray.put(newValues);
        enumConstants.put(getEnumVars == null ? type : getEnumVars.invoke(type), newValues);
        enumConstantDirectory.put(getEnumVars == null ? type : getEnumVars.invoke(type), null);
        return enumConstant;
    }

    public static <E extends Enum<E>> E construct(Class<E> type, String name, Object ... arguments) {
        return EnumConstructor.get(7L, type, arguments).construct(EnumConstructor.nextOrdinal(type), name, arguments);
    }

    public static <E extends Enum<E>> E construct(Class<E> type, int ordinal, String name, Object ... arguments) {
        return EnumConstructor.get(7L, type, arguments).construct(ordinal, name, arguments);
    }

    public static <E extends Enum<E>> E construct(long flags, Class<E> type, String name, Object ... arguments) {
        return EnumConstructor.get(flags, type, arguments).construct(EnumConstructor.nextOrdinal(type), name, arguments);
    }

    public static <E extends Enum<E>> E construct(long flags, Class<E> type, int ordinal, String name, Object ... arguments) {
        return EnumConstructor.get(flags, type, arguments).construct(ordinal, name, arguments);
    }

    public static Pointer enumArray(Class<?> type) {
        return ((CacheMap)( /* dynamic constant */ (Object)ConstantBootstraps.invoke("1", new Object[]{identity()}))).computeIfAbsent(type, t -> Fields.of(t).filter(EnumConstructor::isValueField).peek(field -> field.getDeclaringClass().getEnumConstants()).findFirst().map(Pointer::of).orElse(null));
    }

    public static boolean isValueField(Field field) {
        if (Flags.not(field, 4122L)) {
            return false;
        }
        Class<?> owner = field.getDeclaringClass();
        return owner.isEnum() && field.getType().componentType() == owner;
    }

    private static int nextOrdinal(Class<?> type) {
        return type.getEnumConstants().length;
    }

    public E construct(int ordinal, String name, Object ... arguments) {
        return (E)this.constructor.invoke(name, ordinal, arguments);
    }

    public E construct(String name, Object ... arguments) {
        return this.construct(EnumConstructor.nextOrdinal(this.type), name, arguments);
    }

    public E add(int ordinal, String name, Object ... arguments) {
        return EnumConstructor.add(this.type, this.construct(ordinal, name, arguments));
    }

    public E add(String name, Object ... arguments) {
        return this.add(EnumConstructor.nextOrdinal(this.type), name, arguments);
    }

    static {
        Class type = Classes.load(EnumConstructor.class.getClassLoader(), Class.class.getName() + "$EnumVars");
        if (type == null) {
            enumConstants = Pointer.of(Class.class, "enumConstants");
            enumConstantDirectory = Pointer.of(Class.class, "enumConstantDirectory");
            getEnumVars = null;
        } else {
            enumConstants = Pointer.of(type, "cachedEnumConstants");
            enumConstantDirectory = Pointer.of(type, "cachedEnumConstantDirectory");
            getEnumVars = Invoker.findSpecial(Class.class, "getEnumVars", type);
        }
    }
}

