/*
 * Decompiled with CFR 0.152.
 */
package net.auoeke.reflect;

import java.lang.module.ModuleDescriptor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class Flags {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int VOLATILE = 64;
    public static final int BRIDGE = 64;
    public static final int TRANSIENT = 128;
    public static final int VARARGS = 128;
    public static final int NATIVE = 256;
    public static final int INTERFACE = 512;
    public static final int ABSTRACT = 1024;
    public static final int STRICT = 2048;
    public static final int SYNTHETIC = 4096;
    public static final int ANNOTATION = 8192;
    public static final int ENUM = 16384;
    public static final int MANDATED = 32768;
    public static final int VISIBILITY = 7;

    public static boolean all(long field, long target) {
        return (field & target) == target;
    }

    public static boolean all(Member member, long target) {
        return Flags.all(Flags.modifiers(member), target);
    }

    public static boolean all(Class<?> type, long target) {
        return Flags.all(Flags.modifiers(type), target);
    }

    public static boolean any(long field, long target) {
        return (field & target) != 0L;
    }

    public static boolean any(Member member, long target) {
        return Flags.any(Flags.modifiers(member), target);
    }

    public static boolean any(Class<?> type, long target) {
        return Flags.any(Flags.modifiers(type), target);
    }

    public static boolean not(long field, long target) {
        return (field & target) != target;
    }

    public static boolean not(Member member, long target) {
        return Flags.not(Flags.modifiers(member), target);
    }

    public static boolean not(Class<?> type, long target) {
        return Flags.not(Flags.modifiers(type), target);
    }

    public static boolean none(long field, long target) {
        return (field & target) == 0L;
    }

    public static boolean none(Member member, long target) {
        return Flags.none(Flags.modifiers(member), target);
    }

    public static boolean none(Class<?> type, long target) {
        return Flags.none(Flags.modifiers(type), target);
    }

    public static int remove(int field, int target) {
        return field & ~target;
    }

    public static long remove(long field, long target) {
        return field & (target ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int remove(Member member, int modifiers) {
        return Flags.remove(Flags.modifiers(member), modifiers);
    }

    public static int remove(Class<?> type, int modifiers) {
        return Flags.remove(Flags.modifiers(type), modifiers);
    }

    public static int visibility(int modifiers, int visibility) {
        return modifiers & 0xFFFFFFF8 | visibility;
    }

    public static boolean isPublic(long modifiers) {
        return Flags.all(modifiers, 1L);
    }

    public static boolean isProtected(long modifiers) {
        return Flags.all(modifiers, 4L);
    }

    public static boolean isPrivate(long modifiers) {
        return Flags.all(modifiers, 2L);
    }

    public static boolean isPackagePrivate(long modifiers) {
        return Flags.none(modifiers, 7L);
    }

    public static boolean isStatic(long modifiers) {
        return Flags.all(modifiers, 8L);
    }

    public static boolean isInstance(long modifiers) {
        return !Flags.isStatic(modifiers);
    }

    public static boolean isFinal(long modifiers) {
        return Flags.all(modifiers, 16L);
    }

    public static boolean isSynchronized(long modifiers) {
        return Flags.all(modifiers, 32L);
    }

    public static boolean isVolatile(long modifiers) {
        return Flags.all(modifiers, 64L);
    }

    public static boolean isBridge(long modifiers) {
        return Flags.all(modifiers, 64L);
    }

    public static boolean isTransient(long modifiers) {
        return Flags.all(modifiers, 128L);
    }

    public static boolean isVarargs(long modifiers) {
        return Flags.all(modifiers, 128L);
    }

    public static boolean isNative(long modifiers) {
        return Flags.all(modifiers, 256L);
    }

    public static boolean isAbstract(long type) {
        return Flags.all(type, 1024L);
    }

    public static boolean isStrict(long modifiers) {
        return Flags.all(modifiers, 2048L);
    }

    public static boolean isSynthetic(long modifiers) {
        return Flags.all(modifiers, 4096L);
    }

    public static boolean isAnnotation(long modifiers) {
        return Flags.all(modifiers, 8192L);
    }

    public static boolean isEnum(long modifiers) {
        return Flags.all(modifiers, 16384L);
    }

    public static boolean isMandated(long modifiers) {
        return Flags.all(modifiers, 32768L);
    }

    public static boolean isPublic(Class<?> type) {
        return Flags.all(type, 1L);
    }

    public static boolean isPublic(Member member) {
        return Flags.all(member, 1L);
    }

    public static boolean isProtected(Class<?> type) {
        return Flags.all(type, 4L);
    }

    public static boolean isProtected(Member member) {
        return Flags.all(member, 4L);
    }

    public static boolean isPrivate(Class<?> type) {
        return Flags.all(type, 2L);
    }

    public static boolean isPrivate(Member member) {
        return Flags.all(member, 2L);
    }

    public static boolean isPackagePrivate(Class<?> type) {
        return Flags.none(type, 7L);
    }

    public static boolean isPackagePrivate(Member member) {
        return Flags.none(member, 7L);
    }

    public static boolean isStatic(Class<?> type) {
        return Flags.all(type, 8L);
    }

    public static boolean isStatic(Member member) {
        return Flags.all(member, 8L);
    }

    public static boolean isInstance(Class<?> type) {
        return !Flags.isStatic(type);
    }

    public static boolean isInstance(Member member) {
        return !Flags.isStatic(member);
    }

    public static boolean isFinal(Class<?> type) {
        return Flags.all(type, 16L);
    }

    public static boolean isFinal(Member member) {
        return Flags.all(member, 16L);
    }

    public static boolean isSynchronized(Member member) {
        return Flags.all(member, 32L);
    }

    public static boolean isVolatile(Field field) {
        return Flags.all(field, 64L);
    }

    public static boolean isBridge(Method method) {
        return Flags.all(method, 64L);
    }

    public static boolean isTransient(Field field) {
        return Flags.all(field, 128L);
    }

    public static boolean isVarargs(Executable executable) {
        return Flags.all(executable, 128L);
    }

    public static boolean isNative(Method method) {
        return Flags.all(method, 256L);
    }

    public static boolean isAbstract(Class<?> type) {
        return Flags.all(type, 1024L);
    }

    public static boolean isAbstract(Method method) {
        return Flags.all(method, 1024L);
    }

    public static boolean isStrict(Class<?> type) {
        return Flags.all(type, 2048L);
    }

    public static boolean isStrict(Method method) {
        return Flags.all(method, 2048L);
    }

    public static boolean isSynthetic(Member member) {
        return Flags.all(member, 4096L);
    }

    public static boolean isSynthetic(Class<?> type) {
        return Flags.all(type, 4096L);
    }

    public static boolean isSynthetic(Module module) {
        return Flags.is(module, ModuleDescriptor.Modifier.SYNTHETIC);
    }

    public static boolean isAnnotation(Class<?> type) {
        return Flags.all(type, 8192L);
    }

    public static boolean isEnum(Class<?> type) {
        return Flags.all(type, 16384L);
    }

    public static boolean isEnum(Field field) {
        return Flags.all(field, 16384L);
    }

    public static boolean isMandated(Module module) {
        return Flags.is(module, ModuleDescriptor.Modifier.MANDATED);
    }

    public static String string(long modifiers) {
        return Modifier.toString((int)modifiers);
    }

    public static String string(Class<?> type) {
        return Flags.string(type.getModifiers());
    }

    public static String string(Member member) {
        return Flags.string(member.getModifiers());
    }

    private static boolean is(Module module, ModuleDescriptor.Modifier modifier) {
        return module.getDescriptor().modifiers().contains((Object)modifier);
    }

    private static int modifiers(Class<?> type) {
        return type == null ? 0 : type.getModifiers();
    }

    private static int modifiers(Member member) {
        return member == null ? 0 : member.getModifiers();
    }
}

