/*
 * Decompiled with CFR 0.152.
 */
package net.auoeke.reflect;

import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.IntStream;
import net.auoeke.reflect.CacheMap;
import net.auoeke.reflect.Constructors;
import net.auoeke.reflect.Fields;
import net.auoeke.reflect.Flags;
import net.auoeke.reflect.Methods;
import net.auoeke.reflect.Types;
import net.gudenau.lib.unsafe.Unsafe;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class Invoker {
    public static final long DISCARD_UNUSED = Long.MIN_VALUE;

    public static Member member(MethodHandle handle) {
        return MethodHandles.reflectAs(Member.class, handle);
    }

    public static Field field(MethodHandle handle) {
        return MethodHandles.reflectAs(Field.class, handle);
    }

    public static Executable executable(MethodHandle handle) {
        return MethodHandles.reflectAs(Executable.class, handle);
    }

    public static <T> Constructor<T> constructor(MethodHandle handle) {
        return MethodHandles.reflectAs(Constructor.class, handle);
    }

    public static Method method(MethodHandle handle) {
        return MethodHandles.reflectAs(Method.class, handle);
    }

    public static <T> T invoke(MethodHandle handle) {
        return (T)handle.invoke();
    }

    public static <T> T invoke(MethodHandle handle, Object ... arguments) {
        return (T)handle.invokeWithArguments(arguments);
    }

    public static MethodHandle bind(Object receiver, String name, MethodType type) {
        return Unsafe.trustedLookup.bind(receiver, name, type);
    }

    public static MethodHandle bind(Object receiver, String name, Class<?> returnType) {
        return Invoker.bind(receiver, name, MethodType.methodType(returnType));
    }

    public static MethodHandle bind(Object receiver, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        return Invoker.bind(receiver, name, MethodType.methodType(returnType, parameterTypes));
    }

    public static MethodHandle findConstructor(Class<?> refc, MethodType type) {
        return Unsafe.trustedLookup.findConstructor(refc, type);
    }

    public static MethodHandle findConstructor(Class<?> refc) {
        return Invoker.findConstructor(refc, MethodType.methodType(Void.TYPE));
    }

    public static MethodHandle findConstructor(Class<?> refc, Class<?> ... parameterTypes) {
        return Invoker.findConstructor(refc, MethodType.methodType(Void.TYPE, parameterTypes));
    }

    public static MethodHandle findGetter(Class<?> refc, String name, Class<?> type) {
        return Unsafe.trustedLookup.findGetter(refc, name, type);
    }

    public static MethodHandle findSetter(Class<?> refc, String name, Class<?> type) {
        return Unsafe.trustedLookup.findSetter(refc, name, type);
    }

    public static MethodHandle findSpecial(Class<?> refc, String name, MethodType type) {
        return Unsafe.trustedLookup.findSpecial(refc, name, type, refc);
    }

    public static MethodHandle findSpecial(Class<?> refc, String name, Class<?> returnType) {
        return Invoker.findSpecial(refc, name, MethodType.methodType(returnType));
    }

    public static MethodHandle findSpecial(Class<?> refc, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        return Invoker.findSpecial(refc, name, MethodType.methodType(returnType, parameterTypes));
    }

    public static MethodHandle findStatic(Class<?> refc, String name, MethodType type) {
        return Unsafe.trustedLookup.findStatic(refc, name, type);
    }

    public static MethodHandle findStatic(Class<?> refc, String name, Class<?> returnType) {
        return Invoker.findStatic(refc, name, MethodType.methodType(returnType));
    }

    public static MethodHandle findStatic(Class<?> refc, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        return Invoker.findStatic(refc, name, MethodType.methodType(returnType, parameterTypes));
    }

    public static MethodHandle findStaticGetter(Class<?> refc, String name, Class<?> type) {
        return Unsafe.trustedLookup.findStaticGetter(refc, name, type);
    }

    public static MethodHandle findStaticSetter(Class<?> refc, String name, Class<?> type) {
        return Unsafe.trustedLookup.findStaticSetter(refc, name, type);
    }

    public static MethodHandle findVirtual(Class<?> refc, String name, MethodType type) {
        return Unsafe.trustedLookup.findVirtual(refc, name, type);
    }

    public static MethodHandle findVirtual(Class<?> type, String name, Class<?> returnType) {
        return Invoker.findVirtual(type, name, MethodType.methodType(returnType));
    }

    public static MethodHandle findVirtual(Class<?> type, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        return Invoker.findVirtual(type, name, MethodType.methodType(returnType, parameterTypes));
    }

    public static MethodHandle unreflect(Method method) {
        return ((CacheMap)( /* dynamic constant */ (Object)ConstantBootstraps.invoke("0", new Object[]{identity()}))).computeIfAbsent(method, m -> Unsafe.trustedLookup.unreflect((Method)m));
    }

    public static MethodHandle unreflect(Class<?> type, String name, Class<?> ... parameterTypes) {
        return Invoker.unreflect(Methods.of(type, name, parameterTypes));
    }

    public static MethodHandle unreflect(Class<?> type, String name) {
        return Invoker.unreflect(Methods.firstOf(type, name));
    }

    public static MethodHandle unreflect(Object object, String name, Class<?> ... parameterTypes) {
        return Invoker.unreflect(Methods.any(object.getClass(), name, parameterTypes)).bindTo(object);
    }

    public static MethodHandle unreflect(Object object, String name) {
        return Invoker.unreflect(Methods.any(object.getClass(), name)).bindTo(object);
    }

    public static MethodHandle unreflectConstructor(Constructor<?> constructor) {
        return Unsafe.trustedLookup.unreflectConstructor(constructor);
    }

    public static MethodHandle unreflectConstructor(Class<?> klass, Class<?> ... parameterTypes) {
        return Invoker.unreflectConstructor(Constructors.find(klass, parameterTypes));
    }

    public static MethodHandle unreflectSpecial(Method method) {
        return Unsafe.trustedLookup.unreflectSpecial(method, method.getDeclaringClass());
    }

    public static MethodHandle unreflectSpecial(Class<?> type, String name, Class<?> ... parameterTypes) {
        return Invoker.unreflectSpecial(Methods.of(type, name, parameterTypes));
    }

    public static MethodHandle unreflectGetter(Field field) {
        return Unsafe.trustedLookup.unreflectGetter(field);
    }

    public static MethodHandle unreflectGetter(Class<?> klass, String name) {
        return Invoker.unreflectGetter(Fields.of(klass, name));
    }

    public static MethodHandle unreflectSetter(Field field) {
        return Unsafe.trustedLookup.unreflectSetter(field);
    }

    public static MethodHandle unreflectSetter(Class<?> klass, String name) {
        return Invoker.unreflectSetter(Fields.of(klass, name));
    }

    public static VarHandle findStaticVarHandle(Class<?> owner, String name, Class<?> type) {
        return Unsafe.trustedLookup.findStaticVarHandle(owner, name, type);
    }

    public static VarHandle findVarHandle(Class<?> owner, String name, Class<?> type) {
        return Unsafe.trustedLookup.findVarHandle(owner, name, type);
    }

    public static VarHandle unreflectVarHandle(Field field) {
        return Unsafe.trustedLookup.unreflectVarHandle(field);
    }

    public static VarHandle unreflectVarHandle(Class<?> type, String name) {
        return Invoker.unreflectVarHandle(Fields.of(type, name));
    }

    public static MethodHandle adapt(long flags, MethodHandle handle, MethodType type) {
        boolean discardUnused = Flags.any(flags, Long.MIN_VALUE);
        if (!discardUnused && handle.type().parameterCount() != type.parameterCount()) {
            throw new IllegalArgumentException("Handle's (%d) and target type's (%d) parameter count differ.".formatted(handle.type().parameterCount(), type.parameterCount()));
        }
        int[] order = new int[handle.type().parameterCount()];
        ArrayList outputTypes = new ArrayList(handle.type().parameterList());
        Class<?>[] inputTypes = type.parameterArray();
        for (int inputIndex = 0; inputIndex < inputTypes.length; ++inputIndex) {
            Class<?> inputType = inputTypes[inputIndex];
            ListIterator<Class<?>> outputIterator = outputTypes.listIterator();
            int[] scores = new int[outputTypes.size()];
            int bestMatch = -1;
            int deviation = Integer.MAX_VALUE;
            while (outputIterator.hasNext()) {
                Class<?> outputType = outputIterator.next();
                if (outputType == null || !outputType.isAssignableFrom(inputType) || deviation <= (deviation = Math.min(deviation, Types.difference(inputType, outputType)))) continue;
                bestMatch = outputIterator.previousIndex();
            }
            if (bestMatch < 0) {
                if (discardUnused) continue;
                throw new IllegalArgumentException("No matching output parameter was found for input %s parameter at index %d.".formatted(inputType, inputIndex));
            }
            order[bestMatch] = inputIndex;
            outputTypes.set(bestMatch, null);
        }
        ListIterator<Class<?>> outputIterator = outputTypes.listIterator();
        while (outputIterator.hasNext()) {
            Class<?> parameterType = outputIterator.next();
            if (parameterType == null) continue;
            throw new IllegalArgumentException("No matching input parameter was found for output %s parameter at index %d.".formatted(parameterType, outputIterator.previousIndex()));
        }
        if (inputTypes.length != outputTypes.size() || IntStream.range(0, order.length).anyMatch(index -> order[index] != index)) {
            return MethodHandles.permuteArguments(handle, type, order);
        }
        return handle.asType(type);
    }

    public static MethodHandle adapt(long flags, MethodHandle handle, Class<?> ... parameterTypes) {
        return Invoker.adapt(flags, handle, MethodType.methodType(handle.type().returnType(), parameterTypes));
    }

    public static MethodHandle adapt(long flags, MethodHandle handle, List<? extends Class<?>> parameterTypes) {
        return Invoker.adapt(flags, handle, MethodType.methodType(handle.type().returnType(), parameterTypes));
    }

    public static MethodHandle adapt(MethodHandle handle, MethodType type) {
        return Invoker.adapt(0L, handle, type);
    }

    public static MethodHandle adapt(MethodHandle handle, Class<?> ... parameterTypes) {
        return Invoker.adapt(0L, handle, parameterTypes);
    }

    public static MethodHandle adapt(MethodHandle handle, List<? extends Class<?>> parameterTypes) {
        return Invoker.adapt(0L, handle, parameterTypes);
    }
}

