/*
 * Decompiled with CFR 0.152.
 */
package net.auoeke.reflect;

import java.lang.annotation.Annotation;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.auoeke.reflect.AccessibleObjects;
import net.auoeke.reflect.CacheMap;
import net.auoeke.reflect.Flags;
import net.auoeke.reflect.Invoker;
import net.auoeke.reflect.Reflect;
import net.auoeke.reflect.Types;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class Methods {
    public static <T extends Executable> T find(long flags, int offset, Stream<T> methods, Object ... arguments) {
        return (T)((Executable)methods.filter(method -> Types.canCast(flags, offset, method.getParameterTypes(), arguments)).findAny().orElse(null));
    }

    public static <T extends Executable> T find(int offset, Stream<T> methods, Class<?> ... parameterTypes) {
        return (T)((Executable)methods.filter(method -> Types.canCast(0L, offset, method.getParameterTypes(), parameterTypes)).findAny().orElse(null));
    }

    public static <T extends Executable> T find(long flags, Stream<T> methods, Object ... arguments) {
        return Methods.find(flags, 0, methods, arguments);
    }

    public static <T extends Executable> T find(int offset, Stream<T> methods, Object ... arguments) {
        return Methods.find(7L, offset, methods, arguments);
    }

    public static <T extends Executable> T find(Stream<T> methods, Object ... arguments) {
        return Methods.find(7L, 0, methods, arguments);
    }

    public static <T extends Executable> T find(Stream<T> methods, Class<?> ... parameterTypes) {
        return Methods.find(0, methods, parameterTypes);
    }

    public static Method[] direct(Class<?> type) {
        return ( /* dynamic constant */ (Object)ConstantBootstraps.invoke("0", new Object[]{lambda$direct$5()})).invoke(type);
    }

    public static Stream<Method> of(Class<?> type) {
        return Stream.of(((CacheMap)( /* dynamic constant */ (Object)ConstantBootstraps.invoke("1", new Object[]{identity()}))).computeIfAbsent(type, Methods::direct));
    }

    public static Stream<Method> of(Class<?> type, String name) {
        return Stream.of(((CacheMap)( /* dynamic constant */ (Object)ConstantBootstraps.invoke("2", new Object[]{identity()}))).computeIfAbsent(type, t -> CacheMap.hash()).computeIfAbsent(name, n -> (Method[])Methods.of(type).filter(method -> method.getName().equals(n)).toArray(Method[]::new)));
    }

    public static Method firstOf(Class<?> type, String name) {
        return Methods.of(type, name).findAny().orElse(null);
    }

    public static Method of(Class<?> type, String name, Class<?> ... parameterTypes) {
        return ((CacheMap)( /* dynamic constant */ (Object)ConstantBootstraps.invoke("3", new Object[]{hash()}))).computeIfAbsent(new CacheKey(type, name, parameterTypes), key -> Methods.of(key.owner()).filter(method -> method.getName().equals(key.name()) && Arrays.equals(method.getParameterTypes(), key.parameterTypes())).findFirst().orElse(null));
    }

    public static Method any(Class<?> type, String name) {
        return Types.hierarchy(type).flatMap(Methods::of).filter(method -> method.getName().equals(name)).findAny().orElse(null);
    }

    public static Method any(Class<?> type, String name, Class<?> ... parameterTypes) {
        return Types.hierarchy(type).map(t -> Methods.of(t, name, parameterTypes)).filter(Objects::nonNull).findAny().orElse(null);
    }

    public static Method copy(Method method) {
        Object copy =  /* dynamic constant */ (Object)ConstantBootstraps.invoke("4", new Object[]{lambda$copy$14()});
        Object leafCopy =  /* dynamic constant */ (Object)ConstantBootstraps.invoke("5", new Object[]{lambda$copy$15()});
        return method == null ? null : (AccessibleObjects.root(method) == null ? copy : leafCopy).invokeExact(method);
    }

    public static MethodType type(Method method) {
        return MethodType.methodType(method.getReturnType(), method.getParameterTypes());
    }

    public static <T> T defaultValue(Class<? extends Annotation> type, String name) {
        return (T)Methods.firstOf(type, name).getDefaultValue();
    }

    public static boolean overrides(Method implementation, Method base) {
        if (Types.isSubtype(implementation.getDeclaringClass(), base.getDeclaringClass()) && implementation.getName().equals(base.getName())) {
            return implementation.getReturnType() == base.getReturnType() && Arrays.equals(implementation.getParameterTypes(), base.getParameterTypes());
        }
        return false;
    }

    public static Stream<Method> filterBase(Stream<Method> methods) {
        return Methods.filter(methods, false);
    }

    public static Stream<Method> filterOverriding(Stream<Method> methods) {
        return Methods.filter(methods, true);
    }

    public static Stream<Method> overridden(Class<?> implementor) {
        Set methods = Methods.of(implementor).filter(Flags::isInstance).map(Descriptor::new).collect(Collectors.toSet());
        return Types.baseTypes(implementor).flatMap(Methods::of).filter(base -> Flags.isInstance(base) && methods.contains(new Descriptor((Method)base)));
    }

    public static Method sam(Class<?> implementor) {
        Object[] ams = Methods.filterBase(Methods.overridden(implementor).filter(Flags::isAbstract)).toArray();
        return ams.length == 1 ? (Method)ams[0] : null;
    }

    private static Stream<Method> filter(Stream<Method> methods, boolean override) {
        HashMap types = new HashMap();
        methods.forEach(method -> {
            List methodList = types.computeIfAbsent(new Descriptor((Method)method), descriptor -> new ArrayList());
            ListIterator<Method> iterator = methodList.listIterator();
            while (iterator.hasNext()) {
                Method existingMethod = (Method)iterator.next();
                if (override ? Types.isSubtype(method.getDeclaringClass(), existingMethod.getDeclaringClass()) : Types.isSubtype(existingMethod.getDeclaringClass(), method.getDeclaringClass())) {
                    iterator.set((Method)method);
                    return;
                }
                if (!(override ? method.getDeclaringClass().isAssignableFrom(existingMethod.getDeclaringClass()) : existingMethod.getDeclaringClass().isAssignableFrom(method.getDeclaringClass()))) continue;
                return;
            }
            methodList.add(method);
        });
        return types.values().stream().flatMap(Collection::stream);
    }

    private static /* synthetic */ MethodHandle lambda$copy$15() {
        return Invoker.findSpecial(Method.class, "leafCopy", Method.class);
    }

    private static /* synthetic */ MethodHandle lambda$copy$14() {
        return Invoker.findSpecial(Method.class, "copy", Method.class);
    }

    private static /* synthetic */ MethodHandle lambda$direct$5() {
        return Stream.of(Class.class.getDeclaredMethods()).filter(method -> Flags.isNative(method) && method.getReturnType() == Method[].class).map(Invoker::unreflectSpecial).map(method -> method.type().parameterCount() > 1 ? MethodHandles.insertArguments(method, 1, false) : method).max(Comparator.comparing(method -> method.invoke(Reflect.class).length)).get();
    }

    private record CacheKey(Class<?> owner, String name, Class<?>[] parameterTypes) {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            if (!(object instanceof CacheKey)) return false;
            CacheKey key = (CacheKey)object;
            if (this.owner != key.owner) return false;
            if (!this.name.equals(key.name)) return false;
            if (!Arrays.equals(this.parameterTypes, key.parameterTypes)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.owner.hashCode() ^ this.name.hashCode() ^ Arrays.hashCode(this.parameterTypes);
        }
    }

    private record Descriptor(Class<?> returnType, String name, Class<?>[] parameterTypes) {
        private Descriptor(Method method) {
            this(method.getReturnType(), method.getName(), method.getParameterTypes());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Descriptor)) return false;
            Descriptor descriptor = (Descriptor)object;
            if (this.returnType != descriptor.returnType) return false;
            if (!this.name.equals(descriptor.name)) return false;
            if (!Arrays.equals(this.parameterTypes, descriptor.parameterTypes)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.returnType.hashCode() ^ this.name.hashCode() ^ Arrays.hashCode(this.parameterTypes);
        }
    }
}

